/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.operation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jackson.jsonpointer.TokenResolver;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.JsonPatchMessages;
import com.github.fge.jsonpatch.operation.JsonPatchOperation;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.collect.Iterables;
import java.io.IOException;

public final class RemoveOperation
implements JsonPatchOperation {
    public static final String OPERATION_NAME = "remove";
    protected static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonPatchMessages.class);
    protected final String op;
    protected final JsonPointer path;

    @JsonCreator
    public RemoveOperation(@JsonProperty(value="path") JsonPointer path) {
        this.op = OPERATION_NAME;
        this.path = path;
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        if (this.path.isEmpty()) {
            return MissingNode.getInstance();
        }
        if (((JsonNode)this.path.path((TreeNode)node)).isMissingNode()) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.noSuchPath"));
        }
        JsonNode ret = node.deepCopy();
        JsonNode parentNode = (JsonNode)this.path.parent().get((TreeNode)ret);
        String raw = ((TokenResolver)Iterables.getLast((Iterable)this.path)).getToken().getRaw();
        if (parentNode.isObject()) {
            ((ObjectNode)parentNode).remove(raw);
        } else {
            ((ArrayNode)parentNode).remove(Integer.parseInt(raw));
        }
        return ret;
    }

    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        jgen.writeStringField("op", OPERATION_NAME);
        jgen.writeStringField("path", this.path.toString());
        jgen.writeEndObject();
    }

    public void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        this.serialize(jgen, provider);
    }

    @Override
    public String toString() {
        return "op: " + this.op + "; path: \"" + this.path + '\"';
    }
}

