/*
 * Decompiled with CFR 0.152.
 */
package com.bpfaas.common.utils;

import com.bpfaas.common.exception.BpExecuteCommandException;
import com.bpfaas.common.utils.ICommandStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandUtils {
    private static final Logger log = LoggerFactory.getLogger(CommandUtils.class);

    public static ExecResult exec(String cmd) throws BpExecuteCommandException {
        return CommandUtils.exec(new String[]{cmd}, null, null, null, null);
    }

    public static ExecResult exec(String cmd, ICommandStream infoStream, ICommandStream errStream) throws BpExecuteCommandException {
        return CommandUtils.exec(new String[]{cmd}, null, null, infoStream, errStream);
    }

    public static ExecResult exec(String[] cmdarray) throws BpExecuteCommandException {
        return CommandUtils.exec(cmdarray, null, null, null, null);
    }

    public static ExecResult exec(String[] cmdarray, ICommandStream infoStream, ICommandStream errStream) throws BpExecuteCommandException {
        return CommandUtils.exec(cmdarray, null, null, infoStream, errStream);
    }

    public static ExecResult exec(String[] cmdarray, String[] envp) throws BpExecuteCommandException {
        return CommandUtils.exec(cmdarray, envp, null, null, null);
    }

    public static ExecResult exec(String[] cmdarray, String[] envp, ICommandStream infoStream, ICommandStream errStream) throws BpExecuteCommandException {
        return CommandUtils.exec(cmdarray, envp, null, infoStream, errStream);
    }

    public static ExecResult exec(String[] cmdarray, String[] envp, String dir, ICommandStream infoStream, ICommandStream errStream) throws BpExecuteCommandException {
        try {
            Process process = Runtime.getRuntime().exec(cmdarray, envp, dir == null ? null : new File(dir));
            ExecResult result = new ExecResult();
            try {
                String line;
                if (errStream != null) {
                    BufferedReader brError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    while ((line = brError.readLine()) != null) {
                        errStream.onStream(line);
                    }
                    brError.close();
                }
                if (infoStream != null) {
                    BufferedReader brInfo = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((line = brInfo.readLine()) != null) {
                        infoStream.onStream(line);
                    }
                    brInfo.close();
                }
            }
            catch (Exception e) {
                log.error("exec stream error", (Throwable)e);
            }
            process.waitFor();
            result.code = process.exitValue();
            return result;
        }
        catch (Exception e) {
            log.error("exec error", (Throwable)e);
            throw new BpExecuteCommandException(e);
        }
    }

    public static class ExecResult {
        public int code;
    }
}

