/*
 * Decompiled with CFR 0.152.
 */
package com.bpfaas.common.utils;

import com.bpfaas.common.exception.BpException;
import com.bpfaas.common.utils.PathUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class FileUtils {
    public static boolean assureDir(String destDirPath) throws BpException {
        if (!destDirPath.endsWith(File.separator)) {
            destDirPath = destDirPath + File.separator;
        }
        try {
            File dir = new File(destDirPath);
            if (dir.exists() && dir.isDirectory()) {
                return false;
            }
            return dir.mkdirs();
        }
        catch (Exception e) {
            throw new BpException("fileRemove error", e);
        }
    }

    public static void dirCopy(String src, String dest) throws BpException {
        File start = new File(src);
        File end = new File(dest);
        String[] filePath = start.list();
        if (!end.exists()) {
            end.mkdir();
        }
        for (String temp : filePath) {
            String dir = PathUtils.join(src, temp);
            if (src.equals(dir)) continue;
            if (new File(PathUtils.join(src, temp)).isDirectory()) {
                FileUtils.dirCopy(PathUtils.join(src, temp), PathUtils.join(dest, temp));
                continue;
            }
            FileUtils.fileCopy(PathUtils.join(src, temp), PathUtils.join(dest, temp));
        }
    }

    public static boolean dirRemoveRecursive(String path) throws BpException {
        File[] files;
        File file = new File(path);
        if (!file.exists()) {
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        for (File f : files = file.listFiles()) {
            if (f.isFile()) {
                try {
                    if (f.delete()) continue;
                    return false;
                }
                catch (Exception e) {
                    throw new BpException("fileRemove error", e);
                }
            }
            if (FileUtils.dirRemoveRecursive(f.getAbsolutePath())) continue;
            return false;
        }
        try {
            return file.delete();
        }
        catch (Exception e) {
            throw new BpException("fileRemove error", e);
        }
    }

    public static boolean fileRemove(String path) throws BpException {
        File file = new File(path);
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            try {
                return file.delete();
            }
            catch (Exception e) {
                throw new BpException("fileRemove error", e);
            }
        }
        return false;
    }

    public static void fileCopy(String src, String dest) throws BpException {
        File start = new File(src);
        File end = new File(dest);
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(start));
             BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(end));){
            int len = 0;
            byte[] flush = new byte[1024];
            while ((len = bis.read(flush)) != -1) {
                bos.write(flush, 0, len);
            }
            bos.flush();
        }
        catch (Exception e) {
            throw new BpException("fileCopy error", e);
        }
    }

    public static String readFile(InputStream is, String charsetName) throws IOException {
        int i;
        StringBuilder content = new StringBuilder();
        byte[] buf = new byte[1024];
        do {
            if ((i = is.read(buf, 0, buf.length)) <= 0) continue;
            content.append(new String(buf, 0, i, charsetName));
        } while (i >= buf.length);
        return content.toString();
    }

    public static String readFile(File file, String charsetName) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            int i;
            StringBuilder content = new StringBuilder();
            byte[] buf = new byte[1024];
            do {
                if ((i = ((InputStream)is).read(buf, 0, buf.length)) <= 0) continue;
                content.append(new String(buf, 0, i, charsetName));
            } while (i >= buf.length);
            String string = content.toString();
            return string;
        }
    }

    public static String readFile(File file) throws IOException {
        return FileUtils.readFile(file, StandardCharsets.UTF_8.name());
    }

    public static String readFile(String filepath, String charsetName) throws IOException {
        return FileUtils.readFile(new File(filepath), charsetName);
    }

    public static String readFile(String filepath) throws IOException {
        return FileUtils.readFile(new File(filepath), StandardCharsets.UTF_8.name());
    }

    public static void writeFile(File file, String content, String charsetName) throws IOException {
        try (FileOutputStream os = new FileOutputStream(file);){
            ((OutputStream)os).write(content.getBytes(charsetName));
        }
    }

    public static void writeFile(File file, String content) throws IOException {
        FileUtils.writeFile(file, content, StandardCharsets.UTF_8.name());
    }

    public static void writeFile(String filepath, String content, String charsetName) throws IOException {
        FileUtils.writeFile(new File(filepath), content, charsetName);
    }

    public static void writeFile(String filepath, String content) throws IOException {
        FileUtils.writeFile(new File(filepath), content, StandardCharsets.UTF_8.name());
    }
}

