/*
 * Decompiled with CFR 0.152.
 */
package com.bpfaas.common.utils;

import com.bpfaas.common.exception.BpJsonException;
import com.bpfaas.common.utils.JsonFloatSerializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

public class JsonUtils {
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static Object parse(String text) throws BpJsonException {
        try {
            return objectMapper.readValue(text, Object.class);
        }
        catch (JsonParseException ex) {
            throw new BpJsonException(ex);
        }
        catch (JsonMappingException ex) {
            throw new BpJsonException(ex);
        }
        catch (IOException ex) {
            throw new BpJsonException(ex);
        }
    }

    public static <T> T parse(String text, Class<T> valueType) throws BpJsonException {
        try {
            return (T)objectMapper.readValue(text, valueType);
        }
        catch (JsonParseException ex) {
            throw new BpJsonException(ex);
        }
        catch (JsonMappingException ex) {
            throw new BpJsonException(ex);
        }
        catch (IOException ex) {
            throw new BpJsonException(ex);
        }
    }

    public static <T> T parse(String text, final ParameterizedType valueType) throws BpJsonException {
        try {
            TypeReference typeReference = new TypeReference<T>(){

                public Type getType() {
                    return valueType;
                }
            };
            return (T)objectMapper.readValue(text, typeReference);
        }
        catch (JsonParseException ex) {
            throw new BpJsonException(ex);
        }
        catch (JsonMappingException ex) {
            throw new BpJsonException(ex);
        }
        catch (IOException ex) {
            throw new BpJsonException(ex);
        }
    }

    public static String stringify(Object obj) throws BpJsonException {
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new BpJsonException(e);
        }
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        objectMapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.PUBLIC_ONLY);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        SimpleDateFormat sdFmt = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        objectMapper.setTimeZone(TimeZone.getTimeZone("GMT"));
        objectMapper.setDateFormat((DateFormat)sdFmt);
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(BigDecimal.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(BigInteger.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(Float.class, (JsonSerializer)JsonFloatSerializer.instance);
        simpleModule.addSerializer(Float.TYPE, (JsonSerializer)JsonFloatSerializer.instance);
        simpleModule.addSerializer(Double.class, (JsonSerializer)JsonFloatSerializer.instance);
        simpleModule.addSerializer(Double.TYPE, (JsonSerializer)JsonFloatSerializer.instance);
        objectMapper.registerModule((Module)simpleModule);
    }
}

