/*
 * Decompiled with CFR 0.152.
 */
package com.bpfaas.common.web;

import com.bpfaas.common.exception.BpMsgException;
import com.bpfaas.common.web.ErrorCode;
import com.bpfaas.common.web.MsgBase;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Msg<T>
extends MsgBase {
    @JsonProperty(value="err")
    private ErrorCode err;
    @JsonProperty(value="err_msg")
    private String errMsg;
    @JsonProperty(value="err_subcode")
    private String errSubCode;
    @JsonProperty(value="data")
    private T data;

    @JsonProperty(value="err_code")
    public int getErrCode() {
        return this.err.getValue();
    }

    @JsonProperty(value="err_code")
    public void setErrCode(int v) {
        this.err = ErrorCode.fromCode(v);
    }

    public T getData() {
        return this.data;
    }

    public Msg() {
        this.err = ErrorCode.OK;
    }

    public Msg(T data) {
        this.err = ErrorCode.OK;
        this.data = data;
    }

    public Msg(ErrorCode err) {
        this.err = err;
    }

    public Msg(ErrorCode err, String errMsg) {
        this.err = err;
        this.errMsg = errMsg;
    }

    @JsonIgnore
    public void setDataWithObject(T data) {
        this.data = data;
    }

    public void setData(String key, Object value) {
        if (null == value) {
            this.removeData(key);
            return;
        }
        if (null == this.data) {
            try {
                this.data = new HashMap();
            }
            catch (ClassCastException e) {
                throw new BpMsgException("cannot invoke Msg.setData, because its data has a Type.", e);
            }
        } else if (!(this.data instanceof HashMap)) {
            throw new BpMsgException("cannot invoke Msg.setData, because its data has a Type.");
        }
        ((Map)this.data).put(key, value);
    }

    public void removeData(String key) {
        if (this.data == null) {
            return;
        }
        if (!(this.data instanceof HashMap)) {
            throw new BpMsgException("cannot invoke Msg.removeData, because its data has a Type.");
        }
        ((Map)this.data).remove(key);
    }

    public <T1> T1 getData(String key) {
        if (null == this.data || null == key || !(this.data instanceof HashMap)) {
            return null;
        }
        try {
            return (T1)((Map)this.data).get(key);
        }
        catch (ClassCastException e) {
            throw new BpMsgException("cannot invoke Msg.getData, because its data has a Type.", e);
        }
    }

    @JsonProperty(value="err")
    public void setErr(ErrorCode err) {
        this.err = err;
    }

    public ErrorCode getErr() {
        return this.err;
    }

    @JsonProperty(value="err_msg")
    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    @JsonProperty(value="err_subcode")
    public void setErrSubCode(String errSubCode) {
        this.errSubCode = errSubCode;
    }

    public String getErrSubCode() {
        return this.errSubCode;
    }
}

