/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions;

import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.rules.Rule;
import com.bpodgursky.jbool_expressions.rules.RulesHelper;
import com.google.common.base.Optional;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class Not<K>
extends Expression<K> {
    public static final String EXPR_TYPE = "not";
    private Optional<String> cachedStringRepresentation = Optional.absent();
    private final Expression<K> e;

    private Not(Expression<K> e) {
        this.e = e;
    }

    public Expression<K> getE() {
        return this.e;
    }

    public String toString() {
        if (!this.cachedStringRepresentation.isPresent()) {
            this.cachedStringRepresentation = Optional.of((Object)("!" + this.e));
        }
        return (String)this.cachedStringRepresentation.get();
    }

    @Override
    public Expression<K> apply(List<Rule<?, K>> rules) {
        return new Not<K>(RulesHelper.applyAll(this.e, rules));
    }

    @Override
    public Expression<K> sort(Comparator<Expression> comparator) {
        return Not.of(this.e.sort(comparator));
    }

    public static <K> Not<K> of(Expression<K> e) {
        return new Not<K>(e);
    }

    @Override
    public String getExprType() {
        return EXPR_TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Not not = (Not)o;
        return Objects.equals(this.e, not.e);
    }

    public int hashCode() {
        return Objects.hash(this.e);
    }
}

