/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions.parsers;

import com.bpodgursky.jbool_expressions.And;
import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.Literal;
import com.bpodgursky.jbool_expressions.Not;
import com.bpodgursky.jbool_expressions.Or;
import com.bpodgursky.jbool_expressions.Variable;
import com.bpodgursky.jbool_expressions.parsers.BooleanExprLexer;
import com.bpodgursky.jbool_expressions.parsers.BooleanExprParser;
import com.bpodgursky.jbool_expressions.parsers.IdentityMap;
import com.bpodgursky.jbool_expressions.parsers.TokenMapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;

public class ExprParser {
    public static Expression<String> parse(String expression) {
        return ExprParser.parse(expression, new IdentityMap());
    }

    public static <T> Expression<T> parse(String expression, TokenMapper<T> mapper) {
        try {
            ANTLRStringStream input = new ANTLRStringStream(expression);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)new BooleanExprLexer((CharStream)input));
            BooleanExprParser parser = new BooleanExprParser((TokenStream)tokens);
            BooleanExprParser.expression_return ret = parser.expression();
            CommonTree ast = (CommonTree)ret.getTree();
            return ExprParser.parse((Tree)ast, mapper);
        }
        catch (RecognitionException e) {
            throw new IllegalStateException("Recognition exception is never thrown, only declared.");
        }
    }

    public static <T> Expression<T> parse(Tree tree, TokenMapper<T> mapper) {
        if (tree.getType() == 4) {
            ArrayList children = Lists.newArrayList();
            for (int i = 0; i < tree.getChildCount(); ++i) {
                children.add(ExprParser.parse(tree.getChild(i), mapper));
            }
            return And.of(children);
        }
        if (tree.getType() == 9) {
            ArrayList children = Lists.newArrayList();
            for (int i = 0; i < tree.getChildCount(); ++i) {
                children.add(ExprParser.parse(tree.getChild(i), mapper));
            }
            return Or.of(children);
        }
        if (tree.getType() == 8) {
            return Not.of(ExprParser.parse(tree.getChild(0), mapper));
        }
        if (tree.getType() == 7) {
            return Variable.of(mapper.getVariable(tree.getText()));
        }
        if (tree.getType() == 10) {
            return Variable.of(mapper.getVariable(tree.getText()));
        }
        if (tree.getType() == 12) {
            return Literal.getTrue();
        }
        if (tree.getType() == 5) {
            return Literal.getFalse();
        }
        throw new RuntimeException("Unrecognized! " + tree.getType() + " " + tree.getText());
    }
}

