/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions;

import com.bpodgursky.jbool_expressions.ExprUtil;
import com.bpodgursky.jbool_expressions.Expression;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class NExpression<K>
extends Expression<K> {
    public final Expression<K>[] expressions;
    private int hashCode;

    protected NExpression(Expression<K>[] expressions, int seed, Comparator<Expression> sort) {
        if (expressions.length == 0) {
            throw new IllegalArgumentException("Arguments length 0!");
        }
        this.expressions = Arrays.copyOf(expressions, expressions.length);
        Arrays.sort(this.expressions, sort);
        this.hashCode = Objects.hash(seed, Arrays.hashCode(this.expressions));
    }

    @Override
    public List<Expression<K>> getChildren() {
        return ExprUtil.list(this.expressions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NExpression that = (NExpression)o;
        return this.hashCode == that.hashCode && Arrays.equals(this.expressions, that.expressions);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public void collectK(Set<K> set, int limit) {
        if (set.size() >= limit) {
            return;
        }
        for (Expression<K> expression : this.expressions) {
            expression.collectK(set, limit);
        }
    }
}

