/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions.cache;

import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.InternFunction;
import com.bpodgursky.jbool_expressions.cache.RuleSetCache;
import com.bpodgursky.jbool_expressions.options.ExprOptions;
import com.bpodgursky.jbool_expressions.rules.RuleList;
import com.bpodgursky.jbool_expressions.util.ExprFactory;
import java.util.HashMap;
import java.util.Map;

public class UnboundedRuleSetCache<K>
implements RuleSetCache<K> {
    private final Map<String, Map<Expression<K>, Expression<K>>> cacheByRuleSet = new HashMap<String, Map<Expression<K>, Expression<K>>>();
    private final InternFunction<K> interningFunction;

    public UnboundedRuleSetCache(InternFunction<K> interningFunction) {
        this.interningFunction = interningFunction;
    }

    @Override
    public Expression<K> get(RuleList<K> rules, Expression<K> input) {
        Map<Expression<K>, Expression<K>> cache = this.cacheByRuleSet.get(rules.getKey());
        if (cache == null) {
            return null;
        }
        return cache.get(input);
    }

    @Override
    public void put(RuleList<K> rules, Expression<K> input, Expression<K> output, ExprOptions<K> options) {
        String ruleKey = rules.getKey();
        if (!this.cacheByRuleSet.containsKey(ruleKey)) {
            this.cacheByRuleSet.put(ruleKey, new HashMap());
        }
        Map<Expression<Expression<K>>, Expression<Expression<K>>> cache = this.cacheByRuleSet.get(ruleKey);
        ExprFactory<K> factory = options.getExprFactory();
        Expression<K> shrunkInput = input.map(this.interningFunction, factory);
        Expression<K> shrunkOutput = output.map(this.interningFunction, factory);
        cache.put(shrunkInput, shrunkOutput);
    }
}

