/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions.rules;

import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.options.ExprOptions;
import com.bpodgursky.jbool_expressions.rules.CollapseNegation;
import com.bpodgursky.jbool_expressions.rules.CombineAnd;
import com.bpodgursky.jbool_expressions.rules.CombineOr;
import com.bpodgursky.jbool_expressions.rules.DeMorgan;
import com.bpodgursky.jbool_expressions.rules.Rule;
import com.bpodgursky.jbool_expressions.rules.RuleList;
import com.bpodgursky.jbool_expressions.rules.SimplifyAnd;
import com.bpodgursky.jbool_expressions.rules.SimplifyNExprChildren;
import com.bpodgursky.jbool_expressions.rules.SimplifyNExpression;
import com.bpodgursky.jbool_expressions.rules.SimplifyNot;
import com.bpodgursky.jbool_expressions.rules.SimplifyOr;
import com.bpodgursky.jbool_expressions.rules.ToSOP;
import java.util.ArrayList;

public class RulesHelper {
    public static <K> RuleList<K> simplifyRules() {
        ArrayList rules = new ArrayList();
        rules.add(new SimplifyAnd());
        rules.add(new SimplifyOr());
        rules.add(new SimplifyNot());
        rules.add(new CombineAnd());
        rules.add(new CombineOr());
        rules.add(new SimplifyNExpression());
        rules.add(new SimplifyNExprChildren());
        rules.add(new CollapseNegation());
        return new RuleList(rules);
    }

    public static <K> RuleList<K> toSopRules() {
        ArrayList rules = new ArrayList(RulesHelper.simplifyRules().getRules());
        rules.add(new ToSOP());
        return new RuleList<K>(rules);
    }

    public static <K> RuleList<K> demorganRules() {
        ArrayList rules = new ArrayList(RulesHelper.simplifyRules().getRules());
        rules.add(new DeMorgan());
        return new RuleList<K>(rules);
    }

    public static <K> Expression<K> applyAll(Expression<K> e, RuleList<K> rules, ExprOptions<K> options) {
        Expression<K> cached = options.getRuleSetCache().get(rules, e);
        if (cached != null) {
            return cached;
        }
        Expression<K> orig = e;
        Expression<K> simplified = RulesHelper.applyAllSingle(orig, rules, options);
        while (!orig.equals(simplified)) {
            orig = simplified;
            simplified = RulesHelper.applyAllSingle(orig, rules, options);
        }
        options.getRuleSetCache().put(rules, e, simplified, options);
        return simplified;
    }

    private static <K> Expression<K> applyAllSingle(Expression<K> e, RuleList<K> rules, ExprOptions<K> options) {
        Expression<K> cachedSet = options.getRuleSetCache().get(rules, e);
        if (cachedSet != null) {
            return cachedSet;
        }
        Expression<K> tmp = e.apply(rules, options);
        for (Rule<?, K> r : rules.getRules()) {
            Expression<K> input = tmp;
            Expression<K> cachedRule = options.getRuleCache().get(r.getClass(), input);
            if (cachedRule != null) {
                tmp = cachedRule;
                continue;
            }
            Expression<K> old = tmp;
            if (old.equals(tmp = r.apply(tmp, options))) continue;
            options.getRuleCache().put(r.getClass(), input, tmp, options);
        }
        return tmp;
    }

    public static <K> Expression<K> applySet(Expression<K> root, RuleList<K> allRules, ExprOptions<K> options) {
        return RulesHelper.applyAll(root, allRules, options);
    }
}

