/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions.rules;

import com.bpodgursky.jbool_expressions.And;
import com.bpodgursky.jbool_expressions.ExprUtil;
import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.NExpression;
import com.bpodgursky.jbool_expressions.Not;
import com.bpodgursky.jbool_expressions.Or;
import com.bpodgursky.jbool_expressions.options.ExprOptions;
import com.bpodgursky.jbool_expressions.rules.Rule;

public class CollapseNegation<K>
extends Rule<NExpression<K>, K> {
    @Override
    public Expression<K> applyInternal(NExpression<K> input, ExprOptions<K> options) {
        NExpression child;
        if (input instanceof Or) {
            Or inOr = (Or)input;
            for (Expression<K> expression : input.getChildren()) {
                if (!(expression instanceof And)) continue;
                child = (And)expression;
                for (Expression<K> otherChild : input.getChildren()) {
                    for (Expression subChild : child.getChildren()) {
                        if (!this.areNegation(subChild, otherChild)) continue;
                        return ExprUtil.stripNegation(inOr, child, subChild, options);
                    }
                }
            }
        }
        if (input instanceof And) {
            And andIn = (And)input;
            for (Expression<K> expression : input.getChildren()) {
                if (!(expression instanceof Or)) continue;
                child = (Or)expression;
                for (Expression<K> otherChild : input.getChildren()) {
                    for (Expression subChild : child.getChildren()) {
                        if (!this.areNegation(subChild, otherChild)) continue;
                        return ExprUtil.stripNegation(andIn, child, subChild, options);
                    }
                }
            }
        }
        return input;
    }

    private boolean areNegation(Expression<K> child1, Expression<K> child2) {
        Not child2Not;
        Not child1Not;
        if (child1 instanceof Not && (child1Not = (Not)child1).getE().equals(child2)) {
            return true;
        }
        return child2 instanceof Not && (child2Not = (Not)child2).getE().equals(child1);
    }

    @Override
    protected boolean isApply(Expression<K> input) {
        return input instanceof NExpression;
    }
}

