/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions.rules;

import com.bpodgursky.jbool_expressions.rules.Rule;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public class RuleList<K> {
    private final List<Rule<?, K>> rules;
    private final String key;

    public RuleList(List<Rule<?, K>> rules) {
        this.rules = rules;
        ArrayList<String> names = new ArrayList<String>();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            for (Rule<?, K> rule : rules) {
                names.add(rule.getClass().getName());
            }
            byte[] hash = digest.digest(String.join((CharSequence)",", names).getBytes());
            this.key = new String(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Rule<?, K>> getRules() {
        return this.rules;
    }

    public String getKey() {
        return this.key;
    }
}

