/*
 * Decompiled with CFR 0.152.
 */
package com.bq.corbel.webfs;

import com.bq.corbel.lib.ws.cli.ServiceRunnerWithVersionResource;
import com.bq.corbel.lib.ws.health.BasicHealthCheck;
import com.bq.corbel.webfs.api.WebResource;
import com.bq.corbel.webfs.ioc.WebfsIoc;
import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.setup.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class WebfsRunner
extends ServiceRunnerWithVersionResource<WebfsIoc> {
    private static final Logger LOG = LoggerFactory.getLogger(WebfsRunner.class);

    public static void main(String[] args) {
        try {
            new WebfsRunner().run(args);
        }
        catch (Exception e) {
            LOG.error("Unable to start webfs", (Throwable)e);
        }
    }

    protected String getArtifactId() {
        return "webfs";
    }

    protected void configureService(Environment environment, ApplicationContext context) {
        super.configureService(environment, context);
        environment.jersey().register(context.getBean(WebResource.class));
        environment.healthChecks().register("basic", (HealthCheck)new BasicHealthCheck());
    }
}

