/*
 * Decompiled with CFR 0.152.
 */
package com.bq.corbel.webfs.api;

import com.amazonaws.services.s3.model.S3Object;
import com.bq.corbel.lib.ws.api.error.ErrorResponseFactory;
import com.bq.corbel.webfs.service.AmazonS3Service;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Path(value="v1.0/{domain}/path")
public class WebResource {
    private final AmazonS3Service amazonS3Service;

    public WebResource(AmazonS3Service amazonS3Service) {
        this.amazonS3Service = amazonS3Service;
    }

    @GET
    @Path(value="/{path: .*}")
    public Response getResource(@PathParam(value="domain") String domain, @PathParam(value="path") String path, @HeaderParam(value="Accept") String accept) {
        S3Object object = this.amazonS3Service.getObject(domain + "/" + path);
        if (object != null) {
            accept = accept == null || accept.startsWith("*/*") ? object.getObjectMetadata().getContentType() : accept.split(",")[0].split(";")[0];
            return Response.ok().type(accept).entity((Object)object.getObjectContent()).build();
        }
        return ErrorResponseFactory.getInstance().notFound();
    }

    @DELETE
    @Path(value="/{path: .*}")
    public Response deleteFolder(@PathParam(value="domain") String domain, @PathParam(value="path") String path) {
        this.amazonS3Service.deleteFolder(domain + "/" + path);
        return Response.noContent().build();
    }
}

