/*
 * Decompiled with CFR 0.152.
 */
package com.bq.corbel.webfs.service;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.bq.corbel.webfs.service.AmazonS3Service;

public class DefaultAmazonS3Service
implements AmazonS3Service {
    private final AmazonS3 amazonS3Client;
    private final String bucket;

    public DefaultAmazonS3Service(AmazonS3 amazonS3Client, String bucket) {
        this.amazonS3Client = amazonS3Client;
        this.bucket = bucket;
    }

    @Override
    public S3Object getObject(String key) {
        GetObjectRequest objectRequest = new GetObjectRequest(this.bucket, key);
        try {
            return this.amazonS3Client.getObject(objectRequest);
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public void deleteFolder(String path) {
        ObjectListing objectListing;
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.bucket).withPrefix(path);
        do {
            objectListing = this.amazonS3Client.listObjects(listObjectsRequest);
            for (S3ObjectSummary objectSummary : objectListing.getObjectSummaries()) {
                this.amazonS3Client.deleteObject(new DeleteObjectRequest(this.bucket, objectSummary.getKey()));
            }
            listObjectsRequest.setMarker(objectListing.getNextMarker());
        } while (objectListing.isTruncated());
    }
}

