/*
 * Decompiled with CFR 0.152.
 */
package com.braze.support;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.braze.support.BrazeLogger;
import com.braze.support.IntentUtils;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001\u001a\u0014\u0010\u000b\u001a\u00020\f*\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0001\u001a\f\u0010\r\u001a\u00020\n*\u0004\u0018\u00010\u000e\u001a\f\u0010\u000f\u001a\u00020\f*\u0004\u0018\u00010\u000e\"\u0010\u0010\u0000\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"NOTIFICATION_PERMISSION", "", "PERMISSION_STORAGE_PREFS_FILE", "TAG", "getPermissionRequestCount", "", "context", "Landroid/content/Context;", "permission", "incrementPermissionRequestCount", "", "hasPermission", "", "requestPushPermissionPrompt", "Landroid/app/Activity;", "wouldPushPermissionPromptDisplay", "android-sdk-base_release"})
public final class PermissionUtils {
    private static final String TAG = BrazeLogger.INSTANCE.getBrazeLogTag("PermissionUtils");
    private static final String PERMISSION_STORAGE_PREFS_FILE = "com.braze.support.permission_util.requested_perms";
    private static final String NOTIFICATION_PERMISSION = "android.permission.POST_NOTIFICATIONS";

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasPermission(Context $this$hasPermission, String permission) {
        void var1_4;
        Intrinsics.checkNotNullParameter((Object)var1_4, (String)"permission");
        if ($this$hasPermission == null) {
            return false;
        }
        try {
            Context context;
            if (context.checkCallingOrSelfPermission((String)var1_4) != 0) return false;
            return true;
        }
        catch (Throwable throwable) {
            Function0<String> function0;
            Function0<String> function02 = function0;
            function0 = new Function0<String>((String)var1_4){
                final /* synthetic */ String b;
                {
                    void var1_1;
                    this.b = var1_1;
                    super(0);
                }

                public final String a() {
                    return Intrinsics.stringPlus((String)"Failure checking permission ", (Object)this.b);
                }
            };
            BrazeLogger.INSTANCE.brazelog(TAG, BrazeLogger.Priority.E, throwable, function02);
            return false;
        }
    }

    public static final void requestPushPermissionPrompt(Activity $this$requestPushPermissionPrompt) {
        String[] stringArray;
        BrazeLogger brazeLogger = BrazeLogger.INSTANCE;
        String string2 = TAG;
        BrazeLogger.Priority priority = BrazeLogger.Priority.V;
        c c7 = c.b;
        BrazeLogger.brazelog$default(brazeLogger, string2, priority, null, (Function0)c7, 4, null);
        if ($this$requestPushPermissionPrompt == null) {
            stringArray = d.b;
            BrazeLogger.brazelog$default(brazeLogger, string2, null, null, (Function0)stringArray, 6, null);
            return;
        }
        if (PermissionUtils.wouldPushPermissionPromptDisplay((Activity)stringArray) && Build.VERSION.SDK_INT >= 33) {
            Object object = stringArray;
            PermissionUtils.incrementPermissionRequestCount((Context)stringArray, NOTIFICATION_PERMISSION);
            stringArray = f.b;
            BrazeLogger.brazelog$default(brazeLogger, string2, priority, null, (Function0)stringArray, 4, null);
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = NOTIFICATION_PERMISSION;
            object.requestPermissions(stringArray, IntentUtils.getRequestCode());
            return;
        }
        stringArray = e.b;
        BrazeLogger.brazelog$default(brazeLogger, string2, null, null, (Function0)stringArray, 6, null);
    }

    public static final boolean wouldPushPermissionPromptDisplay(Activity $this$wouldPushPermissionPromptDisplay) {
        Object object;
        if ($this$wouldPushPermissionPromptDisplay == null) {
            object = g.b;
            BrazeLogger.brazelog$default(BrazeLogger.INSTANCE, TAG, null, null, (Function0)object, 6, null);
            return false;
        }
        if (Build.VERSION.SDK_INT < 33) {
            BrazeLogger.brazelog$default(BrazeLogger.INSTANCE, TAG, BrazeLogger.Priority.I, null, (Function0)h.b, 4, null);
            return false;
        }
        int n7 = object.getApplicationInfo().targetSdkVersion;
        if (n7 < 33) {
            Function0<String> function0;
            object = function0;
            function0 = new Function0<String>(n7){
                final /* synthetic */ int b;
                {
                    void var1_1;
                    this.b = var1_1;
                    super(0);
                }

                public final String a() {
                    return "App Target API version of " + this.b + " is too low to display push permission prompt.";
                }
            };
            BrazeLogger.brazelog$default(BrazeLogger.INSTANCE, TAG, BrazeLogger.Priority.I, null, (Function0)object, 4, null);
            return false;
        }
        if (PermissionUtils.hasPermission((Context)object, NOTIFICATION_PERMISSION)) {
            BrazeLogger.brazelog$default(BrazeLogger.INSTANCE, TAG, BrazeLogger.Priority.I, null, (Function0)j.b, 4, null);
            return false;
        }
        n7 = PermissionUtils.getPermissionRequestCount((Context)object, NOTIFICATION_PERMISSION);
        if (n7 >= 2) {
            Function0<String> function0;
            Object object2 = object;
            object = function0;
            function0 = new Function0<String>(n7){
                final /* synthetic */ int b;
                {
                    void var1_1;
                    this.b = var1_1;
                    super(0);
                }

                public final String a() {
                    return "Notification permission request count is " + this.b + ". Returning value of 'shouldShowRequestPermissionRationale(NOTIFICATION_PERMISSION)'";
                }
            };
            BrazeLogger.brazelog$default(BrazeLogger.INSTANCE, TAG, BrazeLogger.Priority.I, null, (Function0)object, 4, null);
            return object2.shouldShowRequestPermissionRationale(NOTIFICATION_PERMISSION);
        }
        BrazeLogger.brazelog$default(BrazeLogger.INSTANCE, TAG, BrazeLogger.Priority.V, null, (Function0)l.b, 4, null);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static final int getPermissionRequestCount(Context context, String permission) {
        void var1_1;
        Context context2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"permission");
        return context.getSharedPreferences(PERMISSION_STORAGE_PREFS_FILE, 0).getInt((String)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static final void incrementPermissionRequestCount(Context context, String permission) {
        Function0<String> function0;
        void var1_2;
        Context context2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)var1_2, (String)"permission");
        SharedPreferences sharedPreferences = context.getSharedPreferences(PERMISSION_STORAGE_PREFS_FILE, 0);
        int n7 = sharedPreferences.getInt((String)var1_2, 0) + 1;
        Function0<String> function02 = function0;
        function0 = new Function0<String>(n7){
            final /* synthetic */ int b;
            {
                void var1_1;
                this.b = var1_1;
                super(0);
            }

            public final String a() {
                return "Incrementing permission request counter to " + this.b + '.';
            }
        };
        BrazeLogger.brazelog$default(BrazeLogger.INSTANCE, TAG, null, null, (Function0)function02, 6, null);
        sharedPreferences.edit().putInt((String)var1_2, n7).apply();
    }
}

