/*
 * Decompiled with CFR 0.152.
 */
package com.braze.events;

import com.braze.enums.CardCategory;
import com.braze.models.cards.Card;
import com.braze.support.BrazeLogger;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public final class FeedUpdatedEvent {
    private static final String TAG = BrazeLogger.getBrazeLogTag(FeedUpdatedEvent.class);
    private final List<Card> mFeedCards;
    private final String mUserId;
    private final boolean mFromOfflineStorage;
    private final long mTimestamp;

    /*
     * WARNING - void declaration
     */
    public FeedUpdatedEvent(List<Card> feedCards, String userId, boolean isFromOfflineStorage, long timestamp) {
        void var4_4;
        void var1_1;
        void var3_3;
        void var2_2;
        FeedUpdatedEvent feedUpdatedEvent = this;
        this.mUserId = var2_2;
        this.mFromOfflineStorage = var3_3;
        var1_1.getClass();
        feedUpdatedEvent.mFeedCards = var1_1;
        feedUpdatedEvent.mTimestamp = var4_4;
    }

    public boolean isFromOfflineStorage() {
        return this.mFromOfflineStorage;
    }

    public List<Card> getFeedCards() {
        return this.getFeedCards(CardCategory.getAllCategories());
    }

    /*
     * WARNING - void declaration
     */
    public List<Card> getFeedCards(CardCategory category) {
        void var1_1;
        return this.getFeedCards(EnumSet.of(var1_1));
    }

    /*
     * Unable to fully structure code
     */
    public List<Card> getFeedCards(EnumSet<CardCategory> categories) {
        if (categories == null) {
            BrazeLogger.i(FeedUpdatedEvent.TAG, "The categories passed to getFeedCards are null, FeedUpdatedEvent is going to return all the cards in cache.");
            var1_2 = CardCategory.getAllCategories();
        }
        if (!var1_2.isEmpty()) ** GOTO lbl10
        BrazeLogger.w(FeedUpdatedEvent.TAG, "The parameter passed into categories is not valid, Braze is returning an empty card list.Please pass in a non-empty EnumSet of CardCategory for getFeedCards().");
        return new ArrayList<Card>();
lbl10:
        // 1 sources

        v0 = this;
        this = v1;
        try {
            v1 = new ArrayList<E>();
            var2_3 = v0.mFeedCards.iterator();
        }
        catch (Exception var0_1) {
            BrazeLogger.w(FeedUpdatedEvent.TAG, "Unable to get cards with categories[" + var1_2 + "]. Ignoring.", var0_1);
            return null;
        }
        while (true) {
            if (!var2_3.hasNext()) break;
            var3_4 = var2_3.next();
            if (!var3_4.isInCategorySet(var1_2)) continue;
            if (var3_4.isExpired()) continue;
            this.add(var3_4);
        }
        return this;
    }

    public String getUserId() {
        return this.mUserId;
    }

    public int getCardCount() {
        return this.getCardCount(CardCategory.getAllCategories());
    }

    /*
     * WARNING - void declaration
     */
    public int getCardCount(CardCategory category) {
        void var1_1;
        return this.getCardCount(EnumSet.of(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public int getCardCount(EnumSet<CardCategory> categories) {
        void var1_1;
        if (categories == null) {
            BrazeLogger.i(TAG, "The categories passed into getCardCount are null, FeedUpdatedEvent is going to return the count of all the cards in cache.");
            return this.mFeedCards.size();
        }
        if (var1_1.isEmpty()) {
            BrazeLogger.w(TAG, "The parameters passed into categories are not valid, Braze is returning 0 in getCardCount().Please pass in a non-empty EnumSet of CardCategory.");
            return 0;
        }
        return this.getFeedCards((EnumSet<CardCategory>)var1_1).size();
    }

    public int getUnreadCardCount() {
        return this.getUnreadCardCount(CardCategory.getAllCategories());
    }

    /*
     * WARNING - void declaration
     */
    public int getUnreadCardCount(CardCategory category) {
        void var1_1;
        return this.getUnreadCardCount(EnumSet.of(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public int getUnreadCardCount(EnumSet<CardCategory> categories) {
        void var1_2;
        if (categories == null) {
            BrazeLogger.w(TAG, "The categories passed to getUnreadCardCount are null, FeedUpdatedEvent is going to return the count of all the unread cards in cache.");
            return this.getUnreadCardCount(CardCategory.getAllCategories());
        }
        if (var1_2.isEmpty()) {
            BrazeLogger.w(TAG, "The parameters passed into categories are Empty, Braze is returning 0 in getUnreadCardCount().Please pass in a non-empty EnumSet of CardCategory.");
            return 0;
        }
        int n7 = 0;
        for (Card card : this.mFeedCards) {
            if (!card.isInCategorySet((EnumSet<CardCategory>)var1_2) || card.getViewed() || card.isExpired()) continue;
            ++n7;
        }
        return n7;
    }

    public long lastUpdatedInSecondsFromEpoch() {
        return this.mTimestamp;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("FeedUpdatedEvent{");
        stringBuilder.append("mFeedCards=").append(this.mFeedCards);
        stringBuilder.append(", mUserId='").append(this.mUserId).append('\'');
        stringBuilder.append(", mFromOfflineStorage=").append(this.mFromOfflineStorage);
        stringBuilder.append(", mTimestamp=").append(this.mTimestamp);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

