/*
 * Decompiled with CFR 0.152.
 */
package com.braze.location;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import com.braze.location.BrazeActionReceiver;
import com.braze.location.GooglePlayLocationUtils;
import com.braze.location.IBrazeGeofenceApi;
import com.braze.models.BrazeGeofence;
import com.braze.support.IntentUtils;
import com.google.android.gms.location.LocationServices;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/braze/location/BrazeInternalGeofenceApi;", "Lcom/braze/location/IBrazeGeofenceApi;", "()V", "deleteRegisteredGeofenceCache", "", "context", "Landroid/content/Context;", "getGeofenceTransitionPendingIntent", "Landroid/app/PendingIntent;", "registerGeofences", "geofenceList", "", "Lcom/braze/models/BrazeGeofence;", "geofenceRequestIntent", "teardownGeofences", "applicationContext", "intent", "android-sdk-location_release"})
public final class BrazeInternalGeofenceApi
implements IBrazeGeofenceApi {
    @NotNull
    public PendingIntent getGeofenceTransitionPendingIntent(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent intent = new Intent("com.braze.action.receiver.BRAZE_GEOFENCE_UPDATE").setClass(context, BrazeActionReceiver.class);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(Constants.BRAZE_A\u2026tionReceiver::class.java)");
        Intent geofenceIntent = intent;
        int flags = 0x8000000 | IntentUtils.getMutablePendingIntentFlags();
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)geofenceIntent, (int)flags);
        Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"getBroadcast(context, 0, geofenceIntent, flags)");
        return pendingIntent;
    }

    public void teardownGeofences(@NotNull Context applicationContext, @NotNull PendingIntent intent) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        LocationServices.getGeofencingClient((Context)applicationContext).removeGeofences(intent);
    }

    public void registerGeofences(@NotNull Context context, @NotNull List<BrazeGeofence> geofenceList, @NotNull PendingIntent geofenceRequestIntent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(geofenceList, (String)"geofenceList");
        Intrinsics.checkNotNullParameter((Object)geofenceRequestIntent, (String)"geofenceRequestIntent");
        GooglePlayLocationUtils.registerGeofencesWithGooglePlayIfNecessary(context, geofenceList, geofenceRequestIntent);
    }

    public void deleteRegisteredGeofenceCache(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        GooglePlayLocationUtils.deleteRegisteredGeofenceCache(context);
    }
}

