/*
 * Decompiled with CFR 0.152.
 */
package com.braze.location;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.location.LocationManager;
import android.os.Build;
import androidx.annotation.VisibleForTesting;
import com.braze.configuration.BrazeConfigurationProvider;
import com.braze.enums.LocationProviderName;
import com.braze.location.BrazeActionReceiver;
import com.braze.location.BrazeInternalLocationApi;
import com.braze.location.IBrazeLocationApi;
import com.braze.models.IBrazeLocation;
import com.braze.models.outgoing.BrazeLocation;
import com.braze.support.BrazeLogger;
import com.braze.support.DateTimeUtils;
import com.braze.support.IntentUtils;
import com.braze.support.PermissionUtils;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0007J.\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bJ&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J+\u0010\u0018\u001a\u00020\u000b2!\u0010\u0019\u001a\u001d\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u00170\u001aH\u0016J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0012H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/braze/location/BrazeInternalLocationApi;", "Lcom/braze/location/IBrazeLocationApi;", "()V", "allowedLocationProviders", "Ljava/util/EnumSet;", "Lcom/braze/enums/LocationProviderName;", "appConfigurationProvider", "Lcom/braze/configuration/BrazeConfigurationProvider;", "context", "Landroid/content/Context;", "isLocationCollectionEnabled", "", "()Z", "locationManager", "Landroid/location/LocationManager;", "getLastKnownGpsLocationIfValid", "Landroid/location/Location;", "getSuitableLocationProvider", "", "allowedProviders", "hasFinePermission", "hasCoarsePermission", "initWithContext", "", "requestSingleLocationUpdate", "manualLocationUpdateCallback", "Lkotlin/Function1;", "Lcom/braze/models/IBrazeLocation;", "Lkotlin/ParameterName;", "name", "location", "requestSingleUpdateFromLocationManager", "provider", "Companion", "android-sdk-location_release"})
public final class BrazeInternalLocationApi
implements IBrazeLocationApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Context context;
    private LocationManager locationManager;
    private BrazeConfigurationProvider appConfigurationProvider;
    private EnumSet<LocationProviderName> allowedLocationProviders;
    public static final int LAST_KNOWN_GPS_LOCATION_MAX_AGE_MS = 600000;

    private final boolean isLocationCollectionEnabled() {
        boolean bl;
        BrazeConfigurationProvider brazeConfigurationProvider = this.appConfigurationProvider;
        if (brazeConfigurationProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appConfigurationProvider");
            brazeConfigurationProvider = null;
        }
        if (brazeConfigurationProvider.isLocationCollectionEnabled()) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)isLocationCollectionEnabled.1.INSTANCE, (int)2, null);
            bl = true;
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)isLocationCollectionEnabled.2.INSTANCE, (int)2, null);
            bl = false;
        }
        return bl;
    }

    public void initWithContext(@NotNull Context context, @NotNull EnumSet<LocationProviderName> allowedProviders, @NotNull BrazeConfigurationProvider appConfigurationProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(allowedProviders, (String)"allowedProviders");
        Intrinsics.checkNotNullParameter((Object)appConfigurationProvider, (String)"appConfigurationProvider");
        this.context = context;
        this.appConfigurationProvider = appConfigurationProvider;
        this.allowedLocationProviders = allowedProviders;
        Object object = context.getSystemService("location");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.location.LocationManager");
        this.locationManager = (LocationManager)object;
    }

    public boolean requestSingleLocationUpdate(@NotNull Function1<? super IBrazeLocation, Unit> manualLocationUpdateCallback) {
        boolean bl;
        String provider;
        EnumSet<LocationProviderName> enumSet;
        LocationManager locationManager;
        boolean hasCoarsePermission;
        Intrinsics.checkNotNullParameter(manualLocationUpdateCallback, (String)"manualLocationUpdateCallback");
        if (!this.isLocationCollectionEnabled()) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)requestSingleLocationUpdate.1.INSTANCE, (int)2, null);
            return false;
        }
        Context context = this.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            context = null;
        }
        boolean hasFinePermission = PermissionUtils.hasPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION");
        Context context2 = this.context;
        if (context2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            context2 = null;
        }
        if (!(hasCoarsePermission = PermissionUtils.hasPermission((Context)context2, (String)"android.permission.ACCESS_COARSE_LOCATION")) && !hasFinePermission) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)requestSingleLocationUpdate.2.INSTANCE, (int)2, null);
            return false;
        }
        if (hasFinePermission) {
            Location lastKnownGpsLocationIfValid;
            LocationManager locationManager2 = this.locationManager;
            if (locationManager2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"locationManager");
                locationManager2 = null;
            }
            if ((lastKnownGpsLocationIfValid = this.getLastKnownGpsLocationIfValid(locationManager2)) != null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)((Function0)new Function0<String>(lastKnownGpsLocationIfValid){
                    final /* synthetic */ Location $lastKnownGpsLocationIfValid;
                    {
                        this.$lastKnownGpsLocationIfValid = $lastKnownGpsLocationIfValid;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Setting user location to last known GPS location: " + this.$lastKnownGpsLocationIfValid;
                    }
                }), (int)3, null);
                manualLocationUpdateCallback.invoke((Object)new BrazeLocation(lastKnownGpsLocationIfValid));
                return true;
            }
        }
        if ((locationManager = this.locationManager) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"locationManager");
            locationManager = null;
        }
        if ((enumSet = this.allowedLocationProviders) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"allowedLocationProviders");
            enumSet = null;
        }
        if ((provider = this.getSuitableLocationProvider(locationManager, enumSet, hasFinePermission, hasCoarsePermission)) == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)requestSingleLocationUpdate.4.INSTANCE, (int)3, null);
            return false;
        }
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)((Function0)new Function0<String>(provider){
            final /* synthetic */ String $provider;
            {
                this.$provider = $provider;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Requesting single location update with provider: " + this.$provider;
            }
        }), (int)3, null);
        try {
            if (Build.VERSION.SDK_INT >= 30) {
                LocationManager locationManager3 = this.locationManager;
                if (locationManager3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"locationManager");
                    locationManager3 = null;
                }
                locationManager3.getCurrentLocation(provider, null, ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getIO()), arg_0 -> BrazeInternalLocationApi.requestSingleLocationUpdate$lambda$0(this, manualLocationUpdateCallback, arg_0));
            } else {
                this.requestSingleUpdateFromLocationManager(provider);
            }
            bl = true;
        }
        catch (SecurityException se) {
            BrazeLogger.INSTANCE.brazelog((Object)this, BrazeLogger.Priority.E, (Throwable)se, (Function0)requestSingleLocationUpdate.7.INSTANCE);
            bl = false;
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)this, BrazeLogger.Priority.E, (Throwable)e, (Function0)requestSingleLocationUpdate.8.INSTANCE);
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final String getSuitableLocationProvider(@NotNull LocationManager locationManager, @NotNull EnumSet<LocationProviderName> allowedProviders, boolean hasFinePermission, boolean hasCoarsePermission) {
        Intrinsics.checkNotNullParameter((Object)locationManager, (String)"locationManager");
        Intrinsics.checkNotNullParameter(allowedProviders, (String)"allowedProviders");
        String provider = null;
        if (hasFinePermission && allowedProviders.contains(LocationProviderName.GPS) && locationManager.isProviderEnabled("gps")) {
            provider = "gps";
        } else if ((hasCoarsePermission || hasFinePermission) && allowedProviders.contains(LocationProviderName.NETWORK) && locationManager.isProviderEnabled("network")) {
            provider = "network";
        } else if (hasFinePermission && allowedProviders.contains(LocationProviderName.PASSIVE) && locationManager.isProviderEnabled("passive")) {
            provider = "passive";
        }
        return provider;
    }

    @VisibleForTesting
    @Nullable
    public final Location getLastKnownGpsLocationIfValid(@NotNull LocationManager locationManager) {
        Intrinsics.checkNotNullParameter((Object)locationManager, (String)"locationManager");
        if (!locationManager.isProviderEnabled("gps")) {
            return null;
        }
        Location location = locationManager.getLastKnownLocation("gps");
        if (location == null) {
            return null;
        }
        Location lastKnownGpsLocation = location;
        long ageMs = DateTimeUtils.nowInMilliseconds() - lastKnownGpsLocation.getTime();
        if (ageMs > 600000L) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>(ageMs){
                final /* synthetic */ long $ageMs;
                {
                    this.$ageMs = $ageMs;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Last known GPS location is too old and will not be used. Age ms: " + this.$ageMs;
                }
            }), (int)2, null);
            return null;
        }
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)((Function0)new Function0<String>(lastKnownGpsLocation){
            final /* synthetic */ Location $lastKnownGpsLocation;
            {
                this.$lastKnownGpsLocation = $lastKnownGpsLocation;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Using last known GPS location: " + this.$lastKnownGpsLocation;
            }
        }), (int)3, null);
        return lastKnownGpsLocation;
    }

    private final void requestSingleUpdateFromLocationManager(String provider) {
        Intent intent = new Intent("com.braze.action.receiver.SINGLE_LOCATION_UPDATE");
        Context context = this.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            context = null;
        }
        Intent intent2 = intent.setClass(context, BrazeActionReceiver.class);
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"Intent(Constants.BRAZE_A\u2026tionReceiver::class.java)");
        Intent locationUpdateIntent = intent2;
        int flags = 0x8000000 | IntentUtils.getMutablePendingIntentFlags();
        Context context2 = this.context;
        if (context2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            context2 = null;
        }
        PendingIntent locationUpdatePendingIntent = PendingIntent.getBroadcast((Context)context2, (int)0, (Intent)locationUpdateIntent, (int)flags);
        LocationManager locationManager = this.locationManager;
        if (locationManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"locationManager");
            locationManager = null;
        }
        locationManager.requestSingleUpdate(provider, locationUpdatePendingIntent);
    }

    private static final void requestSingleLocationUpdate$lambda$0(BrazeInternalLocationApi this$0, Function1 $manualLocationUpdateCallback, Location location) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$manualLocationUpdateCallback, (String)"$manualLocationUpdateCallback");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this$0, null, null, (Function0)((Function0)new Function0<String>(location){
            final /* synthetic */ Location $location;
            {
                this.$location = $location;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Location manager getCurrentLocation got location: " + this.$location;
            }
        }), (int)3, null);
        if (location != null) {
            $manualLocationUpdateCallback.invoke((Object)new BrazeLocation(location));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/braze/location/BrazeInternalLocationApi$Companion;", "", "()V", "LAST_KNOWN_GPS_LOCATION_MAX_AGE_MS", "", "android-sdk-location_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

