/*
 * Decompiled with CFR 0.152.
 */
package com.braze.location;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.content.SharedPreferences;
import android.location.Location;
import com.braze.location.GooglePlayLocationUtils;
import com.braze.location.GooglePlayLocationUtilsKt;
import com.braze.managers.BrazeGeofenceManager;
import com.braze.managers.IBrazeGeofenceLocationUpdateListener;
import com.braze.models.BrazeGeofence;
import com.braze.models.IBrazeLocation;
import com.braze.models.outgoing.BrazeLocation;
import com.braze.support.BrazeLogger;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationServices;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J&\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J&\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0002J\u001e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0002J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u001e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/braze/location/GooglePlayLocationUtils;", "", "()V", "REGISTERED_GEOFENCE_SHARED_PREFS_LOCATION", "", "deleteRegisteredGeofenceCache", "", "context", "Landroid/content/Context;", "getRegisteredGeofenceSharedPrefs", "Landroid/content/SharedPreferences;", "registerGeofencesWithGeofencingClient", "newGeofencesToRegister", "", "Lcom/braze/models/BrazeGeofence;", "geofenceRequestIntent", "Landroid/app/PendingIntent;", "registerGeofencesWithGooglePlayIfNecessary", "geofenceList", "removeGeofencesFromSharedPrefs", "obsoleteGeofenceIds", "removeGeofencesRegisteredWithGeofencingClient", "requestSingleLocationUpdateFromGooglePlay", "resultListener", "Lcom/braze/managers/IBrazeGeofenceLocationUpdateListener;", "storeGeofencesToSharedPrefs", "android-sdk-location_release"})
@SuppressLint(value={"MissingPermission"})
@SourceDebugExtension(value={"SMAP\nGooglePlayLocationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GooglePlayLocationUtils.kt\ncom/braze/location/GooglePlayLocationUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n766#2:258\n857#2:259\n2624#2,3:260\n858#2:263\n766#2:264\n857#2:265\n2624#2,3:266\n858#2:269\n1549#2:270\n1620#2,3:271\n1549#2:274\n1620#2,3:275\n*S KotlinDebug\n*F\n+ 1 GooglePlayLocationUtils.kt\ncom/braze/location/GooglePlayLocationUtils\n*L\n49#1:258\n49#1:259\n50#1:260,3\n49#1:263\n54#1:264\n54#1:265\n55#1:266,3\n54#1:269\n58#1:270\n58#1:271,3\n128#1:274\n128#1:275,3\n*E\n"})
public final class GooglePlayLocationUtils {
    @NotNull
    public static final GooglePlayLocationUtils INSTANCE = new GooglePlayLocationUtils();
    @NotNull
    private static final String REGISTERED_GEOFENCE_SHARED_PREFS_LOCATION = "com.appboy.support.geofences";

    private GooglePlayLocationUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void registerGeofencesWithGooglePlayIfNecessary(@NotNull Context context, @NotNull List<BrazeGeofence> geofenceList, @NotNull PendingIntent geofenceRequestIntent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(geofenceList, (String)"geofenceList");
        Intrinsics.checkNotNullParameter((Object)geofenceRequestIntent, (String)"geofenceRequestIntent");
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            SharedPreferences prefs = INSTANCE.getRegisteredGeofenceSharedPrefs(context);
            List registeredGeofences = BrazeGeofenceManager.Companion.retrieveBrazeGeofencesFromLocalStorage(prefs);
            Iterable $this$filter$iv = geofenceList;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                boolean bl;
                block15: {
                    BrazeGeofence newGeofence = (BrazeGeofence)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$none$iv = registeredGeofences;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            BrazeGeofence registeredGeofence = (BrazeGeofence)element$iv;
                            boolean bl3 = false;
                            if (!(Intrinsics.areEqual((Object)registeredGeofence.getId(), (Object)newGeofence.getId()) && registeredGeofence.equivalentServerData(newGeofence))) continue;
                            bl = false;
                            break block15;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List newGeofencesToRegister = (List)destination$iv$iv;
            Iterable $this$filter$iv2 = registeredGeofences;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block16: {
                    BrazeGeofence registeredGeofence = (BrazeGeofence)element$iv$iv;
                    boolean bl4 = false;
                    Iterable $this$none$iv = newGeofencesToRegister;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            BrazeGeofence newGeofence = (BrazeGeofence)element$iv;
                            boolean bl5 = false;
                            if (!Intrinsics.areEqual((Object)newGeofence.getId(), (Object)registeredGeofence.getId())) continue;
                            bl = false;
                            break block16;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BrazeGeofence registeredGeofence = (BrazeGeofence)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getId());
            }
            List obsoleteGeofenceIds = (List)destination$iv$iv2;
            if (!((Collection)obsoleteGeofenceIds).isEmpty()) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)((Function0)new Function0<String>((List<String>)obsoleteGeofenceIds){
                    final /* synthetic */ List<String> $obsoleteGeofenceIds;
                    {
                        this.$obsoleteGeofenceIds = $obsoleteGeofenceIds;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Un-registering " + this.$obsoleteGeofenceIds.size() + " obsolete geofences from Google Play Services.";
                    }
                }), (int)3, null);
                INSTANCE.removeGeofencesRegisteredWithGeofencingClient(context, obsoleteGeofenceIds);
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)registerGeofencesWithGooglePlayIfNecessary.2.INSTANCE, (int)3, null);
            }
            if (!((Collection)newGeofencesToRegister).isEmpty()) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)((Function0)new Function0<String>((List<BrazeGeofence>)newGeofencesToRegister){
                    final /* synthetic */ List<BrazeGeofence> $newGeofencesToRegister;
                    {
                        this.$newGeofencesToRegister = $newGeofencesToRegister;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Registering " + this.$newGeofencesToRegister.size() + " new geofences with Google Play Services.";
                    }
                }), (int)3, null);
                INSTANCE.registerGeofencesWithGeofencingClient(context, newGeofencesToRegister, geofenceRequestIntent);
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)registerGeofencesWithGooglePlayIfNecessary.4.INSTANCE, (int)3, null);
            }
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)INSTANCE, BrazeLogger.Priority.E, (Throwable)e, (Function0)registerGeofencesWithGooglePlayIfNecessary.5.INSTANCE);
        }
    }

    @JvmStatic
    public static final void requestSingleLocationUpdateFromGooglePlay(@NotNull Context context, @NotNull IBrazeGeofenceLocationUpdateListener resultListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)resultListener, (String)"resultListener");
        try {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)requestSingleLocationUpdateFromGooglePlay.1.INSTANCE, (int)3, null);
            LocationServices.getFusedLocationProviderClient((Context)context).getCurrentLocation(100, null).addOnSuccessListener(arg_0 -> GooglePlayLocationUtils.requestSingleLocationUpdateFromGooglePlay$lambda$5((Function1)new Function1<Location, Unit>(resultListener){
                final /* synthetic */ IBrazeGeofenceLocationUpdateListener $resultListener;
                {
                    this.$resultListener = $resultListener;
                    super(1);
                }

                public final void invoke(Location it) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)GooglePlayLocationUtils.INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)requestSingleLocationUpdateFromGooglePlay.1.INSTANCE, (int)2, null);
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.$resultListener.onLocationRequestComplete((IBrazeLocation)new BrazeLocation(it));
                }
            }, arg_0)).addOnFailureListener(arg_0 -> GooglePlayLocationUtils.requestSingleLocationUpdateFromGooglePlay$lambda$6(resultListener, arg_0));
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)INSTANCE, BrazeLogger.Priority.W, (Throwable)e, (Function0)requestSingleLocationUpdateFromGooglePlay.4.INSTANCE);
        }
    }

    @JvmStatic
    public static final void deleteRegisteredGeofenceCache(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)deleteRegisteredGeofenceCache.1.INSTANCE, (int)3, null);
        INSTANCE.getRegisteredGeofenceSharedPrefs(context).edit().clear().apply();
    }

    /*
     * WARNING - void declaration
     */
    private final void registerGeofencesWithGeofencingClient(Context context, List<BrazeGeofence> newGeofencesToRegister, PendingIntent geofenceRequestIntent) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = newGeofencesToRegister;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BrazeGeofence brazeGeofence = (BrazeGeofence)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GooglePlayLocationUtilsKt.toGeofence((BrazeGeofence)it));
        }
        List newGooglePlayGeofencesToRegister = (List)destination$iv$iv;
        GeofencingRequest geofencingRequest = new GeofencingRequest.Builder().addGeofences(newGooglePlayGeofencesToRegister).setInitialTrigger(0).build();
        Intrinsics.checkNotNullExpressionValue((Object)geofencingRequest, (String)"Builder()\n            .a\u2026r(0)\n            .build()");
        GeofencingRequest geofencingRequest2 = geofencingRequest;
        LocationServices.getGeofencingClient((Context)context).addGeofences(geofencingRequest2, geofenceRequestIntent).addOnSuccessListener(arg_0 -> GooglePlayLocationUtils.registerGeofencesWithGeofencingClient$lambda$8((Function1)new Function1<Void, Unit>(context, newGeofencesToRegister){
            final /* synthetic */ Context $context;
            final /* synthetic */ List<BrazeGeofence> $newGeofencesToRegister;
            {
                this.$context = $context;
                this.$newGeofencesToRegister = $newGeofencesToRegister;
                super(1);
            }

            public final void invoke(Void it) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)GooglePlayLocationUtils.INSTANCE, null, null, (Function0)registerGeofencesWithGeofencingClient.1.INSTANCE, (int)3, null);
                GooglePlayLocationUtils.access$storeGeofencesToSharedPrefs(GooglePlayLocationUtils.INSTANCE, this.$context, this.$newGeofencesToRegister);
            }
        }, arg_0)).addOnFailureListener(GooglePlayLocationUtils::registerGeofencesWithGeofencingClient$lambda$9);
    }

    private final void removeGeofencesRegisteredWithGeofencingClient(Context context, List<String> obsoleteGeofenceIds) {
        LocationServices.getGeofencingClient((Context)context).removeGeofences(obsoleteGeofenceIds).addOnSuccessListener(arg_0 -> GooglePlayLocationUtils.removeGeofencesRegisteredWithGeofencingClient$lambda$10((Function1)new Function1<Void, Unit>(context, obsoleteGeofenceIds){
            final /* synthetic */ Context $context;
            final /* synthetic */ List<String> $obsoleteGeofenceIds;
            {
                this.$context = $context;
                this.$obsoleteGeofenceIds = $obsoleteGeofenceIds;
                super(1);
            }

            public final void invoke(Void it) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)GooglePlayLocationUtils.INSTANCE, null, null, (Function0)removeGeofencesRegisteredWithGeofencingClient.1.INSTANCE, (int)3, null);
                GooglePlayLocationUtils.access$removeGeofencesFromSharedPrefs(GooglePlayLocationUtils.INSTANCE, this.$context, this.$obsoleteGeofenceIds);
            }
        }, arg_0)).addOnFailureListener(GooglePlayLocationUtils::removeGeofencesRegisteredWithGeofencingClient$lambda$11);
    }

    private final SharedPreferences getRegisteredGeofenceSharedPrefs(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(REGISTERED_GEOFENCE_SHARED_PREFS_LOCATION, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026ON, Context.MODE_PRIVATE)");
        return sharedPreferences;
    }

    private final void storeGeofencesToSharedPrefs(Context context, List<BrazeGeofence> newGeofencesToRegister) {
        SharedPreferences.Editor editor = this.getRegisteredGeofenceSharedPrefs(context).edit();
        for (BrazeGeofence brazeGeofence : newGeofencesToRegister) {
            editor.putString(brazeGeofence.getId(), brazeGeofence.forJsonPut().toString());
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>(brazeGeofence){
                final /* synthetic */ BrazeGeofence $brazeGeofence;
                {
                    this.$brazeGeofence = $brazeGeofence;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Geofence with id: " + this.$brazeGeofence.getId() + " added to shared preferences.";
                }
            }), (int)2, null);
        }
        editor.apply();
    }

    private final void removeGeofencesFromSharedPrefs(Context context, List<String> obsoleteGeofenceIds) {
        SharedPreferences.Editor editor = this.getRegisteredGeofenceSharedPrefs(context).edit();
        for (String id : obsoleteGeofenceIds) {
            editor.remove(id);
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>(id){
                final /* synthetic */ String $id;
                {
                    this.$id = $id;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Geofence with id: " + this.$id + " removed from shared preferences.";
                }
            }), (int)2, null);
        }
        editor.apply();
    }

    private static final void requestSingleLocationUpdateFromGooglePlay$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void requestSingleLocationUpdateFromGooglePlay$lambda$6(IBrazeGeofenceLocationUpdateListener $resultListener, Exception error) {
        Intrinsics.checkNotNullParameter((Object)$resultListener, (String)"$resultListener");
        BrazeLogger.INSTANCE.brazelog((Object)INSTANCE, BrazeLogger.Priority.E, (Throwable)error, (Function0)requestSingleLocationUpdateFromGooglePlay.3.1.INSTANCE);
        $resultListener.onLocationRequestComplete(null);
    }

    private static final void registerGeofencesWithGeofencingClient$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void registerGeofencesWithGeofencingClient$lambda$9(Exception geofenceError) {
        if (geofenceError instanceof ApiException) {
            int statusCode = ((ApiException)geofenceError).getStatusCode();
            switch (statusCode) {
                case 1001: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)((Function0)new Function0<String>(statusCode){
                        final /* synthetic */ int $statusCode;
                        {
                            this.$statusCode = $statusCode;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Geofences not registered with Google Play Services due to GEOFENCE_TOO_MANY_GEOFENCES: " + this.$statusCode;
                        }
                    }), (int)2, null);
                    break;
                }
                case 1002: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)((Function0)new Function0<String>(statusCode){
                        final /* synthetic */ int $statusCode;
                        {
                            this.$statusCode = $statusCode;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Geofences not registered with Google Play Services due to GEOFENCE_TOO_MANY_PENDING_INTENTS: " + this.$statusCode;
                        }
                    }), (int)2, null);
                    break;
                }
                case 1000: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)((Function0)new Function0<String>(statusCode){
                        final /* synthetic */ int $statusCode;
                        {
                            this.$statusCode = $statusCode;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Geofences not registered with Google Play Services due to GEOFENCE_NOT_AVAILABLE: " + this.$statusCode;
                        }
                    }), (int)2, null);
                    break;
                }
                case 0: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)registerGeofencesWithGeofencingClient.2.4.INSTANCE, (int)3, null);
                    break;
                }
                default: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)((Function0)new Function0<String>(statusCode){
                        final /* synthetic */ int $statusCode;
                        {
                            this.$statusCode = $statusCode;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Geofence pending result returned unknown status code: " + this.$statusCode;
                        }
                    }), (int)2, null);
                    break;
                }
            }
        } else {
            BrazeLogger.INSTANCE.brazelog((Object)INSTANCE, BrazeLogger.Priority.E, (Throwable)geofenceError, (Function0)registerGeofencesWithGeofencingClient.2.6.INSTANCE);
        }
    }

    private static final void removeGeofencesRegisteredWithGeofencingClient$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void removeGeofencesRegisteredWithGeofencingClient$lambda$11(Exception geofenceError) {
        if (geofenceError instanceof ApiException) {
            int statusCode = ((ApiException)geofenceError).getStatusCode();
            switch (statusCode) {
                case 1001: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)((Function0)new Function0<String>(statusCode){
                        final /* synthetic */ int $statusCode;
                        {
                            this.$statusCode = $statusCode;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Geofences cannot be un-registered with Google Play Services due to GEOFENCE_TOO_MANY_GEOFENCES: " + this.$statusCode;
                        }
                    }), (int)2, null);
                    break;
                }
                case 1002: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)((Function0)new Function0<String>(statusCode){
                        final /* synthetic */ int $statusCode;
                        {
                            this.$statusCode = $statusCode;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Geofences cannot be un-registered with Google Play Services due to GEOFENCE_TOO_MANY_PENDING_INTENTS: " + this.$statusCode;
                        }
                    }), (int)2, null);
                    break;
                }
                case 1000: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)((Function0)new Function0<String>(statusCode){
                        final /* synthetic */ int $statusCode;
                        {
                            this.$statusCode = $statusCode;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Geofences cannot be un-registered with Google Play Services due to GEOFENCE_NOT_AVAILABLE: " + this.$statusCode;
                        }
                    }), (int)2, null);
                    break;
                }
                case 0: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)removeGeofencesRegisteredWithGeofencingClient.2.4.INSTANCE, (int)3, null);
                    break;
                }
                default: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)((Function0)new Function0<String>(statusCode){
                        final /* synthetic */ int $statusCode;
                        {
                            this.$statusCode = $statusCode;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Geofence pending result returned unknown status code: " + this.$statusCode;
                        }
                    }), (int)2, null);
                    break;
                }
            }
        } else {
            BrazeLogger.INSTANCE.brazelog((Object)INSTANCE, BrazeLogger.Priority.E, (Throwable)geofenceError, (Function0)removeGeofencesRegisteredWithGeofencingClient.2.6.INSTANCE);
        }
    }

    public static final /* synthetic */ void access$storeGeofencesToSharedPrefs(GooglePlayLocationUtils $this, Context context, List newGeofencesToRegister) {
        $this.storeGeofencesToSharedPrefs(context, newGeofencesToRegister);
    }

    public static final /* synthetic */ void access$removeGeofencesFromSharedPrefs(GooglePlayLocationUtils $this, Context context, List obsoleteGeofenceIds) {
        $this.removeGeofencesFromSharedPrefs(context, obsoleteGeofenceIds);
    }
}

