/*
 * Decompiled with CFR 0.152.
 */
package com.braze.location;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.Keep;
import androidx.annotation.VisibleForTesting;
import com.braze.BrazeInternal;
import com.braze.enums.GeofenceTransitionType;
import com.braze.location.BrazeActionReceiver;
import com.braze.models.IBrazeLocation;
import com.braze.models.outgoing.BrazeLocation;
import com.braze.support.BrazeLogger;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/braze/location/BrazeActionReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "ActionReceiver", "android-sdk-location_release"})
@Keep
public final class BrazeActionReceiver
extends BroadcastReceiver {
    public void onReceive(@Nullable Context context, @Nullable Intent intent) {
        if (intent == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, (Function0)onReceive.1.INSTANCE, (int)6, null);
            return;
        }
        if (context == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, (Function0)onReceive.2.INSTANCE, (int)6, null);
            return;
        }
        Context applicationContext = context.getApplicationContext();
        BroadcastReceiver.PendingResult pendingResult = this.goAsync();
        Intrinsics.checkNotNullExpressionValue((Object)applicationContext, (String)"applicationContext");
        ActionReceiver actionReceiver = new ActionReceiver(applicationContext, intent);
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(actionReceiver, pendingResult, null){
            int label;
            final /* synthetic */ ActionReceiver $actionReceiver;
            final /* synthetic */ BroadcastReceiver.PendingResult $pendingResult;
            {
                this.$actionReceiver = $actionReceiver;
                this.$pendingResult = $pendingResult;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$actionReceiver.run();
                        this.$pendingResult.finish();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0007J\u0006\u0010\u000b\u001a\u00020\nR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/braze/location/BrazeActionReceiver$ActionReceiver;", "", "applicationContext", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "(Landroid/content/Context;Landroid/content/Intent;)V", "action", "", "performWork", "", "run", "Companion", "android-sdk-location_release"})
    @VisibleForTesting
    @SourceDebugExtension(value={"SMAP\nBrazeActionReceiver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrazeActionReceiver.kt\ncom/braze/location/BrazeActionReceiver$ActionReceiver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1#2:157\n*E\n"})
    public static final class ActionReceiver {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Context applicationContext;
        @NotNull
        private final Intent intent;
        @Nullable
        private final String action;

        public ActionReceiver(@NotNull Context applicationContext, @NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            this.applicationContext = applicationContext;
            this.intent = intent;
            this.action = this.intent.getAction();
        }

        public final void run() {
            try {
                this.performWork();
            }
            catch (Exception e) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, (Function0)((Function0)new Function0<String>(this){
                    final /* synthetic */ ActionReceiver this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Caught exception while performing the BrazeActionReceiver work. Action: " + ActionReceiver.access$getAction$p(this.this$0) + " Intent: " + ActionReceiver.access$getIntent$p(this.this$0);
                    }
                }), (int)4, null);
            }
        }

        @VisibleForTesting
        public final void performWork() {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ ActionReceiver this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Received intent with action " + ActionReceiver.access$getAction$p(this.this$0);
                }
            }), (int)7, null);
            String string = this.action;
            if (string == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)performWork.2.INSTANCE, (int)7, null);
            } else if (Intrinsics.areEqual((Object)string, (Object)"com.braze.action.receiver.BRAZE_GEOFENCE_UPDATE")) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)((Function0)new Function0<String>(this){
                    final /* synthetic */ ActionReceiver this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "BrazeActionReceiver received intent with geofence transition: " + ActionReceiver.access$getAction$p(this.this$0);
                    }
                }), (int)7, null);
                GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent((Intent)this.intent);
                if (geofencingEvent != null) {
                    GeofencingEvent it = geofencingEvent;
                    boolean bl = false;
                    Companion.handleGeofenceEvent(this.applicationContext, it);
                }
            } else if (Intrinsics.areEqual((Object)string, (Object)"com.braze.action.receiver.SINGLE_LOCATION_UPDATE")) {
                Location location;
                Location location2;
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)((Function0)new Function0<String>(this){
                    final /* synthetic */ ActionReceiver this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "BrazeActionReceiver received intent with single location update: " + ActionReceiver.access$getAction$p(this.this$0);
                    }
                }), (int)7, null);
                if (Build.VERSION.SDK_INT >= 33) {
                    Bundle bundle = this.intent.getExtras();
                    location2 = bundle != null ? (Location)bundle.getParcelable("location", Location.class) : null;
                } else {
                    Bundle bundle = this.intent.getExtras();
                    location2 = (Location)(bundle != null ? bundle.get("location") : null);
                }
                Location location3 = location = location2;
                if (location3 != null) {
                    Location it = location3;
                    boolean bl = false;
                    ActionReceiver.Companion.handleSingleLocationUpdate(this.applicationContext, it);
                }
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, (Function0)((Function0)new Function0<String>(this){
                    final /* synthetic */ ActionReceiver this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Unknown intent received in BrazeActionReceiver with action: " + ActionReceiver.access$getAction$p(this.this$0);
                    }
                }), (int)6, null);
            }
        }

        public static final /* synthetic */ String access$getAction$p(ActionReceiver $this) {
            return $this.action;
        }

        public static final /* synthetic */ Intent access$getIntent$p(ActionReceiver $this) {
            return $this.intent;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/braze/location/BrazeActionReceiver$ActionReceiver$Companion;", "", "()V", "handleGeofenceEvent", "", "applicationContext", "Landroid/content/Context;", "geofenceEvent", "Lcom/google/android/gms/location/GeofencingEvent;", "handleSingleLocationUpdate", "location", "Landroid/location/Location;", "android-sdk-location_release"})
        @SourceDebugExtension(value={"SMAP\nBrazeActionReceiver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrazeActionReceiver.kt\ncom/braze/location/BrazeActionReceiver$ActionReceiver$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1855#2,2:157\n1855#2,2:159\n*S KotlinDebug\n*F\n+ 1 BrazeActionReceiver.kt\ncom/braze/location/BrazeActionReceiver$ActionReceiver$Companion\n*L\n128#1:157,2\n138#1:159,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            private final boolean handleSingleLocationUpdate(Context applicationContext, Location location) {
                try {
                    BrazeInternal.logLocationRecordedEvent((Context)applicationContext, (IBrazeLocation)((IBrazeLocation)new BrazeLocation(location)));
                }
                catch (Exception e) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, (Function0)handleSingleLocationUpdate.1.INSTANCE, (int)4, null);
                    return false;
                }
                return true;
            }

            @VisibleForTesting
            public final boolean handleGeofenceEvent(@NotNull Context applicationContext, @NotNull GeofencingEvent geofenceEvent) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
                Intrinsics.checkNotNullParameter((Object)geofenceEvent, (String)"geofenceEvent");
                if (geofenceEvent.hasError()) {
                    int errorCode = geofenceEvent.getErrorCode();
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, (Function0)((Function0)new Function0<String>(errorCode){
                        final /* synthetic */ int $errorCode;
                        {
                            this.$errorCode = $errorCode;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Location Services error: " + this.$errorCode;
                        }
                    }), (int)6, null);
                    return false;
                }
                int transitionType = geofenceEvent.getGeofenceTransition();
                List triggeringGeofences = geofenceEvent.getTriggeringGeofences();
                if (1 == transitionType) {
                    List list = triggeringGeofences;
                    if (list != null) {
                        Iterable $this$forEach$iv = list;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Geofence geofence = (Geofence)element$iv;
                            boolean bl2 = false;
                            String string = geofence.getRequestId();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"geofence.requestId");
                            BrazeInternal.recordGeofenceTransition((Context)applicationContext, (String)string, (GeofenceTransitionType)GeofenceTransitionType.ENTER);
                        }
                    }
                    bl = true;
                } else if (2 == transitionType) {
                    List list = triggeringGeofences;
                    if (list != null) {
                        Iterable $this$forEach$iv = list;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Geofence geofence = (Geofence)element$iv;
                            boolean bl3 = false;
                            String string = geofence.getRequestId();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"geofence.requestId");
                            BrazeInternal.recordGeofenceTransition((Context)applicationContext, (String)string, (GeofenceTransitionType)GeofenceTransitionType.EXIT);
                        }
                    }
                    bl = true;
                } else {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, (Function0)((Function0)new Function0<String>(transitionType){
                        final /* synthetic */ int $transitionType;
                        {
                            this.$transitionType = $transitionType;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Unsupported transition type received: " + this.$transitionType;
                        }
                    }), (int)6, null);
                    bl = false;
                }
                return bl;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

