/*
 * Decompiled with CFR 0.152.
 */
package com.braze.location;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.content.SharedPreferences;
import android.location.Location;
import androidx.annotation.VisibleForTesting;
import com.braze.location.GooglePlayLocationUtils;
import com.braze.location.GooglePlayLocationUtilsKt;
import com.braze.managers.BrazeGeofenceManager;
import com.braze.managers.IBrazeGeofenceLocationUpdateListener;
import com.braze.models.BrazeGeofence;
import com.braze.models.IBrazeLocation;
import com.braze.models.outgoing.BrazeLocation;
import com.braze.support.BrazeLogger;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationServices;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\u000bJ&\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J^\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u001a\b\u0002\u0010\u0014\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000e\u0012\u0004\u0012\u00020\u00060\u00152\u001a\b\u0002\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\u00060\u0015H\u0007J\u001e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0002J#\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0001\u00a2\u0006\u0002\b\u001aJ\u0018\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J#\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0001\u00a2\u0006\u0002\b\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/braze/location/GooglePlayLocationUtils;", "", "()V", "REGISTERED_GEOFENCE_SHARED_PREFS_LOCATION", "", "deleteRegisteredGeofenceCache", "", "context", "Landroid/content/Context;", "getRegisteredGeofenceSharedPrefs", "Landroid/content/SharedPreferences;", "getRegisteredGeofenceSharedPrefs$android_sdk_location_release", "registerGeofencesWithGeofencingClient", "newGeofencesToRegister", "", "Lcom/braze/models/BrazeGeofence;", "geofenceRequestIntent", "Landroid/app/PendingIntent;", "registerGeofencesWithGooglePlayIfNecessary", "desiredGeofencesToRegister", "removalFunction", "Lkotlin/Function1;", "registerFunction", "removeGeofencesFromSharedPrefs", "obsoleteGeofenceIds", "removeGeofencesRegisteredWithGeofencingClient", "removeGeofencesRegisteredWithGeofencingClient$android_sdk_location_release", "requestSingleLocationUpdateFromGooglePlay", "resultListener", "Lcom/braze/managers/IBrazeGeofenceLocationUpdateListener;", "storeGeofencesToSharedPrefs", "storeGeofencesToSharedPrefs$android_sdk_location_release", "android-sdk-location_release"})
@SuppressLint(value={"MissingPermission"})
@SourceDebugExtension(value={"SMAP\nGooglePlayLocationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GooglePlayLocationUtils.kt\ncom/braze/location/GooglePlayLocationUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,280:1\n1194#2,2:281\n1222#2,4:283\n766#2:287\n857#2:288\n2624#2,3:289\n858#2:292\n1549#2:293\n1620#2,3:294\n1549#2:297\n1620#2,3:298\n*S KotlinDebug\n*F\n+ 1 GooglePlayLocationUtils.kt\ncom/braze/location/GooglePlayLocationUtils\n*L\n54#1:281,2\n54#1:283,4\n63#1:287\n63#1:288\n64#1:289,3\n63#1:292\n67#1:293\n67#1:294,3\n148#1:297\n148#1:298,3\n*E\n"})
public final class GooglePlayLocationUtils {
    @NotNull
    public static final GooglePlayLocationUtils INSTANCE = new GooglePlayLocationUtils();
    @NotNull
    private static final String REGISTERED_GEOFENCE_SHARED_PREFS_LOCATION = "com.appboy.support.geofences";

    private GooglePlayLocationUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void registerGeofencesWithGooglePlayIfNecessary(@NotNull Context context, @NotNull List<BrazeGeofence> desiredGeofencesToRegister, @NotNull PendingIntent geofenceRequestIntent, @NotNull Function1<? super List<String>, Unit> removalFunction, @NotNull Function1<? super List<BrazeGeofence>, Unit> registerFunction) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(desiredGeofencesToRegister, (String)"desiredGeofencesToRegister");
        Intrinsics.checkNotNullParameter((Object)geofenceRequestIntent, (String)"geofenceRequestIntent");
        Intrinsics.checkNotNullParameter(removalFunction, (String)"removalFunction");
        Intrinsics.checkNotNullParameter(registerFunction, (String)"registerFunction");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, (Function0)((Function0)new Function0<String>(desiredGeofencesToRegister){
            final /* synthetic */ List<BrazeGeofence> $desiredGeofencesToRegister;
            {
                this.$desiredGeofencesToRegister = $desiredGeofencesToRegister;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "registerGeofencesWithGooglePlayIfNecessary called with " + this.$desiredGeofencesToRegister;
            }
        }), (int)6, null);
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            BrazeGeofence registeredGeofence;
            void $this$filterTo$iv$iv;
            void it;
            Object object;
            Iterable $this$associateByTo$iv$iv;
            SharedPreferences prefs = INSTANCE.getRegisteredGeofenceSharedPrefs$android_sdk_location_release(context);
            List registeredGeofences = BrazeGeofenceManager.Companion.retrieveBrazeGeofencesFromLocalStorage(prefs);
            Iterable $this$associateBy$iv = registeredGeofences;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Object destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                BrazeGeofence brazeGeofence = (BrazeGeofence)element$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.put(it.getId(), element$iv$iv);
            }
            Map registeredGeofencesById = destination$iv$iv;
            Iterable $this$filter$iv = registeredGeofences;
            boolean $i$f$filter = false;
            $this$associateByTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block13: {
                    registeredGeofence = (BrazeGeofence)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$none$iv = desiredGeofencesToRegister;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            BrazeGeofence desiredGeofence = (BrazeGeofence)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)desiredGeofence.getId(), (Object)registeredGeofence.getId())) continue;
                            bl = false;
                            break block13;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                registeredGeofence = (BrazeGeofence)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(it.getId());
            }
            List obsoleteGeofenceIds = (List)destination$iv$iv;
            List newGeofencesToRegister = new ArrayList();
            for (BrazeGeofence desiredGeofence : desiredGeofencesToRegister) {
                BrazeGeofence registeredGeofenceWithSameId = (BrazeGeofence)registeredGeofencesById.get(desiredGeofence.getId());
                if (registeredGeofenceWithSameId != null && desiredGeofence.equivalentServerData(registeredGeofenceWithSameId)) continue;
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, (Function0)((Function0)new Function0<String>(desiredGeofence){
                    final /* synthetic */ BrazeGeofence $desiredGeofence;
                    {
                        this.$desiredGeofence = $desiredGeofence;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Geofence with id: " + this.$desiredGeofence.getId() + " is new or has been updated.";
                    }
                }), (int)7, null);
                newGeofencesToRegister.add(desiredGeofence);
            }
            if (!((Collection)obsoleteGeofenceIds).isEmpty()) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, (Function0)((Function0)new Function0<String>((List<String>)obsoleteGeofenceIds){
                    final /* synthetic */ List<String> $obsoleteGeofenceIds;
                    {
                        this.$obsoleteGeofenceIds = $obsoleteGeofenceIds;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Un-registering " + this.$obsoleteGeofenceIds + " obsolete geofences from Google Play Services.";
                    }
                }), (int)7, null);
                removalFunction.invoke((Object)obsoleteGeofenceIds);
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, (Function0)registerGeofencesWithGooglePlayIfNecessary.6.INSTANCE, (int)7, null);
            }
            if (!((Collection)newGeofencesToRegister).isEmpty()) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, (Function0)((Function0)new Function0<String>((List<BrazeGeofence>)newGeofencesToRegister){
                    final /* synthetic */ List<BrazeGeofence> $newGeofencesToRegister;
                    {
                        this.$newGeofencesToRegister = $newGeofencesToRegister;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Registering " + this.$newGeofencesToRegister + " new geofences with Google Play Services.";
                    }
                }), (int)7, null);
                registerFunction.invoke((Object)newGeofencesToRegister);
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, (Function0)registerGeofencesWithGooglePlayIfNecessary.8.INSTANCE, (int)7, null);
            }
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, (Function0)registerGeofencesWithGooglePlayIfNecessary.9.INSTANCE, (int)4, null);
        }
    }

    public static /* synthetic */ void registerGeofencesWithGooglePlayIfNecessary$default(Context context, List list, PendingIntent pendingIntent, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = (Function1)new Function1<List<? extends String>, Unit>(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(1);
                }

                public final void invoke(@NotNull List<String> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    GooglePlayLocationUtils.INSTANCE.removeGeofencesRegisteredWithGeofencingClient$android_sdk_location_release(this.$context, it);
                }
            };
        }
        if ((n & 0x10) != 0) {
            function12 = (Function1)new Function1<List<? extends BrazeGeofence>, Unit>(context, pendingIntent){
                final /* synthetic */ Context $context;
                final /* synthetic */ PendingIntent $geofenceRequestIntent;
                {
                    this.$context = $context;
                    this.$geofenceRequestIntent = $geofenceRequestIntent;
                    super(1);
                }

                public final void invoke(@NotNull List<BrazeGeofence> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    GooglePlayLocationUtils.access$registerGeofencesWithGeofencingClient(GooglePlayLocationUtils.INSTANCE, this.$context, it, this.$geofenceRequestIntent);
                }
            };
        }
        GooglePlayLocationUtils.registerGeofencesWithGooglePlayIfNecessary(context, list, pendingIntent, (Function1<? super List<String>, Unit>)function1, (Function1<? super List<BrazeGeofence>, Unit>)function12);
    }

    @JvmStatic
    public static final void requestSingleLocationUpdateFromGooglePlay(@NotNull Context context, @NotNull IBrazeGeofenceLocationUpdateListener resultListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)resultListener, (String)"resultListener");
        try {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, (Function0)requestSingleLocationUpdateFromGooglePlay.1.INSTANCE, (int)7, null);
            LocationServices.getFusedLocationProviderClient((Context)context).getCurrentLocation(100, null).addOnSuccessListener(arg_0 -> GooglePlayLocationUtils.requestSingleLocationUpdateFromGooglePlay$lambda$4((Function1)new Function1<Location, Unit>(resultListener){
                final /* synthetic */ IBrazeGeofenceLocationUpdateListener $resultListener;
                {
                    this.$resultListener = $resultListener;
                    super(1);
                }

                public final void invoke(Location it) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)GooglePlayLocationUtils.INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, (Function0)requestSingleLocationUpdateFromGooglePlay.1.INSTANCE, (int)6, null);
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.$resultListener.onLocationRequestComplete((IBrazeLocation)new BrazeLocation(it));
                }
            }, arg_0)).addOnFailureListener(arg_0 -> GooglePlayLocationUtils.requestSingleLocationUpdateFromGooglePlay$lambda$5(resultListener, arg_0));
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, (Throwable)e, (boolean)false, (Function0)requestSingleLocationUpdateFromGooglePlay.4.INSTANCE, (int)4, null);
        }
    }

    @JvmStatic
    public static final void deleteRegisteredGeofenceCache(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, (Function0)deleteRegisteredGeofenceCache.1.INSTANCE, (int)7, null);
        INSTANCE.getRegisteredGeofenceSharedPrefs$android_sdk_location_release(context).edit().clear().apply();
    }

    /*
     * WARNING - void declaration
     */
    private final void registerGeofencesWithGeofencingClient(Context context, List<BrazeGeofence> newGeofencesToRegister, PendingIntent geofenceRequestIntent) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = newGeofencesToRegister;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BrazeGeofence brazeGeofence = (BrazeGeofence)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GooglePlayLocationUtilsKt.toGeofence((BrazeGeofence)it));
        }
        List newGooglePlayGeofencesToRegister = (List)destination$iv$iv;
        GeofencingRequest geofencingRequest = new GeofencingRequest.Builder().addGeofences(newGooglePlayGeofencesToRegister).setInitialTrigger(0).build();
        Intrinsics.checkNotNullExpressionValue((Object)geofencingRequest, (String)"Builder()\n            .a\u2026r(0)\n            .build()");
        GeofencingRequest geofencingRequest2 = geofencingRequest;
        LocationServices.getGeofencingClient((Context)context).addGeofences(geofencingRequest2, geofenceRequestIntent).addOnSuccessListener(arg_0 -> GooglePlayLocationUtils.registerGeofencesWithGeofencingClient$lambda$7((Function1)new Function1<Void, Unit>(context, newGeofencesToRegister){
            final /* synthetic */ Context $context;
            final /* synthetic */ List<BrazeGeofence> $newGeofencesToRegister;
            {
                this.$context = $context;
                this.$newGeofencesToRegister = $newGeofencesToRegister;
                super(1);
            }

            public final void invoke(Void it) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)GooglePlayLocationUtils.INSTANCE, null, null, (boolean)false, (Function0)registerGeofencesWithGeofencingClient.1.INSTANCE, (int)7, null);
                GooglePlayLocationUtils.INSTANCE.storeGeofencesToSharedPrefs$android_sdk_location_release(this.$context, this.$newGeofencesToRegister);
            }
        }, arg_0)).addOnFailureListener(GooglePlayLocationUtils::registerGeofencesWithGeofencingClient$lambda$8);
    }

    @VisibleForTesting
    public final void removeGeofencesRegisteredWithGeofencingClient$android_sdk_location_release(@NotNull Context context, @NotNull List<String> obsoleteGeofenceIds) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(obsoleteGeofenceIds, (String)"obsoleteGeofenceIds");
        LocationServices.getGeofencingClient((Context)context).removeGeofences(obsoleteGeofenceIds).addOnSuccessListener(arg_0 -> GooglePlayLocationUtils.removeGeofencesRegisteredWithGeofencingClient$lambda$9((Function1)new Function1<Void, Unit>(context, obsoleteGeofenceIds){
            final /* synthetic */ Context $context;
            final /* synthetic */ List<String> $obsoleteGeofenceIds;
            {
                this.$context = $context;
                this.$obsoleteGeofenceIds = $obsoleteGeofenceIds;
                super(1);
            }

            public final void invoke(Void it) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)GooglePlayLocationUtils.INSTANCE, null, null, (boolean)false, (Function0)removeGeofencesRegisteredWithGeofencingClient.1.INSTANCE, (int)7, null);
                GooglePlayLocationUtils.access$removeGeofencesFromSharedPrefs(GooglePlayLocationUtils.INSTANCE, this.$context, this.$obsoleteGeofenceIds);
            }
        }, arg_0)).addOnFailureListener(GooglePlayLocationUtils::removeGeofencesRegisteredWithGeofencingClient$lambda$10);
    }

    @VisibleForTesting
    @NotNull
    public final SharedPreferences getRegisteredGeofenceSharedPrefs$android_sdk_location_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences sharedPreferences = context.getSharedPreferences(REGISTERED_GEOFENCE_SHARED_PREFS_LOCATION, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026ON, Context.MODE_PRIVATE)");
        return sharedPreferences;
    }

    @VisibleForTesting
    public final void storeGeofencesToSharedPrefs$android_sdk_location_release(@NotNull Context context, @NotNull List<BrazeGeofence> newGeofencesToRegister) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(newGeofencesToRegister, (String)"newGeofencesToRegister");
        SharedPreferences.Editor editor = this.getRegisteredGeofenceSharedPrefs$android_sdk_location_release(context).edit();
        for (BrazeGeofence brazeGeofence : newGeofencesToRegister) {
            editor.putString(brazeGeofence.getId(), brazeGeofence.forJsonPut().toString());
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, (Function0)((Function0)new Function0<String>(brazeGeofence){
                final /* synthetic */ BrazeGeofence $brazeGeofence;
                {
                    this.$brazeGeofence = $brazeGeofence;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Geofence with id: " + this.$brazeGeofence.getId() + " added to shared preferences.";
                }
            }), (int)6, null);
        }
        editor.apply();
    }

    private final void removeGeofencesFromSharedPrefs(Context context, List<String> obsoleteGeofenceIds) {
        SharedPreferences.Editor editor = this.getRegisteredGeofenceSharedPrefs$android_sdk_location_release(context).edit();
        for (String id : obsoleteGeofenceIds) {
            editor.remove(id);
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, (Function0)((Function0)new Function0<String>(id){
                final /* synthetic */ String $id;
                {
                    this.$id = $id;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Geofence with id: " + this.$id + " removed from shared preferences.";
                }
            }), (int)6, null);
        }
        editor.apply();
    }

    private static final void requestSingleLocationUpdateFromGooglePlay$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void requestSingleLocationUpdateFromGooglePlay$lambda$5(IBrazeGeofenceLocationUpdateListener $resultListener, Exception error) {
        Intrinsics.checkNotNullParameter((Object)$resultListener, (String)"$resultListener");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)error, (boolean)false, (Function0)requestSingleLocationUpdateFromGooglePlay.3.1.INSTANCE, (int)4, null);
        $resultListener.onLocationRequestComplete(null);
    }

    private static final void registerGeofencesWithGeofencingClient$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void registerGeofencesWithGeofencingClient$lambda$8(Exception geofenceError) {
        if (geofenceError instanceof ApiException) {
            int statusCode = ((ApiException)geofenceError).getStatusCode();
            switch (statusCode) {
                case 1001: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, (Function0)((Function0)new Function0<String>(statusCode){
                        final /* synthetic */ int $statusCode;
                        {
                            this.$statusCode = $statusCode;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Geofences not registered with Google Play Services due to GEOFENCE_TOO_MANY_GEOFENCES: " + this.$statusCode;
                        }
                    }), (int)6, null);
                    break;
                }
                case 1002: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, (Function0)((Function0)new Function0<String>(statusCode){
                        final /* synthetic */ int $statusCode;
                        {
                            this.$statusCode = $statusCode;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Geofences not registered with Google Play Services due to GEOFENCE_TOO_MANY_PENDING_INTENTS: " + this.$statusCode;
                        }
                    }), (int)6, null);
                    break;
                }
                case 1000: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, (Function0)((Function0)new Function0<String>(statusCode){
                        final /* synthetic */ int $statusCode;
                        {
                            this.$statusCode = $statusCode;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Geofences not registered with Google Play Services due to GEOFENCE_NOT_AVAILABLE: " + this.$statusCode;
                        }
                    }), (int)6, null);
                    break;
                }
                case 0: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, (Function0)registerGeofencesWithGeofencingClient.2.4.INSTANCE, (int)7, null);
                    break;
                }
                default: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, (Function0)((Function0)new Function0<String>(statusCode){
                        final /* synthetic */ int $statusCode;
                        {
                            this.$statusCode = $statusCode;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Geofence pending result returned unknown status code: " + this.$statusCode;
                        }
                    }), (int)6, null);
                    break;
                }
            }
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)geofenceError, (boolean)false, (Function0)registerGeofencesWithGeofencingClient.2.6.INSTANCE, (int)4, null);
        }
    }

    private static final void removeGeofencesRegisteredWithGeofencingClient$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void removeGeofencesRegisteredWithGeofencingClient$lambda$10(Exception geofenceError) {
        if (geofenceError instanceof ApiException) {
            int statusCode = ((ApiException)geofenceError).getStatusCode();
            switch (statusCode) {
                case 1001: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, (Function0)((Function0)new Function0<String>(statusCode){
                        final /* synthetic */ int $statusCode;
                        {
                            this.$statusCode = $statusCode;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Geofences cannot be un-registered with Google Play Services due to GEOFENCE_TOO_MANY_GEOFENCES: " + this.$statusCode;
                        }
                    }), (int)6, null);
                    break;
                }
                case 1002: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, (Function0)((Function0)new Function0<String>(statusCode){
                        final /* synthetic */ int $statusCode;
                        {
                            this.$statusCode = $statusCode;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Geofences cannot be un-registered with Google Play Services due to GEOFENCE_TOO_MANY_PENDING_INTENTS: " + this.$statusCode;
                        }
                    }), (int)6, null);
                    break;
                }
                case 1000: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, (Function0)((Function0)new Function0<String>(statusCode){
                        final /* synthetic */ int $statusCode;
                        {
                            this.$statusCode = $statusCode;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Geofences cannot be un-registered with Google Play Services due to GEOFENCE_NOT_AVAILABLE: " + this.$statusCode;
                        }
                    }), (int)6, null);
                    break;
                }
                case 0: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, (Function0)removeGeofencesRegisteredWithGeofencingClient.2.4.INSTANCE, (int)7, null);
                    break;
                }
                default: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, (Function0)((Function0)new Function0<String>(statusCode){
                        final /* synthetic */ int $statusCode;
                        {
                            this.$statusCode = $statusCode;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Geofence pending result returned unknown status code: " + this.$statusCode;
                        }
                    }), (int)6, null);
                    break;
                }
            }
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)geofenceError, (boolean)false, (Function0)removeGeofencesRegisteredWithGeofencingClient.2.6.INSTANCE, (int)4, null);
        }
    }

    public static final /* synthetic */ void access$registerGeofencesWithGeofencingClient(GooglePlayLocationUtils $this, Context context, List newGeofencesToRegister, PendingIntent geofenceRequestIntent) {
        $this.registerGeofencesWithGeofencingClient(context, newGeofencesToRegister, geofenceRequestIntent);
    }

    public static final /* synthetic */ void access$removeGeofencesFromSharedPrefs(GooglePlayLocationUtils $this, Context context, List obsoleteGeofenceIds) {
        $this.removeGeofencesFromSharedPrefs(context, obsoleteGeofenceIds);
    }
}

