/*
 * Decompiled with CFR 0.152.
 */
package com.braze.push;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.braze.Braze;
import com.braze.BrazeInternal;
import com.braze.configuration.BrazeConfigurationProvider;
import com.braze.push.BrazePushReceiver;
import com.braze.support.BrazeLogger;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/braze/push/BrazeFirebaseMessagingService;", "Lcom/google/firebase/messaging/FirebaseMessagingService;", "()V", "onMessageReceived", "", "remoteMessage", "Lcom/google/firebase/messaging/RemoteMessage;", "onNewToken", "newToken", "", "Companion", "android-sdk-ui_release"})
public class BrazeFirebaseMessagingService
extends FirebaseMessagingService {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void onNewToken(@NotNull String newToken) {
        Intrinsics.checkNotNullParameter((Object)newToken, (String)"newToken");
        super.onNewToken(newToken);
        BrazeInternal.applyPendingRuntimeConfiguration((Context)((Context)this));
        BrazeConfigurationProvider configurationProvider = new BrazeConfigurationProvider((Context)this);
        CharSequence charSequence = Braze.Companion.getConfiguredApiKey(configurationProvider);
        if (charSequence == null || charSequence.length() == 0) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>(newToken){
                final /* synthetic */ String $newToken;
                {
                    this.$newToken = $newToken;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "No configured API key, not registering token in onNewToken. Token: " + this.$newToken;
                }
            }), (int)2, null);
            return;
        }
        if (!configurationProvider.isFirebaseMessagingServiceOnNewTokenRegistrationEnabled()) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>(newToken){
                final /* synthetic */ String $newToken;
                {
                    this.$newToken = $newToken;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Automatic FirebaseMessagingService.OnNewToken() registration disabled, not registering token: " + this.$newToken;
                }
            }), (int)2, null);
            return;
        }
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>(newToken){
            final /* synthetic */ String $newToken;
            {
                this.$newToken = $newToken;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Registering Firebase push token in onNewToken. Token: " + this.$newToken;
            }
        }), (int)2, null);
        Braze.Companion.getInstance((Context)this).setRegisteredPushToken(newToken);
    }

    public void onMessageReceived(@NotNull RemoteMessage remoteMessage) {
        Intrinsics.checkNotNullParameter((Object)remoteMessage, (String)"remoteMessage");
        super.onMessageReceived(remoteMessage);
        Companion.handleBrazeRemoteMessage((Context)this, remoteMessage);
    }

    @JvmStatic
    public static final boolean handleBrazeRemoteMessage(@NotNull Context context, @NotNull RemoteMessage remoteMessage) {
        return Companion.handleBrazeRemoteMessage(context, remoteMessage);
    }

    @JvmStatic
    public static final boolean isBrazePushNotification(@NotNull RemoteMessage remoteMessage) {
        return Companion.isBrazePushNotification(remoteMessage);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\n"}, d2={"Lcom/braze/push/BrazeFirebaseMessagingService$Companion;", "", "()V", "handleBrazeRemoteMessage", "", "context", "Landroid/content/Context;", "remoteMessage", "Lcom/google/firebase/messaging/RemoteMessage;", "isBrazePushNotification", "android-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean handleBrazeRemoteMessage(@NotNull Context context, @NotNull RemoteMessage remoteMessage) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)remoteMessage, (String)"remoteMessage");
            if (!this.isBrazePushNotification(remoteMessage)) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)((Function0)new Function0<String>(remoteMessage){
                    final /* synthetic */ RemoteMessage $remoteMessage;
                    {
                        this.$remoteMessage = $remoteMessage;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Remote message did not originate from Braze. Not consuming remote message: " + this.$remoteMessage;
                    }
                }), (int)2, null);
                return false;
            }
            Map map = remoteMessage.getData();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"remoteMessage.data");
            Map remoteMessageData = map;
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)((Function0)new Function0<String>((Map<String, String>)remoteMessageData){
                final /* synthetic */ Map<String, String> $remoteMessageData;
                {
                    this.$remoteMessageData = $remoteMessageData;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Got remote message from FCM: " + this.$remoteMessageData;
                }
            }), (int)2, null);
            Intent pushIntent = new Intent("firebase_messaging_service_routing_action");
            Bundle bundle = new Bundle();
            for (Map.Entry entry : remoteMessageData.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>(key, value){
                    final /* synthetic */ String $key;
                    final /* synthetic */ String $value;
                    {
                        this.$key = $key;
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Adding bundle item from FCM remote data with key: " + this.$key + " and value: " + this.$value;
                    }
                }), (int)2, null);
                bundle.putString(key, value);
            }
            pushIntent.putExtras(bundle);
            BrazePushReceiver.Companion.handleReceivedIntent$default(BrazePushReceiver.Companion, context, pushIntent, false, 4, null);
            return true;
        }

        @JvmStatic
        public final boolean isBrazePushNotification(@NotNull RemoteMessage remoteMessage) {
            Intrinsics.checkNotNullParameter((Object)remoteMessage, (String)"remoteMessage");
            Map map = remoteMessage.getData();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"remoteMessage.data");
            Map remoteMessageData = map;
            return Intrinsics.areEqual((Object)"true", remoteMessageData.get("_ab"));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

