/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.webkit.ConsoleMessage;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.RequiresApi;
import androidx.fragment.app.FragmentActivity;
import com.braze.enums.Channel;
import com.braze.support.BrazeFileUtils;
import com.braze.support.BrazeLogger;
import com.braze.ui.BrazeDeeplinkHandler;
import com.braze.ui.BrazeWebViewActivity;
import com.braze.ui.R;
import com.braze.ui.actions.IAction;
import com.braze.ui.support.ViewUtils;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/braze/ui/BrazeWebViewActivity;", "Landroidx/fragment/app/FragmentActivity;", "()V", "createWebChromeClient", "Landroid/webkit/WebChromeClient;", "createWebViewClient", "Landroid/webkit/WebViewClient;", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "android-sdk-ui_release"})
@SuppressLint(value={"SetJavaScriptEnabled"})
public class BrazeWebViewActivity
extends FragmentActivity {
    public void onCreate(@Nullable Bundle savedInstanceState) {
        block4: {
            super.onCreate(savedInstanceState);
            this.getWindow().setFlags(0x1000000, 0x1000000);
            this.setContentView(R.layout.com_braze_webview_activity);
            WebView webView = (WebView)this.findViewById(R.id.com_braze_webview_activity_webview);
            webView.setLayerType(2, null);
            WebSettings webSettings = webView.getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)webSettings, (String)"webView.settings");
            WebSettings webSettings2 = webSettings;
            webSettings2.setAllowFileAccess(false);
            webSettings2.setBuiltInZoomControls(true);
            webSettings2.setJavaScriptEnabled(true);
            webSettings2.setUseWideViewPort(true);
            webSettings2.setLoadWithOverviewMode(true);
            webSettings2.setDisplayZoomControls(false);
            webSettings2.setDomStorageEnabled(true);
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"this.applicationContext");
            if (ViewUtils.isDeviceInNightMode(context)) {
                if (Build.VERSION.SDK_INT >= 33) {
                    webSettings2.setAlgorithmicDarkeningAllowed(true);
                } else if (Build.VERSION.SDK_INT >= 29) {
                    webSettings2.setForceDark(2);
                }
            }
            webView.setWebChromeClient(this.createWebChromeClient());
            webView.setWebViewClient(this.createWebViewClient());
            Object object = this.getIntent().getExtras();
            if (object == null || (object = object.getString("url")) == null) break block4;
            Object url = object;
            boolean bl = false;
            webView.loadUrl((String)url);
        }
    }

    @NotNull
    public WebChromeClient createWebChromeClient() {
        return new WebChromeClient(){

            public boolean onConsoleMessage(@NotNull ConsoleMessage cm) {
                Intrinsics.checkNotNullParameter((Object)cm, (String)"cm");
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), null, null, (Function0)((Function0)new Function0<String>(cm){
                    final /* synthetic */ ConsoleMessage $cm;
                    {
                        this.$cm = $cm;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Braze WebView Activity log. Line: " + this.$cm.lineNumber() + ". SourceId: " + this.$cm.sourceId() + ". Log Level: " + this.$cm.messageLevel() + ". Message: " + this.$cm.message();
                    }
                }), (int)3, null);
                return true;
            }

            @Nullable
            public Bitmap getDefaultVideoPoster() {
                return Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
        };
    }

    @NotNull
    public WebViewClient createWebViewClient() {
        return new WebViewClient(this){
            final /* synthetic */ BrazeWebViewActivity this$0;
            {
                this.this$0 = $receiver;
            }

            @RequiresApi(api=21)
            public boolean shouldOverrideUrlLoading(@NotNull WebView view, @NotNull WebResourceRequest request) {
                Boolean didHandleUrl;
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Context context = view.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
                String string = request.getUrl().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.url.toString()");
                Boolean bl = didHandleUrl = this.handleUrlOverride(context, string);
                return bl != null ? bl.booleanValue() : super.shouldOverrideUrlLoading(view, request);
            }

            @Deprecated(message="Deprecated in Java")
            public boolean shouldOverrideUrlLoading(@NotNull WebView view, @NotNull String url) {
                Boolean didHandleUrl;
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Context context = view.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
                Boolean bl = didHandleUrl = this.handleUrlOverride(context, url);
                return bl != null ? bl.booleanValue() : super.shouldOverrideUrlLoading(view, url);
            }

            private final Boolean handleUrlOverride(Context context, String url) {
                try {
                    Boolean bl;
                    if (CollectionsKt.contains((Iterable)BrazeFileUtils.REMOTE_SCHEMES, (Object)Uri.parse((String)url).getScheme())) {
                        return null;
                    }
                    IAction action = BrazeDeeplinkHandler.Companion.getInstance().createUriActionFromUrlString(url, this.this$0.getIntent().getExtras(), false, Channel.UNKNOWN);
                    if (action != null) {
                        action.execute(context);
                        this.this$0.finish();
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }
                catch (Exception e) {
                    BrazeLogger.INSTANCE.brazelog((Object)((Object)this), BrazeLogger.Priority.E, (Throwable)e, (Function0)new Function0<String>(url){
                        final /* synthetic */ String $url;
                        {
                            this.$url = $url;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Unexpected exception while processing url " + this.$url + ". Passing url back to WebView.";
                        }
                    });
                    return null;
                }
            }

            public boolean onRenderProcessGone(@NotNull WebView view, @NotNull RenderProcessGoneDetail detail) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)detail, (String)"detail");
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)createWebViewClient.onRenderProcessGone.1.INSTANCE, (int)2, null);
                return true;
            }
        };
    }
}

