/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.adapters;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import androidx.annotation.NonNull;
import com.braze.models.cards.BannerImageCard;
import com.braze.models.cards.CaptionedImageCard;
import com.braze.models.cards.Card;
import com.braze.models.cards.ShortNewsCard;
import com.braze.models.cards.TextAnnouncementCard;
import com.braze.support.BrazeLogger;
import com.braze.ui.feed.view.BaseFeedCardView;
import com.braze.ui.widget.BannerImageCardView;
import com.braze.ui.widget.CaptionedImageCardView;
import com.braze.ui.widget.DefaultCardView;
import com.braze.ui.widget.ShortNewsCardView;
import com.braze.ui.widget.TextAnnouncementCardView;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BrazeListAdapter
extends ArrayAdapter<Card> {
    private static final String TAG = BrazeLogger.getBrazeLogTag(BrazeListAdapter.class);
    private final Context mContext;
    private final Set<String> mCardIdImpressions;

    public BrazeListAdapter(Context context, int layoutResourceId, List<Card> cards) {
        super(context, layoutResourceId, cards);
        this.mContext = context;
        this.mCardIdImpressions = new HashSet<String>();
    }

    public int getViewTypeCount() {
        return 5;
    }

    public int getItemViewType(int position) {
        Card card = (Card)this.getItem(position);
        if (card instanceof BannerImageCard) {
            return 1;
        }
        if (card instanceof CaptionedImageCard) {
            return 2;
        }
        if (card instanceof ShortNewsCard) {
            return 3;
        }
        if (card instanceof TextAnnouncementCard) {
            return 4;
        }
        return 0;
    }

    @NonNull
    public View getView(int position, View convertView, @NonNull ViewGroup parent) {
        BaseFeedCardView view;
        Card card = (Card)this.getItem(position);
        if (convertView == null) {
            view = card instanceof BannerImageCard ? new BannerImageCardView(this.mContext) : (card instanceof CaptionedImageCard ? new CaptionedImageCardView(this.mContext) : (card instanceof ShortNewsCard ? new ShortNewsCardView(this.mContext) : (card instanceof TextAnnouncementCard ? new TextAnnouncementCardView(this.mContext) : new DefaultCardView(this.mContext))));
        } else {
            BrazeLogger.v((String)TAG, (String)("Reusing convertView for rendering of item " + position));
            view = (BaseFeedCardView)convertView;
        }
        BrazeLogger.v((String)TAG, (String)("Using view of type: " + ((Object)((Object)view)).getClass().getName() + " for card at position " + position + ": " + card.toString()));
        view.setCard(card);
        this.logCardImpression(card);
        return view;
    }

    public synchronized void replaceFeed(List<Card> cards) {
        this.setNotifyOnChange(false);
        if (cards == null) {
            this.clear();
            this.notifyDataSetChanged();
            return;
        }
        BrazeLogger.d((String)TAG, (String)("Replacing existing feed of " + this.getCount() + " cards with new feed containing " + cards.size() + " cards."));
        int i = 0;
        int j = 0;
        int newFeedSize = cards.size();
        while (i < this.getCount()) {
            Card existingCard = (Card)this.getItem(i);
            Card newCard = null;
            if (j < newFeedSize) {
                newCard = cards.get(j);
            }
            if (newCard != null && newCard.equals((Object)existingCard)) {
                ++i;
                ++j;
                continue;
            }
            this.remove(existingCard);
        }
        super.addAll(cards.subList(j, newFeedSize));
        this.notifyDataSetChanged();
    }

    public synchronized void add(Card card) {
        super.add((Object)card);
    }

    public void resetCardImpressionTracker() {
        this.mCardIdImpressions.clear();
    }

    private void logCardImpression(Card card) {
        String cardId = card.getId();
        if (!this.mCardIdImpressions.contains(cardId)) {
            this.mCardIdImpressions.add(cardId);
            card.logImpression();
            BrazeLogger.v((String)TAG, (String)("Logged impression for card " + cardId));
        } else {
            BrazeLogger.v((String)TAG, (String)("Already counted impression for card " + cardId));
        }
        if (!card.getViewed()) {
            card.setViewed(true);
        }
    }

    public void batchSetCardsToRead(int startIndex, int endIndex) {
        if (this.getCount() == 0) {
            BrazeLogger.d((String)TAG, (String)"mAdapter is empty in setting some cards to viewed.");
            return;
        }
        startIndex = Math.max(0, startIndex);
        endIndex = Math.min(this.getCount(), endIndex);
        for (int traversalIndex = startIndex; traversalIndex < endIndex; ++traversalIndex) {
            Card card = (Card)this.getItem(traversalIndex);
            if (card == null) {
                BrazeLogger.d((String)TAG, (String)"Card was null in setting some cards to viewed.");
                break;
            }
            if (card.isIndicatorHighlighted()) continue;
            card.setIndicatorHighlighted(true);
        }
    }
}

