/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.contentcards.view;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.braze.ui.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0005R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/braze/ui/contentcards/view/ContentCardViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "view", "Landroid/view/View;", "showUnreadIndicator", "", "(Landroid/view/View;Z)V", "actionHint", "Landroid/widget/TextView;", "pinnedIcon", "Landroid/widget/ImageView;", "unreadBar", "setActionHintText", "", "text", "", "setActionHintVisible", "isVisible", "setPinnedIconVisible", "setUnreadBarVisible", "android-sdk-ui_release"})
public class ContentCardViewHolder
extends RecyclerView.ViewHolder {
    @Nullable
    private final View unreadBar;
    @Nullable
    private final ImageView pinnedIcon;
    @Nullable
    private final TextView actionHint;

    public ContentCardViewHolder(@NotNull View view, boolean showUnreadIndicator) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super(view);
        this.unreadBar = view.findViewById(R.id.com_braze_content_cards_unread_bar);
        this.pinnedIcon = (ImageView)view.findViewById(R.id.com_braze_content_cards_pinned_icon);
        this.actionHint = (TextView)view.findViewById(R.id.com_braze_content_cards_action_hint);
        if (showUnreadIndicator) {
            View view2 = this.unreadBar;
            if (view2 != null) {
                view2.setVisibility(0);
            }
            View view3 = this.unreadBar;
            if (view3 != null) {
                view3.setBackground(view.getContext().getResources().getDrawable(R.drawable.com_braze_content_cards_unread_bar_background));
            }
        } else {
            View view4 = this.unreadBar;
            if (view4 != null) {
                view4.setVisibility(8);
            }
        }
    }

    public final void setPinnedIconVisible(boolean isVisible) {
        ImageView imageView = this.pinnedIcon;
        if (imageView != null) {
            imageView.setVisibility(isVisible ? 0 : 8);
        }
    }

    public final void setUnreadBarVisible(boolean isVisible) {
        View view = this.unreadBar;
        if (view != null) {
            view.setVisibility(isVisible ? 0 : 8);
        }
    }

    public final void setActionHintVisible(boolean isVisible) {
        TextView textView = this.actionHint;
        if (textView != null) {
            textView.setVisibility(isVisible ? 0 : 8);
        }
    }

    public final void setActionHintText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TextView textView = this.actionHint;
        if (textView != null) {
            textView.setText((CharSequence)text);
        }
    }
}

