/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.inappmessage.utils;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.braze.Braze;
import com.braze.coroutine.BrazeCoroutineScope;
import com.braze.enums.BrazeViewBounds;
import com.braze.enums.inappmessage.InAppMessageFailureType;
import com.braze.enums.inappmessage.MessageType;
import com.braze.images.IBrazeImageLoader;
import com.braze.models.inappmessage.IInAppMessage;
import com.braze.models.inappmessage.IInAppMessageWithImage;
import com.braze.models.inappmessage.IInAppMessageZippedAssetHtml;
import com.braze.models.inappmessage.InAppMessageFull;
import com.braze.models.inappmessage.InAppMessageHtml;
import com.braze.support.BrazeLogger;
import com.braze.support.WebContentUtils;
import com.braze.ui.inappmessage.BrazeInAppMessageManager;
import com.braze.ui.inappmessage.utils.BackgroundInAppMessagePreparer;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J8\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0006H\u0007J\u0012\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lcom/braze/ui/inappmessage/utils/BackgroundInAppMessagePreparer;", "", "()V", "displayPreparedInAppMessage", "", "inAppMessage", "Lcom/braze/models/inappmessage/IInAppMessage;", "(Lcom/braze/models/inappmessage/IInAppMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getViewBoundsByType", "Lcom/braze/enums/BrazeViewBounds;", "handleLocalImage", "", "localImageUrl", "", "inAppMessageWithImage", "Lcom/braze/models/inappmessage/IInAppMessageWithImage;", "imageLoader", "Lcom/braze/images/IBrazeImageLoader;", "applicationContext", "Landroid/content/Context;", "viewBounds", "prepareInAppMessage", "inAppMessageToPrepare", "prepareInAppMessageForDisplay", "prepareInAppMessageWithBitmapDownload", "prepareInAppMessageWithHtml", "Lcom/braze/models/inappmessage/InAppMessageHtml;", "prepareInAppMessageWithZippedAssetHtml", "inAppMessageHtml", "Lcom/braze/models/inappmessage/IInAppMessageZippedAssetHtml;", "android-sdk-ui_release"})
public final class BackgroundInAppMessagePreparer {
    @NotNull
    public static final BackgroundInAppMessagePreparer INSTANCE = new BackgroundInAppMessagePreparer();

    private BackgroundInAppMessagePreparer() {
    }

    @JvmStatic
    public static final void prepareInAppMessageForDisplay(@NotNull IInAppMessage inAppMessageToPrepare) {
        Intrinsics.checkNotNullParameter((Object)inAppMessageToPrepare, (String)"inAppMessageToPrepare");
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)BrazeCoroutineScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(inAppMessageToPrepare, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ IInAppMessage $inAppMessageToPrepare;
            {
                this.$inAppMessageToPrepare = $inAppMessageToPrepare;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        IInAppMessage preparedInAppMessage = BackgroundInAppMessagePreparer.access$prepareInAppMessage(BackgroundInAppMessagePreparer.INSTANCE, this.$inAppMessageToPrepare);
                        if (preparedInAppMessage == null) {
                            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)$this$launch, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)prepareInAppMessageForDisplay.1.INSTANCE, (int)2, null);
                            return Unit.INSTANCE;
                        }
                        this.L$0 = $this$launch;
                        this.label = 1;
                        Object object3 = BackgroundInAppMessagePreparer.access$displayPreparedInAppMessage(BackgroundInAppMessagePreparer.INSTANCE, preparedInAppMessage, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Exception e) {
                            BrazeLogger.INSTANCE.brazelog((Object)$this$launch, BrazeLogger.Priority.E, (Throwable)e, (Function0)prepareInAppMessageForDisplay.2.INSTANCE);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final IInAppMessage prepareInAppMessage(IInAppMessage inAppMessageToPrepare) {
        if (inAppMessageToPrepare.isControl()) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)prepareInAppMessage.1.INSTANCE, (int)3, null);
            return inAppMessageToPrepare;
        }
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)prepareInAppMessage.2.INSTANCE, (int)3, null);
        switch (WhenMappings.$EnumSwitchMapping$0[inAppMessageToPrepare.getMessageType().ordinal()]) {
            case 1: {
                if (BackgroundInAppMessagePreparer.prepareInAppMessageWithZippedAssetHtml((IInAppMessageZippedAssetHtml)inAppMessageToPrepare)) break;
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)prepareInAppMessage.3.INSTANCE, (int)2, null);
                inAppMessageToPrepare.logDisplayFailure(InAppMessageFailureType.ZIP_ASSET_DOWNLOAD);
                return null;
            }
            case 2: {
                this.prepareInAppMessageWithHtml((InAppMessageHtml)inAppMessageToPrepare);
                break;
            }
            default: {
                boolean didImageDownloadSucceed = BackgroundInAppMessagePreparer.prepareInAppMessageWithBitmapDownload(inAppMessageToPrepare);
                if (didImageDownloadSucceed) break;
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)prepareInAppMessage.4.INSTANCE, (int)2, null);
                inAppMessageToPrepare.logDisplayFailure(InAppMessageFailureType.IMAGE_DOWNLOAD);
                return null;
            }
        }
        return inAppMessageToPrepare;
    }

    @JvmStatic
    @VisibleForTesting
    public static final boolean prepareInAppMessageWithZippedAssetHtml(@NotNull IInAppMessageZippedAssetHtml inAppMessageHtml) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)inAppMessageHtml, (String)"inAppMessageHtml");
        String localAssets = inAppMessageHtml.getLocalAssetsDirectoryUrl();
        CharSequence charSequence = localAssets;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && new File(localAssets).exists()) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)((Function0)new Function0<String>(localAssets){
                final /* synthetic */ String $localAssets;
                {
                    this.$localAssets = $localAssets;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Local assets for html in-app message are already populated. Not downloading assets. Location = " + this.$localAssets;
                }
            }), (int)2, null);
            return true;
        }
        String assetsZipRemoteUrl = inAppMessageHtml.getAssetsZipRemoteUrl();
        CharSequence charSequence2 = assetsZipRemoteUrl;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)prepareInAppMessageWithZippedAssetHtml.2.INSTANCE, (int)2, null);
            return true;
        }
        Context applicationContext = BrazeInAppMessageManager.Companion.getInstance().getApplicationContext();
        if (applicationContext == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)prepareInAppMessageWithZippedAssetHtml.3.INSTANCE, (int)2, null);
            return false;
        }
        File internalStorageCacheDirectory = WebContentUtils.getHtmlInAppMessageAssetCacheDirectory((Context)applicationContext);
        String localWebContentUrl = WebContentUtils.getLocalHtmlUrlFromRemoteUrl((File)internalStorageCacheDirectory, (String)assetsZipRemoteUrl);
        CharSequence charSequence3 = localWebContentUrl;
        if (!(charSequence3 == null || StringsKt.isBlank((CharSequence)charSequence3))) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)((Function0)new Function0<String>(localWebContentUrl){
                final /* synthetic */ String $localWebContentUrl;
                {
                    this.$localWebContentUrl = $localWebContentUrl;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Local url for html in-app message assets is " + this.$localWebContentUrl;
                }
            }), (int)3, null);
            inAppMessageHtml.setLocalAssetsDirectoryUrl(localWebContentUrl);
            bl = true;
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)((Function0)new Function0<String>(inAppMessageHtml, localWebContentUrl){
                final /* synthetic */ IInAppMessageZippedAssetHtml $inAppMessageHtml;
                final /* synthetic */ String $localWebContentUrl;
                {
                    this.$inAppMessageHtml = $inAppMessageHtml;
                    this.$localWebContentUrl = $localWebContentUrl;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Download of html content to local directory failed for remote url: " + this.$inAppMessageHtml.getAssetsZipRemoteUrl() + " . Returned local url is: " + this.$localWebContentUrl;
                }
            }), (int)2, null);
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    @VisibleForTesting
    public static final boolean prepareInAppMessageWithBitmapDownload(@Nullable IInAppMessage inAppMessage) {
        if (!(inAppMessage instanceof IInAppMessageWithImage)) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)prepareInAppMessageWithBitmapDownload.1.INSTANCE, (int)3, null);
            return false;
        }
        IInAppMessageWithImage inAppMessageWithImage = (IInAppMessageWithImage)inAppMessage;
        if (inAppMessageWithImage.getBitmap() != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)prepareInAppMessageWithBitmapDownload.2.INSTANCE, (int)2, null);
            inAppMessageWithImage.setImageDownloadSuccessful(true);
            return true;
        }
        BrazeViewBounds viewBounds = INSTANCE.getViewBoundsByType(inAppMessage);
        Context applicationContext = BrazeInAppMessageManager.Companion.getInstance().getApplicationContext();
        if (applicationContext == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)prepareInAppMessageWithBitmapDownload.3.INSTANCE, (int)2, null);
            return false;
        }
        IBrazeImageLoader imageLoader = Braze.Companion.getInstance(applicationContext).getImageLoader();
        String localImageUrl = inAppMessageWithImage.getLocalImageUrl();
        CharSequence charSequence = localImageUrl;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && INSTANCE.handleLocalImage(localImageUrl, inAppMessageWithImage, imageLoader, applicationContext, inAppMessage, viewBounds)) {
            return true;
        }
        String remoteImageUrl = inAppMessageWithImage.getRemoteImageUrl();
        CharSequence charSequence2 = remoteImageUrl;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)prepareInAppMessageWithBitmapDownload.5.INSTANCE, (int)2, null);
            if (inAppMessageWithImage instanceof InAppMessageFull) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)prepareInAppMessageWithBitmapDownload.6.INSTANCE, (int)2, null);
                return false;
            }
            return true;
        }
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)((Function0)new Function0<String>(remoteImageUrl){
            final /* synthetic */ String $remoteImageUrl;
            {
                this.$remoteImageUrl = $remoteImageUrl;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "In-app message has remote image url. Downloading image at url: " + this.$remoteImageUrl;
            }
        }), (int)2, null);
        inAppMessageWithImage.setBitmap(imageLoader.getInAppMessageBitmapFromUrl(applicationContext, inAppMessage, remoteImageUrl, viewBounds));
        if (inAppMessageWithImage.getBitmap() != null) {
            inAppMessageWithImage.setImageDownloadSuccessful(true);
            return true;
        }
        return false;
    }

    private final boolean handleLocalImage(String localImageUrl, IInAppMessageWithImage inAppMessageWithImage, IBrazeImageLoader imageLoader, Context applicationContext, IInAppMessage inAppMessage, BrazeViewBounds viewBounds) {
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)((Function0)new Function0<String>(localImageUrl){
            final /* synthetic */ String $localImageUrl;
            {
                this.$localImageUrl = $localImageUrl;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Passing in-app message local image url to image loader: " + this.$localImageUrl;
            }
        }), (int)2, null);
        inAppMessageWithImage.setBitmap(imageLoader.getInAppMessageBitmapFromUrl(applicationContext, inAppMessage, localImageUrl, viewBounds));
        if (inAppMessageWithImage.getBitmap() != null) {
            inAppMessageWithImage.setImageDownloadSuccessful(true);
            return true;
        }
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)((Function0)new Function0<String>(localImageUrl){
            final /* synthetic */ String $localImageUrl;
            {
                this.$localImageUrl = $localImageUrl;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Removing local image url from IAM since it could not be loaded. URL: " + this.$localImageUrl;
            }
        }), (int)3, null);
        inAppMessageWithImage.setLocalImageUrl(null);
        return false;
    }

    @VisibleForTesting
    public final void prepareInAppMessageWithHtml(@NotNull InAppMessageHtml inAppMessage) {
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        if (inAppMessage.getLocalPrefetchedAssetPaths().isEmpty()) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)prepareInAppMessageWithHtml.1.INSTANCE, (int)3, null);
            return;
        }
        String message = inAppMessage.getMessage();
        if (message == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)prepareInAppMessageWithHtml.2.INSTANCE, (int)3, null);
            return;
        }
        String transformedHtml = WebContentUtils.replacePrefetchedUrlsWithLocalAssets((String)message, (Map)inAppMessage.getLocalPrefetchedAssetPaths());
        inAppMessage.setMessage(transformedHtml);
    }

    private final BrazeViewBounds getViewBoundsByType(IInAppMessage inAppMessage) {
        BrazeViewBounds brazeViewBounds;
        switch (WhenMappings.$EnumSwitchMapping$0[inAppMessage.getMessageType().ordinal()]) {
            case 3: {
                brazeViewBounds = BrazeViewBounds.IN_APP_MESSAGE_SLIDEUP;
                break;
            }
            case 4: {
                brazeViewBounds = BrazeViewBounds.IN_APP_MESSAGE_MODAL;
                break;
            }
            default: {
                brazeViewBounds = BrazeViewBounds.NO_BOUNDS;
            }
        }
        return brazeViewBounds;
    }

    private final Object displayPreparedInAppMessage(IInAppMessage inAppMessage, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, inAppMessage, null){
            int label;
            final /* synthetic */ BackgroundInAppMessagePreparer this$0;
            final /* synthetic */ IInAppMessage $inAppMessage;
            {
                this.this$0 = $receiver;
                this.$inAppMessage = $inAppMessage;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this.this$0, null, null, (Function0)displayPreparedInAppMessage.1.INSTANCE, (int)3, null);
                        BrazeInAppMessageManager.Companion.getInstance().displayInAppMessage(this.$inAppMessage, false);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ IInAppMessage access$prepareInAppMessage(BackgroundInAppMessagePreparer $this, IInAppMessage inAppMessageToPrepare) {
        return $this.prepareInAppMessage(inAppMessageToPrepare);
    }

    public static final /* synthetic */ Object access$displayPreparedInAppMessage(BackgroundInAppMessagePreparer $this, IInAppMessage inAppMessage, Continuation $completion) {
        return $this.displayPreparedInAppMessage(inAppMessage, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageType.values().length];
            nArray[MessageType.HTML_FULL.ordinal()] = 1;
            nArray[MessageType.HTML.ordinal()] = 2;
            nArray[MessageType.SLIDEUP.ordinal()] = 3;
            nArray[MessageType.MODAL.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

