/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.inappmessage.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BlendMode;
import android.graphics.BlendModeColorFilter;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import com.braze.enums.inappmessage.TextAlign;
import com.braze.support.BrazeLogger;
import com.braze.ui.inappmessage.BrazeInAppMessageManager;
import com.braze.ui.inappmessage.utils.InAppMessageViewUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u001c\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0007J\u001a\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0007J\u001a\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0002J\u001f\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010\u0012J2\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0007H\u0007J\u001a\u0010\u001b\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0018\u0010 \u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"H\u0007J\u0018\u0010#\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010$\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0007J\u001a\u0010%\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006&"}, d2={"Lcom/braze/ui/inappmessage/utils/InAppMessageViewUtils;", "", "()V", "closeInAppMessageOnKeycodeBack", "", "resetMessageMarginsIfNecessary", "messageView", "Landroid/widget/TextView;", "headerView", "setDrawableColor", "drawable", "Landroid/graphics/drawable/Drawable;", "color", "", "setDrawableColorFilter", "setFrameColor", "view", "Landroid/view/View;", "(Landroid/view/View;Ljava/lang/Integer;)V", "setIcon", "context", "Landroid/content/Context;", "icon", "", "iconColor", "iconBackgroundColor", "textView", "setImage", "bitmap", "Landroid/graphics/Bitmap;", "imageView", "Landroid/widget/ImageView;", "setTextAlignment", "textAlign", "Lcom/braze/enums/inappmessage/TextAlign;", "setTextViewColor", "setViewBackgroundColor", "setViewBackgroundColorFilter", "android-sdk-ui_release"})
public final class InAppMessageViewUtils {
    @NotNull
    public static final InAppMessageViewUtils INSTANCE = new InAppMessageViewUtils();

    private InAppMessageViewUtils() {
    }

    @JvmStatic
    public static final void setImage(@Nullable Bitmap bitmap, @NotNull ImageView imageView) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        if (bitmap != null) {
            imageView.setImageBitmap(bitmap);
        }
    }

    @JvmStatic
    public static final void setIcon(@NotNull Context context, @Nullable String icon, int iconColor, int iconBackgroundColor, @NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        if (icon != null) {
            try {
                textView.setTypeface(Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fontawesome-webfont.ttf"));
            }
            catch (Exception e) {
                BrazeLogger.INSTANCE.brazelog((Object)INSTANCE, BrazeLogger.Priority.E, (Throwable)e, (Function0)setIcon.1.INSTANCE);
                return;
            }
            textView.setText((CharSequence)icon);
            InAppMessageViewUtils.setTextViewColor(textView, iconColor);
            if (textView.getBackground() != null) {
                Drawable drawable2 = textView.getBackground();
                Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"textView.background");
                InAppMessageViewUtils.setDrawableColor(drawable2, iconBackgroundColor);
            } else {
                InAppMessageViewUtils.setViewBackgroundColor((View)textView, iconBackgroundColor);
            }
        }
    }

    @JvmStatic
    public static final void setFrameColor(@NotNull View view, @Nullable Integer color2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Integer n = color2;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            view.setBackgroundColor(it);
        }
    }

    @JvmStatic
    public static final void setTextViewColor(@NotNull TextView textView, int color2) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        textView.setTextColor(color2);
    }

    @JvmStatic
    public static final void setViewBackgroundColor(@NotNull View view, int color2) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setBackgroundColor(color2);
    }

    @JvmStatic
    public static final void setViewBackgroundColorFilter(@NotNull View view, @ColorInt int color2) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Drawable drawable2 = view.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"view.background");
        INSTANCE.setDrawableColorFilter(drawable2, color2);
        view.getBackground().setAlpha(Color.alpha((int)color2));
    }

    @JvmStatic
    public static final void setDrawableColor(@NotNull Drawable drawable2, @ColorInt int color2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        if (Build.VERSION.SDK_INT >= 21 && drawable2 instanceof LayerDrawable) {
            if (((LayerDrawable)drawable2).getNumberOfLayers() > 0 && ((LayerDrawable)drawable2).getDrawable(0) instanceof GradientDrawable) {
                Drawable drawable3 = ((LayerDrawable)drawable2).getDrawable(0);
                Intrinsics.checkNotNullExpressionValue((Object)drawable3, (String)"drawable.getDrawable(0)");
                InAppMessageViewUtils.setDrawableColor(drawable3, color2);
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setDrawableColor.1.INSTANCE, (int)3, null);
            }
        }
        if (drawable2 instanceof GradientDrawable) {
            ((GradientDrawable)drawable2).setColor(color2);
        } else {
            INSTANCE.setDrawableColorFilter(drawable2, color2);
        }
    }

    @JvmStatic
    public static final void resetMessageMarginsIfNecessary(@Nullable TextView messageView, @Nullable TextView headerView) {
        if (headerView == null && messageView != null) {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(messageView.getLayoutParams().width, messageView.getLayoutParams().height);
            layoutParams.setMargins(0, 0, 0, 0);
            messageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    @JvmStatic
    public static final void closeInAppMessageOnKeycodeBack() {
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)closeInAppMessageOnKeycodeBack.1.INSTANCE, (int)3, null);
        BrazeInAppMessageManager.Companion.getInstance().hideCurrentlyDisplayingInAppMessage(true);
    }

    @JvmStatic
    public static final void setTextAlignment(@NotNull TextView textView, @NotNull TextAlign textAlign) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        Intrinsics.checkNotNullParameter((Object)textAlign, (String)"textAlign");
        if (textAlign == TextAlign.START) {
            textView.setGravity(0x800003);
        } else if (textAlign == TextAlign.END) {
            textView.setGravity(0x800005);
        } else if (textAlign == TextAlign.CENTER) {
            textView.setGravity(17);
        }
    }

    private final void setDrawableColorFilter(Drawable drawable2, @ColorInt int color2) {
        if (Build.VERSION.SDK_INT >= 29) {
            drawable2.setColorFilter((ColorFilter)new BlendModeColorFilter(color2, BlendMode.SRC_ATOP));
        } else {
            drawable2.setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
        }
    }
}

