/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.inappmessage.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewParent;
import android.widget.ImageView;
import com.braze.enums.inappmessage.CropType;
import com.braze.support.BrazeLogger;
import com.braze.ui.inappmessage.views.IInAppMessageImageView;
import com.braze.ui.inappmessage.views.InAppMessageImageView;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#J\u0010\u0010%\u001a\u00020&2\u0006\u0010 \u001a\u00020!H\u0014J\u0018\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020#H\u0014J\u0010\u0010*\u001a\u00020&2\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u00020\tH\u0016J\u0010\u00100\u001a\u00020&2\u0006\u00101\u001a\u00020\tH\u0016J\u0012\u00102\u001a\u00020&2\b\u00103\u001a\u0004\u0018\u000104H\u0016J\u0010\u0010\u001b\u001a\u00020&2\u0006\u00105\u001a\u00020\u001cH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001d\u0010\u001e\u00a8\u00066"}, d2={"Lcom/braze/ui/inappmessage/views/InAppMessageImageView;", "Landroid/widget/ImageView;", "Lcom/braze/ui/inappmessage/views/IInAppMessageImageView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "aspectRatio", "", "clipPath", "Landroid/graphics/Path;", "getClipPath", "()Landroid/graphics/Path;", "setClipPath", "(Landroid/graphics/Path;)V", "<set-?>", "", "inAppRadii", "getInAppRadii", "()[F", "rectf", "Landroid/graphics/RectF;", "getRectf", "()Landroid/graphics/RectF;", "setRectf", "(Landroid/graphics/RectF;)V", "setToHalfParentHeight", "", "getSetToHalfParentHeight$annotations", "()V", "clipCanvasToPath", "canvas", "Landroid/graphics/Canvas;", "widthPx", "", "heightPx", "onDraw", "", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setAspectRatio", "setCornersRadiiPx", "topLeft", "topRight", "bottomLeft", "bottomRight", "setCornersRadiusPx", "cornersRadius", "setInAppMessageImageCropType", "cropType", "Lcom/braze/enums/inappmessage/CropType;", "setToHalfHeight", "android-sdk-ui_release"})
@SuppressLint(value={"AppCompatCustomView"})
public class InAppMessageImageView
extends ImageView
implements IInAppMessageImageView {
    @NotNull
    private Path clipPath = new Path();
    @NotNull
    private RectF rectf = new RectF();
    private float[] inAppRadii;
    private float aspectRatio = -1.0f;
    private boolean setToHalfParentHeight;

    public InAppMessageImageView(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.setAdjustViewBounds(true);
    }

    @NotNull
    public final Path getClipPath() {
        return this.clipPath;
    }

    public final void setClipPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.clipPath = path;
    }

    @NotNull
    public final RectF getRectf() {
        return this.rectf;
    }

    public final void setRectf(@NotNull RectF rectF) {
        Intrinsics.checkNotNullParameter((Object)rectF, (String)"<set-?>");
        this.rectf = rectF;
    }

    @NotNull
    public final float[] getInAppRadii() {
        if (this.inAppRadii != null) {
            return this.inAppRadii;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"inAppRadii");
        return null;
    }

    private static /* synthetic */ void getSetToHalfParentHeight$annotations() {
    }

    @Override
    public void setCornersRadiiPx(float topLeft, float topRight, float bottomLeft, float bottomRight) {
        float[] fArray = new float[]{topLeft, topLeft, topRight, topRight, bottomLeft, bottomLeft, bottomRight, bottomRight};
        this.inAppRadii = fArray;
    }

    @Override
    public void setCornersRadiusPx(float cornersRadius) {
        this.setCornersRadiiPx(cornersRadius, cornersRadius, cornersRadius, cornersRadius);
    }

    @Override
    public void setInAppMessageImageCropType(@Nullable CropType cropType) {
        if (cropType == CropType.FIT_CENTER) {
            this.setScaleType(ImageView.ScaleType.FIT_CENTER);
        } else if (cropType == CropType.CENTER_CROP) {
            this.setScaleType(ImageView.ScaleType.CENTER_CROP);
        }
    }

    @Override
    public void setAspectRatio(float aspectRatio) {
        this.aspectRatio = aspectRatio;
        this.requestLayout();
    }

    @Override
    public void setToHalfParentHeight(boolean setToHalfHeight) {
        this.setToHalfParentHeight = setToHalfHeight;
        this.requestLayout();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.clipCanvasToPath(canvas, this.getWidth(), this.getHeight());
        super.onDraw(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!(this.aspectRatio == -1.0f) && this.getMeasuredHeight() > 0 && this.getMeasuredWidth() > 0) {
            int newWidth = this.getMeasuredWidth();
            int maxHeight = (int)((float)newWidth / this.aspectRatio);
            int newHeight = Math.min(this.getMeasuredHeight(), maxHeight) + 1;
            this.setMeasuredDimension(newWidth, newHeight);
        } else {
            this.setMeasuredDimension(this.getMeasuredWidth(), this.getMeasuredHeight());
        }
        if (this.setToHalfParentHeight) {
            ViewParent viewParent = this.getParent();
            if (viewParent == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.View");
            }
            int parentHeight = ((View)viewParent).getHeight();
            this.setMeasuredDimension(this.getMeasuredWidth(), (int)((double)parentHeight * 0.5));
        }
    }

    public final boolean clipCanvasToPath(@NotNull Canvas canvas, int widthPx, int heightPx) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.inAppRadii == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)clipCanvasToPath.2.INSTANCE, (int)3, null);
            return false;
        }
        try {
            this.clipPath.reset();
            this.rectf.set(0.0f, 0.0f, (float)widthPx, (float)heightPx);
            this.clipPath.addRoundRect(this.rectf, this.getInAppRadii(), Path.Direction.CW);
            canvas.clipPath(this.clipPath);
            bl = true;
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)this, BrazeLogger.Priority.E, (Throwable)e, (Function0)clipCanvasToPath.3.INSTANCE);
            bl = false;
        }
        return bl;
    }
}

