/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.inappmessage.views;

import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewParent;
import android.widget.TextView;
import com.braze.enums.inappmessage.TextAlign;
import com.braze.models.inappmessage.MessageButton;
import com.braze.support.BrazeLogger;
import com.braze.ui.R;
import com.braze.ui.inappmessage.BrazeInAppMessageManager;
import com.braze.ui.inappmessage.utils.InAppMessageButtonViewUtils;
import com.braze.ui.inappmessage.utils.InAppMessageViewUtils;
import com.braze.ui.inappmessage.views.IInAppMessageImmersiveView;
import com.braze.ui.inappmessage.views.InAppMessageBaseView;
import com.braze.ui.inappmessage.views.InAppMessageImmersiveBaseView;
import com.braze.ui.support.ViewUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\u0006\u0010\u0018\u001a\u00020\u0019H&J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0013H\u0016J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0019H\u0016J\u0012\u0010!\u001a\u00020\u001d2\b\u0010\"\u001a\u0004\u0018\u00010\tH\u0016J\u0016\u0010#\u001a\u00020\u001d2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0017H\u0016J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0019H\u0016J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0019H\u0016J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\b\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u0004\u0018\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u0004\u0018\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006/"}, d2={"Lcom/braze/ui/inappmessage/views/InAppMessageImmersiveBaseView;", "Lcom/braze/ui/inappmessage/views/InAppMessageBaseView;", "Lcom/braze/ui/inappmessage/views/IInAppMessageImmersiveView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "frameView", "Landroid/view/View;", "getFrameView", "()Landroid/view/View;", "messageHeaderTextView", "Landroid/widget/TextView;", "getMessageHeaderTextView", "()Landroid/widget/TextView;", "messageTextView", "getMessageTextView", "dispatchKeyEvent", "", "event", "Landroid/view/KeyEvent;", "getMessageButtonViews", "", "numButtons", "", "onKeyDown", "keyCode", "resetMessageMargins", "", "imageRetrievalSuccessful", "setFrameColor", "color", "setLargerCloseButtonClickArea", "closeButtonView", "setMessageButtons", "messageButtons", "Lcom/braze/models/inappmessage/MessageButton;", "setMessageCloseButtonColor", "setMessageHeaderText", "text", "", "setMessageHeaderTextAlignment", "textAlign", "Lcom/braze/enums/inappmessage/TextAlign;", "setMessageHeaderTextColor", "setupDirectionalNavigation", "android-sdk-ui_release"})
public abstract class InAppMessageImmersiveBaseView
extends InAppMessageBaseView
implements IInAppMessageImmersiveView {
    public InAppMessageImmersiveBaseView(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @Nullable
    public abstract View getFrameView();

    @Override
    @Nullable
    public abstract TextView getMessageTextView();

    @Nullable
    public abstract TextView getMessageHeaderTextView();

    @Override
    public void resetMessageMargins(boolean imageRetrievalSuccessful) {
        super.resetMessageMargins(imageRetrievalSuccessful);
        TextView textView = this.getMessageTextView();
        if (StringsKt.isBlank((CharSequence)String.valueOf(textView != null ? textView.getText() : null))) {
            ViewUtils.removeViewFromParent((View)this.getMessageTextView());
        }
        TextView textView2 = this.getMessageHeaderTextView();
        if (StringsKt.isBlank((CharSequence)String.valueOf(textView2 != null ? textView2.getText() : null))) {
            ViewUtils.removeViewFromParent((View)this.getMessageHeaderTextView());
        }
        InAppMessageViewUtils.resetMessageMarginsIfNecessary(this.getMessageTextView(), this.getMessageHeaderTextView());
    }

    @Override
    public void setupDirectionalNavigation(int numButtons) {
        block9: {
            Integer closeButtonId;
            View closeButton;
            List<View> messageButtonViews = this.getMessageButtonViews(numButtons);
            View view = closeButton = this.getMessageCloseButtonView();
            Integer defaultFocusId = closeButtonId = view != null ? Integer.valueOf(view.getId()) : null;
            View defaultFocusView = closeButton;
            View primaryButton = null;
            View secondaryButton = null;
            Integer primaryId = null;
            Integer secondaryId = null;
            if (closeButtonId == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)setupDirectionalNavigation.1.INSTANCE, (int)2, null);
                return;
            }
            switch (numButtons) {
                case 2: {
                    primaryButton = messageButtonViews.get(1);
                    secondaryButton = messageButtonViews.get(0);
                    primaryId = primaryButton.getId();
                    secondaryId = secondaryButton.getId();
                    defaultFocusId = primaryId;
                    defaultFocusView = primaryButton;
                    primaryButton.setNextFocusLeftId(secondaryId.intValue());
                    primaryButton.setNextFocusRightId(secondaryId.intValue());
                    primaryButton.setNextFocusUpId(closeButtonId.intValue());
                    primaryButton.setNextFocusDownId(closeButtonId.intValue());
                    secondaryButton.setNextFocusLeftId(primaryId.intValue());
                    secondaryButton.setNextFocusRightId(primaryId.intValue());
                    secondaryButton.setNextFocusUpId(closeButtonId.intValue());
                    secondaryButton.setNextFocusDownId(closeButtonId.intValue());
                    closeButton.setNextFocusUpId(primaryId.intValue());
                    closeButton.setNextFocusDownId(primaryId.intValue());
                    closeButton.setNextFocusRightId(primaryId.intValue());
                    closeButton.setNextFocusLeftId(secondaryId.intValue());
                    break;
                }
                case 1: {
                    primaryButton = messageButtonViews.get(0);
                    defaultFocusId = primaryId = Integer.valueOf(primaryButton.getId());
                    defaultFocusView = primaryButton;
                    primaryButton.setNextFocusLeftId(closeButtonId.intValue());
                    primaryButton.setNextFocusRightId(closeButtonId.intValue());
                    primaryButton.setNextFocusUpId(closeButtonId.intValue());
                    primaryButton.setNextFocusDownId(closeButtonId.intValue());
                    closeButton.setNextFocusUpId(primaryId.intValue());
                    closeButton.setNextFocusDownId(primaryId.intValue());
                    closeButton.setNextFocusRightId(primaryId.intValue());
                    closeButton.setNextFocusLeftId(primaryId.intValue());
                    break;
                }
                case 0: {
                    closeButton.setNextFocusUpId(closeButtonId.intValue());
                    closeButton.setNextFocusDownId(closeButtonId.intValue());
                    closeButton.setNextFocusRightId(closeButtonId.intValue());
                    closeButton.setNextFocusLeftId(closeButtonId.intValue());
                    break;
                }
                default: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)((Function0)new Function0<String>(numButtons){
                        final /* synthetic */ int $numButtons;
                        {
                            this.$numButtons = $numButtons;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Cannot setup directional navigation. Got unsupported number of buttons: " + this.$numButtons;
                        }
                    }), (int)2, null);
                }
            }
            if (defaultFocusId != null) {
                this.setNextFocusUpId(defaultFocusId);
                this.setNextFocusDownId(defaultFocusId);
                this.setNextFocusRightId(defaultFocusId);
                this.setNextFocusLeftId(defaultFocusId);
            }
            View finalDefaultFocusView = defaultFocusView;
            if (Build.VERSION.SDK_INT >= 26) {
                View view2 = finalDefaultFocusView;
                if (view2 != null) {
                    view2.setFocusedByDefault(true);
                }
            }
            View view3 = finalDefaultFocusView;
            if (view3 == null) break block9;
            view3.post(() -> InAppMessageImmersiveBaseView.setupDirectionalNavigation$lambda-0(finalDefaultFocusView));
        }
    }

    public void setMessageButtons(@NotNull List<? extends MessageButton> messageButtons) {
        Intrinsics.checkNotNullParameter(messageButtons, (String)"messageButtons");
        InAppMessageButtonViewUtils.setButtons(this.getMessageButtonViews(messageButtons.size()), messageButtons);
    }

    public void setMessageCloseButtonColor(int color2) {
        block0: {
            View view = this.getMessageCloseButtonView();
            if (view == null) break block0;
            View it = view;
            boolean bl = false;
            InAppMessageViewUtils.setViewBackgroundColorFilter(it, color2);
        }
    }

    public void setMessageHeaderTextColor(int color2) {
        block0: {
            TextView textView = this.getMessageHeaderTextView();
            if (textView == null) break block0;
            TextView it = textView;
            boolean bl = false;
            InAppMessageViewUtils.setTextViewColor(it, color2);
        }
    }

    public void setMessageHeaderText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TextView textView = this.getMessageHeaderTextView();
        if (textView != null) {
            textView.setText((CharSequence)text);
        }
    }

    public void setMessageHeaderTextAlignment(@NotNull TextAlign textAlign) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)textAlign, (String)"textAlign");
            TextView textView = this.getMessageHeaderTextView();
            if (textView == null) break block0;
            TextView it = textView;
            boolean bl = false;
            InAppMessageViewUtils.setTextAlignment(it, textAlign);
        }
    }

    public void setFrameColor(int color2) {
        block0: {
            View view = this.getFrameView();
            if (view == null) break block0;
            View it = view;
            boolean bl = false;
            InAppMessageViewUtils.setFrameColor(it, color2);
        }
    }

    @Override
    @NotNull
    public abstract List<View> getMessageButtonViews(int var1);

    public boolean onKeyDown(int keyCode, @NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (keyCode == 4 && BrazeInAppMessageManager.Companion.getInstance().getDoesBackButtonDismissInAppMessageView()) {
            InAppMessageViewUtils.closeInAppMessageOnKeycodeBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean dispatchKeyEvent(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isInTouchMode() && event.getKeyCode() == 4 && BrazeInAppMessageManager.Companion.getInstance().getDoesBackButtonDismissInAppMessageView()) {
            InAppMessageViewUtils.closeInAppMessageOnKeycodeBack();
            return true;
        }
        return super.dispatchKeyEvent(event);
    }

    public void setLargerCloseButtonClickArea(@Nullable View closeButtonView) {
        if (closeButtonView == null || closeButtonView.getParent() == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)setLargerCloseButtonClickArea.1.INSTANCE, (int)2, null);
            return;
        }
        ViewParent parent = closeButtonView.getParent();
        if (parent instanceof View) {
            ((View)parent).post(() -> InAppMessageImmersiveBaseView.setLargerCloseButtonClickArea$lambda-5(closeButtonView, this, parent));
        }
    }

    private static final void setupDirectionalNavigation$lambda-0(View $finalDefaultFocusView) {
        $finalDefaultFocusView.requestFocus();
    }

    private static final void setLargerCloseButtonClickArea$lambda-5(View $closeButtonView, InAppMessageImmersiveBaseView this$0, ViewParent $parent) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Rect delegateArea = new Rect();
        $closeButtonView.getHitRect(delegateArea);
        int desiredCloseButtonClickAreaWidth = this$0.getContext().getResources().getDimensionPixelSize(R.dimen.com_braze_inappmessage_close_button_click_area_width);
        int desiredCloseButtonClickAreaHeight = this$0.getContext().getResources().getDimensionPixelSize(R.dimen.com_braze_inappmessage_close_button_click_area_height);
        int extraHorizontalPadding = (desiredCloseButtonClickAreaWidth - delegateArea.width()) / 2;
        int extraVerticalPadding = (desiredCloseButtonClickAreaHeight - delegateArea.height()) / 2;
        delegateArea.top -= extraVerticalPadding;
        delegateArea.bottom += extraVerticalPadding;
        delegateArea.left -= extraHorizontalPadding;
        delegateArea.right += extraHorizontalPadding;
        TouchDelegate touchDelegate = new TouchDelegate(delegateArea, $closeButtonView);
        ((View)$parent).setTouchDelegate(touchDelegate);
    }
}

