/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.support;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import com.braze.IBrazeDeeplinkHandler;
import com.braze.support.BrazeLogger;
import com.braze.ui.BrazeDeeplinkHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0001\u001a\u0016\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\f*\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"TAG", "", "getMainActivityIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "extras", "Landroid/os/Bundle;", "isActivityRegisteredInManifest", "", "className", "getQueryParameters", "", "Landroid/net/Uri;", "android-sdk-ui_release"})
@JvmName(name="UriUtils")
public final class UriUtils {
    @NotNull
    private static final String TAG = BrazeLogger.INSTANCE.getBrazeLogTag("UriUtils");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> getQueryParameters(@NotNull Uri $this$getQueryParameters) {
        Intrinsics.checkNotNullParameter((Object)$this$getQueryParameters, (String)"<this>");
        Ref.ObjectRef uri = new Ref.ObjectRef();
        uri.element = $this$getQueryParameters;
        String encodedQuery = ((Uri)uri.element).getEncodedQuery();
        if (encodedQuery == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (String)TAG, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>((Ref.ObjectRef<Uri>)uri){
                final /* synthetic */ Ref.ObjectRef<Uri> $uri;
                {
                    this.$uri = $uri;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Encoded query is null for Uri: " + this.$uri.element + " Returning empty map for query parameters";
                }
            }), (int)4, null);
            return MapsKt.emptyMap();
        }
        Map parameterValues = new LinkedHashMap();
        try {
            void $this$filterTo$iv$iv;
            if (((Uri)uri.element).isOpaque()) {
                Uri uri2 = Uri.parse((String)"://").buildUpon().encodedQuery(encodedQuery).build();
                Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"parse(\"://\")\n           \u2026\n                .build()");
                uri.element = uri2;
            }
            Set set = ((Uri)uri.element).getQueryParameterNames();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"uri.queryParameterNames");
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                CharSequence charSequence = it;
                boolean bl2 = !(charSequence == null || charSequence.length() == 0);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List queryParameterNames = (List)destination$iv$iv;
            for (String queryParameterKey : queryParameterNames) {
                String queryParameterValue = ((Uri)uri.element).getQueryParameter(queryParameterKey);
                CharSequence charSequence = queryParameterValue;
                if (charSequence == null || charSequence.length() == 0) continue;
                Intrinsics.checkNotNullExpressionValue((Object)queryParameterKey, (String)"queryParameterKey");
                parameterValues.put(queryParameterKey, queryParameterValue);
            }
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog(TAG, BrazeLogger.Priority.E, (Throwable)e, (Function0)new Function0<String>((Ref.ObjectRef<Uri>)uri){
                final /* synthetic */ Ref.ObjectRef<Uri> $uri;
                {
                    this.$uri = $uri;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Failed to map the query parameters of Uri: " + this.$uri.element;
                }
            });
        }
        return parameterValues;
    }

    @Nullable
    public static final Intent getMainActivityIntent(@NotNull Context context, @Nullable Bundle extras) {
        Intent startActivityIntent;
        block2: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = startActivityIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
            if (intent != null) {
                intent.setFlags(BrazeDeeplinkHandler.Companion.getInstance().getIntentFlags(IBrazeDeeplinkHandler.IntentFlagPurpose.URI_UTILS_GET_MAIN_ACTIVITY_INTENT));
            }
            if (extras == null) break block2;
            Intent intent2 = startActivityIntent;
            if (intent2 != null) {
                intent2.putExtras(extras);
            }
        }
        return startActivityIntent;
    }

    public static /* synthetic */ Intent getMainActivityIntent$default(Context context, Bundle bundle, int n, Object object) {
        if ((n & 2) != 0) {
            bundle = null;
        }
        return UriUtils.getMainActivityIntent(context, bundle);
    }

    public static final boolean isActivityRegisteredInManifest(@NotNull Context context, @NotNull String className) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        try {
            if (Build.VERSION.SDK_INT >= 33) {
                context.getPackageManager().getActivityInfo(new ComponentName(context, className), PackageManager.ComponentInfoFlags.of((long)0L));
            } else {
                context.getPackageManager().getActivityInfo(new ComponentName(context, className), 0);
            }
            bl = true;
        }
        catch (PackageManager.NameNotFoundException e) {
            BrazeLogger.INSTANCE.brazelog(TAG, BrazeLogger.Priority.W, (Throwable)e, (Function0)new Function0<String>(className){
                final /* synthetic */ String $className;
                {
                    this.$className = $className;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Could not find activity info for class with name: " + this.$className;
                }
            });
            bl = false;
        }
        return bl;
    }
}

