/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.widget;

import android.content.Context;
import android.os.Bundle;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.braze.Braze;
import com.braze.configuration.BrazeConfigurationProvider;
import com.braze.enums.BrazeViewBounds;
import com.braze.images.IBrazeImageLoader;
import com.braze.models.cards.Card;
import com.braze.support.BrazeLogger;
import com.braze.ui.BrazeDeeplinkHandler;
import com.braze.ui.R;
import com.braze.ui.actions.IAction;
import com.braze.ui.actions.UriAction;
import com.braze.ui.feed.BrazeImageSwitcher;
import com.braze.ui.widget.BaseCardView;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 &*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001&B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0004J\"\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H$J\u0018\u0010\u001b\u001a\u00020\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\u0002J&\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\b\u001a\u00020\u0002J\u0018\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u000bR\u0010\u0010\u0007\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00018\u00008\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000f8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lcom/braze/ui/widget/BaseCardView;", "T", "Lcom/braze/models/cards/Card;", "Landroid/widget/RelativeLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "applicationContext", "card", "Lcom/braze/models/cards/Card;", "classLogTag", "", "getClassLogTag", "()Ljava/lang/String;", "configurationProvider", "Lcom/braze/configuration/BrazeConfigurationProvider;", "imageSwitcher", "Lcom/braze/ui/feed/BrazeImageSwitcher;", "isUnreadCardVisualIndicatorEnabled", "", "isUnreadIndicatorEnabled", "()Z", "handleCardClick", "", "cardAction", "Lcom/braze/ui/actions/IAction;", "isClickHandled", "setCardViewedIndicator", "setImageViewToUrl", "imageView", "Landroid/widget/ImageView;", "imageUrl", "placeholderAspectRatio", "", "setOptionalTextView", "view", "Landroid/widget/TextView;", "text", "Companion", "android-sdk-ui_release"})
public abstract class BaseCardView<T extends Card>
extends RelativeLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    protected final Context applicationContext;
    @NotNull
    private final String classLogTag;
    @JvmField
    @Nullable
    protected T card;
    @JvmField
    @Nullable
    public BrazeImageSwitcher imageSwitcher;
    @JvmField
    @NotNull
    protected BrazeConfigurationProvider configurationProvider;
    private final boolean isUnreadCardVisualIndicatorEnabled;
    @NotNull
    private static final String ICON_READ_TAG = "icon_read";
    @NotNull
    private static final String ICON_UNREAD_TAG = "icon_unread";

    public BaseCardView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this.applicationContext = context2;
        this.classLogTag = BrazeLogger.getBrazeLogTag(((Object)((Object)this)).getClass());
        this.configurationProvider = new BrazeConfigurationProvider(context);
        this.isUnreadCardVisualIndicatorEnabled = this.configurationProvider.isNewsfeedVisualIndicatorOn();
    }

    @NotNull
    public final String getClassLogTag() {
        return this.classLogTag;
    }

    public final boolean isUnreadIndicatorEnabled() {
        return this.isUnreadCardVisualIndicatorEnabled;
    }

    public final void setOptionalTextView(@NotNull TextView view, @Nullable String text) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        CharSequence charSequence = text;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            view.setText((CharSequence)text);
            view.setVisibility(0);
        } else {
            view.setText((CharSequence)"");
            view.setVisibility(8);
        }
    }

    public final void setImageViewToUrl(@NotNull ImageView imageView, @NotNull String imageUrl, float placeholderAspectRatio, @NotNull Card card) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        if (!Intrinsics.areEqual((Object)imageUrl, (Object)imageView.getTag(R.string.com_braze_image_resize_tag_key))) {
            ViewTreeObserver viewTreeObserver;
            if (!(placeholderAspectRatio == 0.0f) && (viewTreeObserver = imageView.getViewTreeObserver()).isAlive()) {
                viewTreeObserver.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(imageView, placeholderAspectRatio){
                    final /* synthetic */ ImageView $imageView;
                    final /* synthetic */ float $placeholderAspectRatio;
                    {
                        this.$imageView = $imageView;
                        this.$placeholderAspectRatio = $placeholderAspectRatio;
                    }

                    public boolean onPreDraw() {
                        this.$imageView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                        int width = this.$imageView.getWidth();
                        this.$imageView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(width, (int)((float)width / this.$placeholderAspectRatio)));
                        return true;
                    }
                });
            }
            imageView.setImageResource(17170445);
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            IBrazeImageLoader iBrazeImageLoader = Braze.Companion.getInstance(context).getImageLoader();
            Context context2 = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
            iBrazeImageLoader.renderUrlIntoCardView(context2, card, imageUrl, imageView, BrazeViewBounds.BASE_CARD_VIEW);
            imageView.setTag(R.string.com_braze_image_resize_tag_key, (Object)imageUrl);
        }
    }

    public final void setCardViewedIndicator(@Nullable BrazeImageSwitcher imageSwitcher, @NotNull Card card) {
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        if (imageSwitcher == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)setCardViewedIndicator.1.INSTANCE, (int)2, null);
            return;
        }
        Object imageSwitcherTag = imageSwitcher.getTag(R.string.com_braze_image_is_read_tag_key);
        Object object = imageSwitcherTag;
        if (object == null) {
            object = imageSwitcherTag = "";
        }
        if (card.isIndicatorHighlighted()) {
            if (!Intrinsics.areEqual((Object)imageSwitcherTag, (Object)ICON_READ_TAG)) {
                if (imageSwitcher.getReadIcon() != null) {
                    imageSwitcher.setImageDrawable(imageSwitcher.getReadIcon());
                } else {
                    imageSwitcher.setImageResource(R.drawable.com_braze_content_card_icon_read);
                }
                imageSwitcher.setTag(R.string.com_braze_image_is_read_tag_key, ICON_READ_TAG);
            }
        } else if (!Intrinsics.areEqual((Object)imageSwitcherTag, (Object)ICON_UNREAD_TAG)) {
            if (imageSwitcher.getUnReadIcon() != null) {
                imageSwitcher.setImageDrawable(imageSwitcher.getUnReadIcon());
            } else {
                imageSwitcher.setImageResource(R.drawable.com_braze_content_card_icon_unread);
            }
            imageSwitcher.setTag(R.string.com_braze_image_is_read_tag_key, ICON_UNREAD_TAG);
        }
    }

    protected final void handleCardClick(@NotNull Context context, @NotNull Card card, @Nullable IAction cardAction) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>(card){
            final /* synthetic */ Card $card;
            {
                this.$card = $card;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Handling card click for card: " + this.$card;
            }
        }), (int)2, null);
        card.setIndicatorHighlighted(true);
        if (!this.isClickHandled(context, card, cardAction)) {
            if (cardAction != null) {
                card.logClick();
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>(card){
                    final /* synthetic */ Card $card;
                    {
                        this.$card = $card;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Card action is non-null. Attempting to perform action on card: " + this.$card.getId();
                    }
                }), (int)2, null);
                if (cardAction instanceof UriAction) {
                    BrazeDeeplinkHandler.Companion.getInstance().gotoUri(context, (UriAction)cardAction);
                } else {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), null, null, (Function0)((Function0)new Function0<String>(card){
                        final /* synthetic */ Card $card;
                        {
                            this.$card = $card;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Executing non uri action for click on card: " + this.$card.getId();
                        }
                    }), (int)3, null);
                    cardAction.execute(context);
                }
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>(card){
                    final /* synthetic */ Card $card;
                    {
                        this.$card = $card;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Card action is null. Not performing any click action on card: " + this.$card.getId();
                    }
                }), (int)2, null);
            }
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), null, null, (Function0)((Function0)new Function0<String>(card){
                final /* synthetic */ Card $card;
                {
                    this.$card = $card;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Card click was handled by custom listener on card: " + this.$card.getId();
                }
            }), (int)3, null);
            card.logClick();
        }
    }

    protected abstract boolean isClickHandled(@NotNull Context var1, @NotNull Card var2, @Nullable IAction var3);

    @JvmStatic
    @Nullable
    protected static final UriAction getUriActionForCard(@NotNull Card card) {
        return Companion.getUriActionForCard(card);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0005R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/braze/ui/widget/BaseCardView$Companion;", "", "()V", "ICON_READ_TAG", "", "ICON_UNREAD_TAG", "getUriActionForCard", "Lcom/braze/ui/actions/UriAction;", "card", "Lcom/braze/models/cards/Card;", "android-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        protected final UriAction getUriActionForCard(@NotNull Card card) {
            Intrinsics.checkNotNullParameter((Object)card, (String)"card");
            Bundle extras = new Bundle();
            for (String key : card.getExtras().keySet()) {
                extras.putString(key, (String)card.getExtras().get(key));
            }
            String url = card.getUrl();
            if (url == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)getUriActionForCard.1.INSTANCE, (int)2, null);
                return null;
            }
            return BrazeDeeplinkHandler.Companion.getInstance().createUriActionFromUrlString(url, extras, card.getOpenUriInWebView(), card.getChannel());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

