/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.widget;

import android.content.Context;
import android.widget.TextView;
import com.braze.models.cards.Card;
import com.braze.models.cards.TextAnnouncementCard;
import com.braze.support.BrazeLogger;
import com.braze.ui.R;
import com.braze.ui.actions.IAction;
import com.braze.ui.feed.view.BaseFeedCardView;

public class TextAnnouncementCardView
extends BaseFeedCardView<TextAnnouncementCard> {
    private static final String TAG = BrazeLogger.getBrazeLogTag(TextAnnouncementCardView.class);
    private final TextView mTitle = (TextView)this.findViewById(R.id.com_braze_text_announcement_card_title);
    private final TextView mDescription = (TextView)this.findViewById(R.id.com_braze_text_announcement_card_description);
    private final TextView mDomain = (TextView)this.findViewById(R.id.com_braze_text_announcement_card_domain);
    private IAction mCardAction;

    public TextAnnouncementCardView(Context context) {
        this(context, null);
    }

    public TextAnnouncementCardView(Context context, TextAnnouncementCard card) {
        super(context);
        if (card != null) {
            this.setCard(card);
        }
        this.setBackground(this.getResources().getDrawable(R.drawable.com_braze_card_background));
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.com_braze_text_announcement_card;
    }

    @Override
    public void onSetCard(TextAnnouncementCard card) {
        this.mTitle.setText((CharSequence)card.getTitle());
        this.mDescription.setText((CharSequence)card.getDescription());
        this.setOptionalTextView(this.mDomain, card.getDomain());
        this.mCardAction = TextAnnouncementCardView.getUriActionForCard((Card)card);
        this.setOnClickListener(view -> this.handleCardClick(this.applicationContext, (Card)card, this.mCardAction));
    }
}

