/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.feed.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.ImageView;
import com.braze.models.cards.Card;
import com.braze.support.BrazeLogger;
import com.braze.ui.R;
import com.braze.ui.actions.IAction;
import com.braze.ui.feed.BrazeFeedManager;
import com.braze.ui.feed.BrazeImageSwitcher;
import com.braze.ui.widget.BaseCardView;

public abstract class BaseFeedCardView<T extends Card>
extends BaseCardView<T> {
    private static final String TAG = BrazeLogger.getBrazeLogTag(BaseCardView.class);

    public BaseFeedCardView(Context context) {
        super(context);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater.inflate(this.getLayoutResource(), (ViewGroup)this);
        this.imageSwitcher = (BrazeImageSwitcher)this.findViewById(R.id.com_braze_newsfeed_item_read_indicator_image_switcher);
        if (this.imageSwitcher != null) {
            this.imageSwitcher.setFactory(() -> new ImageView(this.applicationContext));
        }
        if (!this.isUnreadIndicatorEnabled() && this.imageSwitcher != null) {
            this.imageSwitcher.setVisibility(8);
        }
    }

    public View getProperViewFromInflatedStub(int stubLayoutId) {
        ViewStub imageStub = (ViewStub)this.findViewById(stubLayoutId);
        imageStub.inflate();
        return this.findViewById(R.id.com_braze_stubbed_feed_image_view);
    }

    public void setCard(T newCard) {
        this.card = newCard;
        this.onSetCard(this.card);
        this.card.setListener(() -> this.setCardViewedIndicator(this.imageSwitcher, this.getCard()));
        this.setCardViewedIndicator(this.imageSwitcher, this.getCard());
    }

    public Card getCard() {
        return this.card;
    }

    @Override
    protected boolean isClickHandled(Context context, Card card, IAction cardAction) {
        return BrazeFeedManager.getInstance().getFeedCardClickActionListener().onFeedCardClicked(context, card, cardAction);
    }

    protected abstract int getLayoutResource();

    protected abstract void onSetCard(T var1);
}

