/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.inappmessage;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.animation.Animation;
import androidx.annotation.VisibleForTesting;
import com.braze.Braze;
import com.braze.BrazeInternal;
import com.braze.configuration.BrazeConfigurationProvider;
import com.braze.enums.inappmessage.InAppMessageFailureType;
import com.braze.enums.inappmessage.Orientation;
import com.braze.events.IEventSubscriber;
import com.braze.events.InAppMessageEvent;
import com.braze.events.SdkDataWipeEvent;
import com.braze.models.inappmessage.IInAppMessage;
import com.braze.models.inappmessage.InAppMessageHtml;
import com.braze.models.inappmessage.InAppMessageImmersiveBase;
import com.braze.support.BrazeLogger;
import com.braze.support.JsonUtils;
import com.braze.support.PermissionUtils;
import com.braze.ui.actions.brazeactions.BrazeActionUtils;
import com.braze.ui.inappmessage.BrazeInAppMessageManager;
import com.braze.ui.inappmessage.IInAppMessageViewFactory;
import com.braze.ui.inappmessage.IInAppMessageViewWrapper;
import com.braze.ui.inappmessage.IInAppMessageViewWrapperFactory;
import com.braze.ui.inappmessage.InAppMessageManagerBase;
import com.braze.ui.inappmessage.InAppMessageOperation;
import com.braze.ui.inappmessage.listeners.DefaultInAppMessageViewLifecycleListener;
import com.braze.ui.inappmessage.listeners.IInAppMessageManagerListener;
import com.braze.ui.inappmessage.listeners.IInAppMessageViewLifecycleListener;
import com.braze.ui.inappmessage.utils.BackgroundInAppMessagePreparer;
import com.braze.ui.inappmessage.views.IInAppMessageImmersiveView;
import com.braze.ui.inappmessage.views.IInAppMessageView;
import com.braze.ui.inappmessage.views.InAppMessageHtmlBaseView;
import com.braze.ui.support.ViewUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 >2\u00020\u0001:\u0001>B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u0004H\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0002J\u0018\u0010/\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00042\u0006\u00100\u001a\u00020 H\u0016J\u0010\u00101\u001a\u00020,2\u0006\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u00020 H\u0016J\u0010\u00105\u001a\u00020,2\u0006\u00106\u001a\u00020 H\u0016J\u0012\u00107\u001a\u00020,2\b\u00108\u001a\u0004\u0018\u000109H\u0016J\b\u0010:\u001a\u00020 H\u0016J\b\u0010;\u001a\u00020,H\u0016J\u0012\u0010<\u001a\u00020,2\b\u00108\u001a\u0004\u0018\u000109H\u0016J\u0010\u0010=\u001a\u00020 2\u0006\u0010-\u001a\u00020\u0004H\u0017R&\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u0002R\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00178\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0002\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!R\u0012\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010$R\u0016\u0010%\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010'\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b(\u0010\u0002\u001a\u0004\b)\u0010\u0007\"\u0004\b*\u0010\t\u00a8\u0006?"}, d2={"Lcom/braze/ui/inappmessage/BrazeInAppMessageManager;", "Lcom/braze/ui/inappmessage/InAppMessageManagerBase;", "()V", "carryoverInAppMessage", "Lcom/braze/models/inappmessage/IInAppMessage;", "getCarryoverInAppMessage$annotations", "getCarryoverInAppMessage", "()Lcom/braze/models/inappmessage/IInAppMessage;", "setCarryoverInAppMessage", "(Lcom/braze/models/inappmessage/IInAppMessage;)V", "configurationProvider", "Lcom/braze/configuration/BrazeConfigurationProvider;", "displayingInAppMessage", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getDisplayingInAppMessage$annotations", "inAppMessageEventMap", "", "Lcom/braze/events/InAppMessageEvent;", "getInAppMessageEventMap", "()Ljava/util/Map;", "inAppMessageEventSubscriber", "Lcom/braze/events/IEventSubscriber;", "inAppMessageStack", "Ljava/util/Stack;", "getInAppMessageStack$annotations", "getInAppMessageStack", "()Ljava/util/Stack;", "inAppMessageViewLifecycleListener", "Lcom/braze/ui/inappmessage/listeners/IInAppMessageViewLifecycleListener;", "inAppMessageViewWrapper", "Lcom/braze/ui/inappmessage/IInAppMessageViewWrapper;", "isCurrentlyDisplayingInAppMessage", "", "()Z", "originalOrientation", "", "Ljava/lang/Integer;", "sdkDataWipeEventSubscriber", "Lcom/braze/events/SdkDataWipeEvent;", "unregisteredInAppMessage", "getUnregisteredInAppMessage$annotations", "getUnregisteredInAppMessage", "setUnregisteredInAppMessage", "addInAppMessage", "", "inAppMessage", "createInAppMessageEventSubscriber", "displayInAppMessage", "isCarryOver", "ensureSubscribedToInAppMessageEvents", "context", "Landroid/content/Context;", "getIsCurrentlyDisplayingInAppMessage", "hideCurrentlyDisplayingInAppMessage", "dismissed", "registerInAppMessageManager", "activity", "Landroid/app/Activity;", "requestDisplayInAppMessage", "resetAfterInAppMessageClose", "unregisterInAppMessageManager", "verifyOrientationStatus", "Companion", "android-sdk-ui_release"})
@SuppressLint(value={"StaticFieldLeak"})
public class BrazeInAppMessageManager
extends InAppMessageManagerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IInAppMessageViewLifecycleListener inAppMessageViewLifecycleListener = new DefaultInAppMessageViewLifecycleListener();
    @JvmField
    @NotNull
    public final AtomicBoolean displayingInAppMessage = new AtomicBoolean(false);
    @NotNull
    private final Stack<IInAppMessage> inAppMessageStack = new Stack();
    @NotNull
    private final Map<IInAppMessage, InAppMessageEvent> inAppMessageEventMap = new LinkedHashMap();
    @Nullable
    private IEventSubscriber<InAppMessageEvent> inAppMessageEventSubscriber;
    @Nullable
    private IEventSubscriber<SdkDataWipeEvent> sdkDataWipeEventSubscriber;
    @Nullable
    private Integer originalOrientation;
    @Nullable
    private BrazeConfigurationProvider configurationProvider;
    @Nullable
    private IInAppMessageViewWrapper inAppMessageViewWrapper;
    @Nullable
    private IInAppMessage carryoverInAppMessage;
    @Nullable
    private IInAppMessage unregisteredInAppMessage;
    @NotNull
    private static final ReentrantLock instanceLock = new ReentrantLock();
    @Nullable
    private static volatile BrazeInAppMessageManager instance;

    @VisibleForTesting
    public static /* synthetic */ void getDisplayingInAppMessage$annotations() {
    }

    @NotNull
    public final Stack<IInAppMessage> getInAppMessageStack() {
        return this.inAppMessageStack;
    }

    @VisibleForTesting
    public static /* synthetic */ void getInAppMessageStack$annotations() {
    }

    @NotNull
    public final Map<IInAppMessage, InAppMessageEvent> getInAppMessageEventMap() {
        return this.inAppMessageEventMap;
    }

    @Nullable
    public final IInAppMessage getCarryoverInAppMessage() {
        return this.carryoverInAppMessage;
    }

    public final void setCarryoverInAppMessage(@Nullable IInAppMessage iInAppMessage) {
        this.carryoverInAppMessage = iInAppMessage;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCarryoverInAppMessage$annotations() {
    }

    @Nullable
    public final IInAppMessage getUnregisteredInAppMessage() {
        return this.unregisteredInAppMessage;
    }

    public final void setUnregisteredInAppMessage(@Nullable IInAppMessage iInAppMessage) {
        this.unregisteredInAppMessage = iInAppMessage;
    }

    @VisibleForTesting
    public static /* synthetic */ void getUnregisteredInAppMessage$annotations() {
    }

    public final boolean isCurrentlyDisplayingInAppMessage() {
        return this.displayingInAppMessage.get();
    }

    public void ensureSubscribedToInAppMessageEvents(@NotNull Context context) {
        IEventSubscriber it;
        IEventSubscriber iEventSubscriber;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.inAppMessageEventSubscriber != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)ensureSubscribedToInAppMessageEvents.1.INSTANCE, (int)3, null);
            Braze.Companion.getInstance(context).removeSingleSubscription(this.inAppMessageEventSubscriber, InAppMessageEvent.class);
        }
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)ensureSubscribedToInAppMessageEvents.2.INSTANCE, (int)3, null);
        IEventSubscriber iEventSubscriber2 = iEventSubscriber = this.createInAppMessageEventSubscriber();
        BrazeInAppMessageManager brazeInAppMessageManager = this;
        boolean bl = false;
        Braze.Companion.getInstance(context).subscribeToNewInAppMessages(it);
        brazeInAppMessageManager.inAppMessageEventSubscriber = iEventSubscriber;
        if (this.sdkDataWipeEventSubscriber != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)ensureSubscribedToInAppMessageEvents.4.INSTANCE, (int)2, null);
            Braze.Companion.getInstance(context).removeSingleSubscription(this.sdkDataWipeEventSubscriber, SdkDataWipeEvent.class);
        }
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)ensureSubscribedToInAppMessageEvents.5.INSTANCE, (int)2, null);
        it = iEventSubscriber = arg_0 -> BrazeInAppMessageManager.ensureSubscribedToInAppMessageEvents$lambda-1(this, arg_0);
        brazeInAppMessageManager = this;
        boolean bl2 = false;
        Braze.Companion.getInstance(context).addSingleSynchronousSubscription(it, SdkDataWipeEvent.class);
        brazeInAppMessageManager.sdkDataWipeEventSubscriber = iEventSubscriber;
    }

    public void registerInAppMessageManager(@Nullable Activity activity) {
        IInAppMessage it;
        if (activity == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)registerInAppMessageManager.1.INSTANCE, (int)2, null);
            return;
        }
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>(activity){
            final /* synthetic */ Activity $activity;
            {
                this.$activity = $activity;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return Intrinsics.stringPlus((String)"Registering InAppMessageManager with activity: ", (Object)this.$activity.getLocalClassName());
            }
        }), (int)2, null);
        this.mActivity = activity;
        if (this.mApplicationContext == null) {
            this.mApplicationContext = activity.getApplicationContext();
            if (this.mApplicationContext == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)registerInAppMessageManager.3.INSTANCE, (int)2, null);
                return;
            }
        }
        if (this.configurationProvider == null) {
            BrazeConfigurationProvider brazeConfigurationProvider;
            BrazeInAppMessageManager brazeInAppMessageManager = this;
            Context context = this.mApplicationContext;
            if (context == null) {
                brazeConfigurationProvider = null;
            } else {
                Context context2 = context;
                BrazeInAppMessageManager brazeInAppMessageManager2 = brazeInAppMessageManager;
                boolean bl = false;
                brazeConfigurationProvider = new BrazeConfigurationProvider((Context)it);
                brazeInAppMessageManager = brazeInAppMessageManager2;
            }
            brazeInAppMessageManager.configurationProvider = brazeConfigurationProvider;
        }
        if (this.carryoverInAppMessage != null) {
            IInAppMessage iInAppMessage = this.carryoverInAppMessage;
            if (iInAppMessage != null) {
                it = iInAppMessage;
                boolean bl = false;
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)registerInAppMessageManager.5.1.INSTANCE, (int)3, null);
                it.setAnimateIn(false);
                this.displayInAppMessage(it, true);
            }
            this.carryoverInAppMessage = null;
        } else {
            IInAppMessage iInAppMessage = this.unregisteredInAppMessage;
            if (iInAppMessage != null) {
                it = iInAppMessage;
                boolean bl = false;
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)registerInAppMessageManager.6.1.INSTANCE, (int)3, null);
                this.addInAppMessage(it);
                this.setUnregisteredInAppMessage(null);
            }
        }
        Context context = this.mApplicationContext;
        if (context != null) {
            it = context;
            boolean bl = false;
            this.ensureSubscribedToInAppMessageEvents((Context)it);
        }
    }

    public void unregisterInAppMessageManager(@Nullable Activity activity) {
        if (this.getShouldNextUnregisterBeSkipped()) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)((Function0)new Function0<String>(activity){
                final /* synthetic */ Activity $activity;
                {
                    this.$activity = $activity;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    Activity activity = this.$activity;
                    return Intrinsics.stringPlus((String)"Skipping unregistration due to setShouldNextUnregisterBeSkipped being true. Activity: ", (Object)(activity == null ? null : activity.getLocalClassName()));
                }
            }), (int)3, null);
            this.setShouldNextUnregisterBeSkipped(false);
            return;
        }
        if (activity == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)unregisterInAppMessageManager.2.INSTANCE, (int)2, null);
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>(activity){
                final /* synthetic */ Activity $activity;
                {
                    this.$activity = $activity;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return Intrinsics.stringPlus((String)"Unregistering InAppMessageManager from activity: ", (Object)this.$activity.getLocalClassName());
                }
            }), (int)2, null);
        }
        IInAppMessageViewWrapper viewWrapper = this.inAppMessageViewWrapper;
        if (viewWrapper != null) {
            IInAppMessage iInAppMessage;
            View inAppMessageView = viewWrapper.getInAppMessageView();
            if (inAppMessageView instanceof InAppMessageHtmlBaseView) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)unregisterInAppMessageManager.4.INSTANCE, (int)3, null);
                ((InAppMessageHtmlBaseView)inAppMessageView).setHtmlPageFinishedListener(null);
            }
            ViewUtils.removeViewFromParent(inAppMessageView);
            if (viewWrapper.isAnimatingClose()) {
                this.inAppMessageViewLifecycleListener.afterClosed(viewWrapper.getInAppMessage());
                iInAppMessage = null;
            } else {
                iInAppMessage = viewWrapper.getInAppMessage();
            }
            this.carryoverInAppMessage = iInAppMessage;
            this.inAppMessageViewWrapper = null;
        } else {
            this.carryoverInAppMessage = null;
        }
        this.mActivity = null;
        this.displayingInAppMessage.set(false);
    }

    public void addInAppMessage(@Nullable IInAppMessage inAppMessage) {
        if (inAppMessage != null) {
            this.inAppMessageStack.push(inAppMessage);
            this.requestDisplayInAppMessage();
        }
    }

    public boolean requestDisplayInAppMessage() {
        boolean bl;
        try {
            InAppMessageOperation inAppMessageOperation2;
            if (this.mActivity == null) {
                if (!this.inAppMessageStack.empty()) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)requestDisplayInAppMessage.1.INSTANCE, (int)2, null);
                    this.unregisteredInAppMessage = this.inAppMessageStack.pop();
                } else {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)requestDisplayInAppMessage.2.INSTANCE, (int)3, null);
                }
                return false;
            }
            if (this.displayingInAppMessage.get()) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)requestDisplayInAppMessage.3.INSTANCE, (int)3, null);
                return false;
            }
            if (this.inAppMessageStack.isEmpty()) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)requestDisplayInAppMessage.4.INSTANCE, (int)3, null);
                return false;
            }
            IInAppMessage inAppMessage = this.inAppMessageStack.pop();
            if (!inAppMessage.isControl()) {
                IInAppMessageManagerListener iInAppMessageManagerListener = this.getInAppMessageManagerListener();
                Intrinsics.checkNotNullExpressionValue((Object)inAppMessage, (String)"inAppMessage");
                inAppMessageOperation2 = iInAppMessageManagerListener.beforeInAppMessageDisplayed(inAppMessage);
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)requestDisplayInAppMessage.inAppMessageOperation.1.INSTANCE, (int)3, null);
                IInAppMessageManagerListener iInAppMessageManagerListener = this.getControlInAppMessageManagerListener();
                Intrinsics.checkNotNullExpressionValue((Object)inAppMessage, (String)"inAppMessage");
                inAppMessageOperation2 = iInAppMessageManagerListener.beforeInAppMessageDisplayed(inAppMessage);
            }
            InAppMessageOperation inAppMessageOperation3 = inAppMessageOperation2;
            switch (WhenMappings.$EnumSwitchMapping$0[inAppMessageOperation3.ordinal()]) {
                case 1: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)requestDisplayInAppMessage.5.INSTANCE, (int)3, null);
                    break;
                }
                case 2: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)requestDisplayInAppMessage.6.INSTANCE, (int)3, null);
                    this.inAppMessageStack.push(inAppMessage);
                    return false;
                }
                case 3: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)requestDisplayInAppMessage.7.INSTANCE, (int)3, null);
                    return false;
                }
            }
            BackgroundInAppMessagePreparer.prepareInAppMessageForDisplay(inAppMessage);
            bl = true;
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)this, BrazeLogger.Priority.E, (Throwable)e, (Function0)requestDisplayInAppMessage.8.INSTANCE);
            bl = false;
        }
        return bl;
    }

    public void hideCurrentlyDisplayingInAppMessage(boolean dismissed) {
        this.setShouldNextUnregisterBeSkipped(false);
        IInAppMessageViewWrapper inAppMessageWrapperView = this.inAppMessageViewWrapper;
        if (inAppMessageWrapperView != null) {
            if (dismissed) {
                this.inAppMessageViewLifecycleListener.onDismissed(inAppMessageWrapperView.getInAppMessageView(), inAppMessageWrapperView.getInAppMessage());
            }
            inAppMessageWrapperView.close();
        }
    }

    public void resetAfterInAppMessageClose() {
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)resetAfterInAppMessageClose.1.INSTANCE, (int)2, null);
        this.inAppMessageViewWrapper = null;
        Activity activity = this.mActivity;
        Integer origOrientation = this.originalOrientation;
        this.displayingInAppMessage.set(false);
        if (activity != null && origOrientation != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)((Function0)new Function0<String>(origOrientation){
                final /* synthetic */ Integer $origOrientation;
                {
                    this.$origOrientation = $origOrientation;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return Intrinsics.stringPlus((String)"Setting requested orientation to original orientation ", (Object)this.$origOrientation);
                }
            }), (int)3, null);
            ViewUtils.setActivityRequestedOrientation(activity, origOrientation);
            this.originalOrientation = null;
        }
    }

    public boolean getIsCurrentlyDisplayingInAppMessage() {
        return this.displayingInAppMessage.get();
    }

    public void displayInAppMessage(@NotNull IInAppMessage inAppMessage, boolean isCarryOver) {
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>(inAppMessage){
            final /* synthetic */ IInAppMessage $inAppMessage;
            {
                this.$inAppMessage = $inAppMessage;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return Intrinsics.stringPlus((String)"Attempting to display in-app message with payload: ", (Object)JsonUtils.getPrettyPrintedString((JSONObject)((JSONObject)this.$inAppMessage.forJsonPut())));
            }
        }), (int)2, null);
        if (!this.displayingInAppMessage.compareAndSet(false, true)) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)displayInAppMessage.2.INSTANCE, (int)3, null);
            this.inAppMessageStack.push(inAppMessage);
            return;
        }
        try {
            IInAppMessageViewWrapper iInAppMessageViewWrapper;
            Activity activity = this.mActivity;
            if (activity == null) {
                this.carryoverInAppMessage = inAppMessage;
                throw new Exception("No Activity is currently registered to receive in-app messages. Registering in-app message as carry-over in-app message. It will automatically be displayed when the next Activity registers to receive in-app messages.");
            }
            if (!isCarryOver) {
                long inAppMessageExpirationTimestamp = inAppMessage.getExpirationTimestamp();
                if (inAppMessageExpirationTimestamp > 0L) {
                    long currentTimeMillis = System.currentTimeMillis();
                    if (currentTimeMillis > inAppMessageExpirationTimestamp) {
                        throw new Exception("In-app message is expired. Doing nothing. Expiration: " + inAppMessageExpirationTimestamp + ". Current time: " + currentTimeMillis);
                    }
                } else {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)displayInAppMessage.3.INSTANCE, (int)3, null);
                }
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)displayInAppMessage.4.INSTANCE, (int)3, null);
            }
            if (!this.verifyOrientationStatus(inAppMessage)) {
                throw new Exception("Current orientation did not match specified orientation for in-app message. Doing nothing.");
            }
            if (inAppMessage.isControl()) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)displayInAppMessage.5.INSTANCE, (int)3, null);
                inAppMessage.logImpression();
                this.resetAfterInAppMessageClose();
                return;
            }
            if (BrazeActionUtils.containsInvalidBrazeAction(inAppMessage)) {
                InAppMessageEvent inAppMessageEvent = this.inAppMessageEventMap.get(inAppMessage);
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)displayInAppMessage.6.INSTANCE, (int)2, null);
                if (inAppMessageEvent != null) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)displayInAppMessage.7.INSTANCE, (int)2, null);
                    Context context = activity.getApplicationContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"activity.applicationContext");
                    BrazeInternal.retryInAppMessage((Context)context, (InAppMessageEvent)inAppMessageEvent);
                }
                this.resetAfterInAppMessageClose();
                return;
            }
            if (BrazeInAppMessageManager.Companion.containsPushPermissionPrompt(inAppMessage) && !PermissionUtils.wouldPushPermissionPromptDisplay((Activity)activity)) {
                InAppMessageEvent inAppMessageEvent = this.inAppMessageEventMap.get(inAppMessage);
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)displayInAppMessage.8.INSTANCE, (int)2, null);
                if (inAppMessageEvent != null) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)displayInAppMessage.9.INSTANCE, (int)2, null);
                    Context context = activity.getApplicationContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"activity.applicationContext");
                    BrazeInternal.retryInAppMessage((Context)context, (InAppMessageEvent)inAppMessageEvent);
                }
                this.resetAfterInAppMessageClose();
                return;
            }
            IInAppMessageViewFactory inAppMessageViewFactory = this.getInAppMessageViewFactory(inAppMessage);
            if (inAppMessageViewFactory == null) {
                inAppMessage.logDisplayFailure(InAppMessageFailureType.DISPLAY_VIEW_GENERATION);
                throw new Exception("ViewFactory from getInAppMessageViewFactory was null.");
            }
            View inAppMessageView = inAppMessageViewFactory.createInAppMessageView(activity, inAppMessage);
            if (inAppMessageView == null) {
                inAppMessage.logDisplayFailure(InAppMessageFailureType.DISPLAY_VIEW_GENERATION);
                throw new Exception("The in-app message view returned from the IInAppMessageViewFactory was null. The in-app message will not be displayed and will not be put back on the stack.");
            }
            if (inAppMessageView.getParent() != null) {
                inAppMessage.logDisplayFailure(InAppMessageFailureType.DISPLAY_VIEW_GENERATION);
                throw new Exception("The in-app message view returned from the IInAppMessageViewFactory already has a parent. This is a sign that the view is being reused. The IInAppMessageViewFactory method createInAppMessageViewmust return a new view without a parent. The in-app message will not be displayed and will not be put back on the stack.");
            }
            BrazeConfigurationProvider brazeConfigurationProvider = this.configurationProvider;
            if (brazeConfigurationProvider == null) {
                throw new Exception("configurationProvider is null. The in-app message will not be displayed and will not beput back on the stack.");
            }
            BrazeConfigurationProvider configProvider = brazeConfigurationProvider;
            Animation openingAnimation = this.getInAppMessageAnimationFactory().getOpeningAnimation(inAppMessage);
            Animation closingAnimation = this.getInAppMessageAnimationFactory().getClosingAnimation(inAppMessage);
            IInAppMessageViewWrapperFactory viewWrapperFactory = this.getInAppMessageViewWrapperFactory();
            View view = inAppMessageView;
            if (view instanceof IInAppMessageImmersiveView) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)displayInAppMessage.10.INSTANCE, (int)3, null);
                IInAppMessageImmersiveView inAppMessageViewImmersive = (IInAppMessageImmersiveView)inAppMessageView;
                InAppMessageImmersiveBase inAppMessageImmersiveBase = (InAppMessageImmersiveBase)inAppMessage;
                int numButtons = inAppMessageImmersiveBase.getMessageButtons().size();
                iInAppMessageViewWrapper = viewWrapperFactory.createInAppMessageViewWrapper(inAppMessageView, inAppMessage, this.inAppMessageViewLifecycleListener, configProvider, openingAnimation, closingAnimation, inAppMessageViewImmersive.getMessageClickableView(), inAppMessageViewImmersive.getMessageButtonViews(numButtons), inAppMessageViewImmersive.getMessageCloseButtonView());
            } else if (view instanceof IInAppMessageView) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)displayInAppMessage.11.INSTANCE, (int)3, null);
                IInAppMessageView inAppMessageViewBase = (IInAppMessageView)inAppMessageView;
                iInAppMessageViewWrapper = viewWrapperFactory.createInAppMessageViewWrapper(inAppMessageView, inAppMessage, this.inAppMessageViewLifecycleListener, configProvider, openingAnimation, closingAnimation, inAppMessageViewBase.getMessageClickableView());
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)displayInAppMessage.12.INSTANCE, (int)3, null);
                iInAppMessageViewWrapper = viewWrapperFactory.createInAppMessageViewWrapper(inAppMessageView, inAppMessage, this.inAppMessageViewLifecycleListener, configProvider, openingAnimation, closingAnimation, inAppMessageView);
            }
            IInAppMessageViewWrapper viewWrapper = this.inAppMessageViewWrapper = iInAppMessageViewWrapper;
            if (inAppMessageView instanceof InAppMessageHtmlBaseView) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)displayInAppMessage.13.INSTANCE, (int)3, null);
                ((InAppMessageHtmlBaseView)inAppMessageView).setHtmlPageFinishedListener(() -> BrazeInAppMessageManager.displayInAppMessage$lambda-7(viewWrapper, this, activity));
            } else {
                IInAppMessageViewWrapper iInAppMessageViewWrapper2 = viewWrapper;
                if (iInAppMessageViewWrapper2 != null) {
                    iInAppMessageViewWrapper2.open(activity);
                }
            }
        }
        catch (Throwable e) {
            BrazeLogger.INSTANCE.brazelog((Object)this, BrazeLogger.Priority.E, e, (Function0)new Function0<String>(inAppMessage){
                final /* synthetic */ IInAppMessage $inAppMessage;
                {
                    this.$inAppMessage = $inAppMessage;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return Intrinsics.stringPlus((String)"Could not display in-app message with payload: ", (Object)JsonUtils.getPrettyPrintedString((JSONObject)((JSONObject)this.$inAppMessage.forJsonPut())));
                }
            });
            this.resetAfterInAppMessageClose();
        }
    }

    private final IEventSubscriber<InAppMessageEvent> createInAppMessageEventSubscriber() {
        return arg_0 -> BrazeInAppMessageManager.createInAppMessageEventSubscriber$lambda-8(this, arg_0);
    }

    @SuppressLint(value={"InlinedApi"})
    @VisibleForTesting
    public boolean verifyOrientationStatus(@NotNull IInAppMessage inAppMessage) {
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        Activity activity = this.mActivity;
        Orientation preferredOrientation = inAppMessage.getOrientation();
        if (activity == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)verifyOrientationStatus.1.INSTANCE, (int)2, null);
        } else if (ViewUtils.isRunningOnTablet(activity)) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)verifyOrientationStatus.2.INSTANCE, (int)3, null);
        } else if (preferredOrientation == Orientation.ANY) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)verifyOrientationStatus.3.INSTANCE, (int)3, null);
        } else {
            boolean bl;
            int currentScreenOrientation = activity.getResources().getConfiguration().orientation;
            if (ViewUtils.isCurrentOrientationValid(currentScreenOrientation, preferredOrientation)) {
                if (this.originalOrientation == null) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)verifyOrientationStatus.4.INSTANCE, (int)3, null);
                    this.originalOrientation = activity.getRequestedOrientation();
                    ViewUtils.setActivityRequestedOrientation(activity, 14);
                }
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }
        return true;
    }

    private static final void ensureSubscribedToInAppMessageEvents$lambda-1(BrazeInAppMessageManager this$0, SdkDataWipeEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.inAppMessageStack.clear();
        this$0.carryoverInAppMessage = null;
        this$0.unregisteredInAppMessage = null;
    }

    private static final void displayInAppMessage$lambda-7(IInAppMessageViewWrapper $viewWrapper, BrazeInAppMessageManager this$0, Activity $activity) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            if ($viewWrapper != null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this$0, null, null, (Function0)displayInAppMessage.14.1.INSTANCE, (int)3, null);
                $viewWrapper.open($activity);
            }
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)this$0, BrazeLogger.Priority.E, (Throwable)e, (Function0)displayInAppMessage.14.2.INSTANCE);
        }
    }

    private static final void createInAppMessageEventSubscriber$lambda-8(BrazeInAppMessageManager this$0, InAppMessageEvent event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        IInAppMessage inAppMessage = event.getInAppMessage();
        this$0.inAppMessageEventMap.put(inAppMessage, event);
        this$0.addInAppMessage(inAppMessage);
    }

    @JvmStatic
    @NotNull
    public static final BrazeInAppMessageManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/braze/ui/inappmessage/BrazeInAppMessageManager$Companion;", "", "()V", "instance", "Lcom/braze/ui/inappmessage/BrazeInAppMessageManager;", "instanceLock", "Ljava/util/concurrent/locks/ReentrantLock;", "getInstance", "containsPushPermissionPrompt", "", "Lcom/braze/models/inappmessage/IInAppMessage;", "android-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final BrazeInAppMessageManager getInstance() {
            if (instance != null) {
                BrazeInAppMessageManager brazeInAppMessageManager = instance;
                if (brazeInAppMessageManager == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.braze.ui.inappmessage.BrazeInAppMessageManager");
                }
                return brazeInAppMessageManager;
            }
            Lock lock = instanceLock;
            lock.lock();
            try {
                boolean bl = false;
                if (instance == null) {
                    instance = new BrazeInAppMessageManager();
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
            BrazeInAppMessageManager brazeInAppMessageManager = instance;
            if (brazeInAppMessageManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.braze.ui.inappmessage.BrazeInAppMessageManager");
            }
            return brazeInAppMessageManager;
        }

        private final boolean containsPushPermissionPrompt(IInAppMessage $this$containsPushPermissionPrompt) {
            if ($this$containsPushPermissionPrompt instanceof InAppMessageHtml) {
                return ((InAppMessageHtml)$this$containsPushPermissionPrompt).isPushPrimer();
            }
            return BrazeActionUtils.containsAnyPushPermissionBrazeActions($this$containsPushPermissionPrompt);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InAppMessageOperation.values().length];
            nArray[InAppMessageOperation.DISPLAY_NOW.ordinal()] = 1;
            nArray[InAppMessageOperation.DISPLAY_LATER.ordinal()] = 2;
            nArray[InAppMessageOperation.DISCARD.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

