/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.inappmessage.factories;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.braze.Braze;
import com.braze.enums.BrazeViewBounds;
import com.braze.enums.inappmessage.ImageStyle;
import com.braze.enums.inappmessage.Orientation;
import com.braze.images.IBrazeImageLoader;
import com.braze.models.inappmessage.IInAppMessage;
import com.braze.models.inappmessage.IInAppMessageImmersive;
import com.braze.models.inappmessage.IInAppMessageWithImage;
import com.braze.models.inappmessage.InAppMessageFull;
import com.braze.ui.R;
import com.braze.ui.inappmessage.IInAppMessageViewFactory;
import com.braze.ui.inappmessage.views.InAppMessageBaseView;
import com.braze.ui.inappmessage.views.InAppMessageFullView;
import com.braze.ui.inappmessage.views.InAppMessageImageView;
import com.braze.ui.support.ViewUtils;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/braze/ui/inappmessage/factories/DefaultInAppMessageFullViewFactory;", "Lcom/braze/ui/inappmessage/IInAppMessageViewFactory;", "()V", "createInAppMessageView", "Lcom/braze/ui/inappmessage/views/InAppMessageFullView;", "activity", "Landroid/app/Activity;", "inAppMessage", "Lcom/braze/models/inappmessage/IInAppMessage;", "getAppropriateFullView", "isGraphic", "", "resetLayoutParamsIfAppropriate", "view", "Companion", "android-sdk-ui_release"})
public class DefaultInAppMessageFullViewFactory
implements IInAppMessageViewFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int BUTTONS_PRESENT_SCROLLVIEW_EXCESS_HEIGHT_VALUE_IN_DP = 64;

    @NotNull
    public InAppMessageFullView createInAppMessageView(@NotNull Activity activity, @NotNull IInAppMessage inAppMessage) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        Context applicationContext = activity.getApplicationContext();
        InAppMessageFull inAppMessageFull = (InAppMessageFull)inAppMessage;
        boolean isGraphic = inAppMessageFull.getImageStyle() == ImageStyle.GRAPHIC;
        InAppMessageFullView view = this.getAppropriateFullView(activity, isGraphic);
        view.createAppropriateViews(activity, (IInAppMessageImmersive)inAppMessageFull, isGraphic);
        String imageUrl = InAppMessageBaseView.Companion.getAppropriateImageUrl((IInAppMessageWithImage)inAppMessageFull);
        CharSequence charSequence = imageUrl;
        if (!(charSequence == null || charSequence.length() == 0)) {
            Intrinsics.checkNotNullExpressionValue((Object)applicationContext, (String)"applicationContext");
            IBrazeImageLoader brazeImageLoader = Braze.Companion.getInstance(applicationContext).getImageLoader();
            ImageView imageView = view.getMessageImageView();
            if (imageView != null) {
                ImageView it = imageView;
                boolean bl = false;
                brazeImageLoader.renderUrlIntoInAppMessageView(applicationContext, inAppMessage, imageUrl, it, BrazeViewBounds.NO_BOUNDS);
            }
        }
        View view2 = view.getFrameView();
        if (view2 != null) {
            view2.setOnClickListener(null);
        }
        view.setMessageBackgroundColor(inAppMessageFull.getBackgroundColor());
        Integer n = inAppMessageFull.getFrameColor();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            view.setFrameColor(it);
        }
        view.setMessageButtons(inAppMessageFull.getMessageButtons());
        view.setMessageCloseButtonColor(inAppMessageFull.getCloseButtonColor());
        if (!isGraphic) {
            String string2 = inAppMessageFull.getMessage();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                view.setMessage(it);
            }
            view.setMessageTextColor(inAppMessageFull.getMessageTextColor());
            String string3 = inAppMessageFull.getHeader();
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                view.setMessageHeaderText(it);
            }
            view.setMessageHeaderTextColor(inAppMessageFull.getHeaderTextColor());
            view.setMessageHeaderTextAlignment(inAppMessageFull.getHeaderTextAlign());
            view.setMessageTextAlign(inAppMessageFull.getMessageTextAlign());
            view.resetMessageMargins(inAppMessageFull.getImageDownloadSuccessful());
            ImageView imageView = view.getMessageImageView();
            if (imageView == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.braze.ui.inappmessage.views.InAppMessageImageView");
            }
            ((InAppMessageImageView)imageView).setToHalfParentHeight(true);
        }
        view.setLargerCloseButtonClickArea(view.getMessageCloseButtonView());
        this.resetLayoutParamsIfAppropriate(activity, (IInAppMessage)inAppMessageFull, view);
        view.setupDirectionalNavigation(inAppMessageFull.getMessageButtons().size());
        View scrollView = view.findViewById(R.id.com_braze_inappmessage_full_scrollview);
        if (scrollView != null) {
            View allContentParent = view.findViewById(R.id.com_braze_inappmessage_full_all_content_parent);
            scrollView.post(() -> DefaultInAppMessageFullViewFactory.createInAppMessageView$lambda-4(allContentParent, view, inAppMessageFull, applicationContext, scrollView));
        }
        return view;
    }

    private final boolean resetLayoutParamsIfAppropriate(Activity activity, IInAppMessage inAppMessage, InAppMessageFullView view) {
        if (!ViewUtils.isRunningOnTablet(activity)) {
            return false;
        }
        if (inAppMessage.getOrientation() == Orientation.ANY) {
            return false;
        }
        int longEdge = view.getLongEdge();
        int shortEdge = view.getShortEdge();
        if (longEdge > 0 && shortEdge > 0) {
            RelativeLayout.LayoutParams layoutParams = inAppMessage.getOrientation() == Orientation.LANDSCAPE ? new RelativeLayout.LayoutParams(longEdge, shortEdge) : new RelativeLayout.LayoutParams(shortEdge, longEdge);
            layoutParams.addRule(13, -1);
            View view2 = view.getMessageBackgroundObject();
            if (view2 != null) {
                view2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
            return true;
        }
        return false;
    }

    @SuppressLint(value={"InflateParams"})
    @NotNull
    public final InAppMessageFullView getAppropriateFullView(@NotNull Activity activity, boolean isGraphic) {
        InAppMessageFullView inAppMessageFullView;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (isGraphic) {
            View view = activity.getLayoutInflater().inflate(R.layout.com_braze_inappmessage_full_graphic, null);
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.braze.ui.inappmessage.views.InAppMessageFullView");
            }
            inAppMessageFullView = (InAppMessageFullView)view;
        } else {
            View view = activity.getLayoutInflater().inflate(R.layout.com_braze_inappmessage_full, null);
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.braze.ui.inappmessage.views.InAppMessageFullView");
            }
            inAppMessageFullView = (InAppMessageFullView)view;
        }
        return inAppMessageFullView;
    }

    private static final void createInAppMessageView$lambda-4(View $allContentParent, InAppMessageFullView $view, InAppMessageFull $inAppMessageFull, Context $applicationContext, View $scrollView) {
        Intrinsics.checkNotNullParameter((Object)$view, (String)"$view");
        Intrinsics.checkNotNullParameter((Object)$inAppMessageFull, (String)"$inAppMessageFull");
        int parentHeight = $allContentParent.getHeight();
        int halfHeight = parentHeight / 2;
        View contentView = $view.findViewById(R.id.com_braze_inappmessage_full_text_and_button_content_parent);
        ViewGroup.LayoutParams layoutParams = contentView.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        }
        ViewGroup.MarginLayoutParams layoutParams2 = (ViewGroup.MarginLayoutParams)layoutParams;
        int nonScrollViewHeight = layoutParams2.bottomMargin + layoutParams2.topMargin;
        if (!((Collection)$inAppMessageFull.getMessageButtons()).isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)$applicationContext, (String)"applicationContext");
            nonScrollViewHeight += (int)ViewUtils.convertDpToPixels($applicationContext, 64.0);
        }
        int scrollViewAppropriateHeight = Math.min($scrollView.getHeight(), halfHeight - nonScrollViewHeight);
        Intrinsics.checkNotNullExpressionValue((Object)$scrollView, (String)"scrollView");
        ViewUtils.setHeightOnViewLayoutParams($scrollView, scrollViewAppropriateHeight);
        $scrollView.requestLayout();
        ImageView imageView = $view.getMessageImageView();
        if (imageView != null) {
            imageView.requestLayout();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/braze/ui/inappmessage/factories/DefaultInAppMessageFullViewFactory$Companion;", "", "()V", "BUTTONS_PRESENT_SCROLLVIEW_EXCESS_HEIGHT_VALUE_IN_DP", "", "android-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

