/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.inappmessage.factories;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import com.braze.Braze;
import com.braze.enums.BrazeViewBounds;
import com.braze.enums.inappmessage.ImageStyle;
import com.braze.images.IBrazeImageLoader;
import com.braze.models.inappmessage.IInAppMessage;
import com.braze.models.inappmessage.IInAppMessageWithImage;
import com.braze.models.inappmessage.InAppMessageModal;
import com.braze.support.BrazeLogger;
import com.braze.ui.R;
import com.braze.ui.inappmessage.BrazeInAppMessageManager;
import com.braze.ui.inappmessage.IInAppMessageViewFactory;
import com.braze.ui.inappmessage.factories.DefaultInAppMessageModalViewFactory;
import com.braze.ui.inappmessage.views.InAppMessageBaseView;
import com.braze.ui.inappmessage.views.InAppMessageImageView;
import com.braze.ui.inappmessage.views.InAppMessageModalView;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0003\u00a8\u0006\r"}, d2={"Lcom/braze/ui/inappmessage/factories/DefaultInAppMessageModalViewFactory;", "Lcom/braze/ui/inappmessage/IInAppMessageViewFactory;", "()V", "createInAppMessageView", "Lcom/braze/ui/inappmessage/views/InAppMessageModalView;", "activity", "Landroid/app/Activity;", "inAppMessage", "Lcom/braze/models/inappmessage/IInAppMessage;", "getAppropriateModalView", "isGraphic", "", "Companion", "android-sdk-ui_release"})
public class DefaultInAppMessageModalViewFactory
implements IInAppMessageViewFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final float NON_GRAPHIC_ASPECT_RATIO = 2.9f;

    @NotNull
    public InAppMessageModalView createInAppMessageView(@NotNull Activity activity, @NotNull IInAppMessage inAppMessage) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        Context applicationContext = activity.getApplicationContext();
        InAppMessageModal inAppMessageModal = (InAppMessageModal)inAppMessage;
        boolean isGraphic = inAppMessageModal.getImageStyle() == ImageStyle.GRAPHIC;
        InAppMessageModalView view = this.getAppropriateModalView(activity, isGraphic);
        Intrinsics.checkNotNullExpressionValue((Object)applicationContext, (String)"applicationContext");
        view.applyInAppMessageParameters(applicationContext, inAppMessageModal);
        String imageUrl = InAppMessageBaseView.Companion.getAppropriateImageUrl((IInAppMessageWithImage)inAppMessageModal);
        CharSequence charSequence = imageUrl;
        if (!(charSequence == null || charSequence.length() == 0)) {
            IBrazeImageLoader brazeImageLoader = Braze.Companion.getInstance(applicationContext).getImageLoader();
            ImageView imageView = view.getMessageImageView();
            if (imageView != null) {
                ImageView it = imageView;
                boolean bl = false;
                brazeImageLoader.renderUrlIntoInAppMessageView(applicationContext, inAppMessage, imageUrl, it, BrazeViewBounds.IN_APP_MESSAGE_MODAL);
            }
        }
        View view2 = view.getFrameView();
        if (view2 != null) {
            view2.setOnClickListener(arg_0 -> DefaultInAppMessageModalViewFactory.createInAppMessageView$lambda-1(this, arg_0));
        }
        view.setMessageBackgroundColor(inAppMessage.getBackgroundColor());
        Integer n = inAppMessageModal.getFrameColor();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            view.setFrameColor(it);
        }
        view.setMessageButtons(inAppMessageModal.getMessageButtons());
        view.setMessageCloseButtonColor(inAppMessageModal.getCloseButtonColor());
        if (!isGraphic) {
            String string2 = inAppMessage.getMessage();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                view.setMessage(it);
            }
            view.setMessageTextColor(inAppMessage.getMessageTextColor());
            String string3 = inAppMessageModal.getHeader();
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                view.setMessageHeaderText(it);
            }
            view.setMessageHeaderTextColor(inAppMessageModal.getHeaderTextColor());
            String string4 = inAppMessage.getIcon();
            if (string4 != null) {
                String it = string4;
                boolean bl = false;
                view.setMessageIcon(it, inAppMessage.getIconColor(), inAppMessage.getIconBackgroundColor());
            }
            view.setMessageHeaderTextAlignment(inAppMessageModal.getHeaderTextAlign());
            view.setMessageTextAlign(inAppMessageModal.getMessageTextAlign());
            view.resetMessageMargins(inAppMessageModal.getImageDownloadSuccessful());
            ImageView imageView = view.getMessageImageView();
            if (imageView == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.braze.ui.inappmessage.views.InAppMessageImageView");
            }
            ((InAppMessageImageView)imageView).setAspectRatio(2.9f);
        }
        view.setLargerCloseButtonClickArea(view.getMessageCloseButtonView());
        view.setupDirectionalNavigation(inAppMessageModal.getMessageButtons().size());
        return view;
    }

    @SuppressLint(value={"InflateParams"})
    private final InAppMessageModalView getAppropriateModalView(Activity activity, boolean isGraphic) {
        InAppMessageModalView inAppMessageModalView;
        if (isGraphic) {
            View view = activity.getLayoutInflater().inflate(R.layout.com_braze_inappmessage_modal_graphic, null);
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.braze.ui.inappmessage.views.InAppMessageModalView");
            }
            inAppMessageModalView = (InAppMessageModalView)view;
        } else {
            View view = activity.getLayoutInflater().inflate(R.layout.com_braze_inappmessage_modal, null);
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.braze.ui.inappmessage.views.InAppMessageModalView");
            }
            inAppMessageModalView = (InAppMessageModalView)view;
        }
        return inAppMessageModalView;
    }

    private static final void createInAppMessageView$lambda-1(DefaultInAppMessageModalViewFactory this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (BrazeInAppMessageManager.Companion.getInstance().getDoesClickOutsideModalViewDismissInAppMessageView()) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this$0, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)createInAppMessageView.2.1.INSTANCE, (int)2, null);
            BrazeInAppMessageManager.Companion.getInstance().hideCurrentlyDisplayingInAppMessage(true);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/braze/ui/inappmessage/factories/DefaultInAppMessageModalViewFactory$Companion;", "", "()V", "NON_GRAPHIC_ASPECT_RATIO", "", "android-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

