/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.inappmessage.utils;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.braze.models.inappmessage.MessageButton;
import com.braze.ui.R;
import com.braze.ui.inappmessage.utils.InAppMessageViewUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\nH\u0007J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J$\u0010\u0015\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0017H\u0007\u00a8\u0006\u001a"}, d2={"Lcom/braze/ui/inappmessage/utils/InAppMessageButtonViewUtils;", "", "()V", "getButtonDrawable", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "messageButton", "Lcom/braze/models/inappmessage/MessageButton;", "newStrokeWidth", "", "strokeFocusedWidth", "isFocused", "", "getDrawable", "drawableId", "setButton", "", "button", "Landroid/widget/Button;", "strokeWidth", "setButtons", "buttonViews", "", "Landroid/view/View;", "messageButtons", "android-sdk-ui_release"})
public final class InAppMessageButtonViewUtils {
    @NotNull
    public static final InAppMessageButtonViewUtils INSTANCE = new InAppMessageButtonViewUtils();

    private InAppMessageButtonViewUtils() {
    }

    @JvmStatic
    public static final void setButtons(@NotNull List<? extends View> buttonViews, @NotNull List<? extends MessageButton> messageButtons) {
        Intrinsics.checkNotNullParameter(buttonViews, (String)"buttonViews");
        Intrinsics.checkNotNullParameter(messageButtons, (String)"messageButtons");
        int n = 0;
        int n2 = buttonViews.size();
        while (n < n2) {
            int i = n++;
            View buttonView = buttonViews.get(i);
            MessageButton messageButton = messageButtons.get(i);
            int strokeWidth = buttonView.getContext().getResources().getDimensionPixelSize(R.dimen.com_braze_inappmessage_button_border_stroke);
            int strokeFocusedWidth = buttonView.getContext().getResources().getDimensionPixelSize(R.dimen.com_braze_inappmessage_button_border_stroke_focused);
            if (messageButtons.size() <= i) {
                buttonView.setVisibility(8);
                continue;
            }
            if (!(buttonView instanceof Button)) continue;
            InAppMessageButtonViewUtils.setButton((Button)buttonView, messageButton, strokeWidth, strokeFocusedWidth);
        }
    }

    @JvmStatic
    public static final void setButton(@NotNull Button button, @NotNull MessageButton messageButton, int strokeWidth, int strokeFocusedWidth) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        Intrinsics.checkNotNullParameter((Object)messageButton, (String)"messageButton");
        button.setText((CharSequence)messageButton.getText());
        button.setContentDescription((CharSequence)messageButton.getText());
        InAppMessageViewUtils.setTextViewColor((TextView)button, messageButton.getTextColor());
        StateListDrawable stateListDrawableBackground = new StateListDrawable();
        if (Build.VERSION.SDK_INT >= 21) {
            button.setStateListAnimator(null);
        }
        Context context = button.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"button.context");
        Drawable defaultButtonDrawable = InAppMessageButtonViewUtils.getButtonDrawable(context, messageButton, strokeWidth, strokeFocusedWidth, false);
        Object object = button.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"button.context");
        Drawable focusedButtonDrawable = InAppMessageButtonViewUtils.getButtonDrawable(object, messageButton, strokeWidth, strokeFocusedWidth, true);
        object = new int[1];
        object[0] = (Context)16842908;
        stateListDrawableBackground.addState((int[])object, focusedButtonDrawable);
        object = new int[1];
        object[0] = (Context)16842910;
        stateListDrawableBackground.addState((int[])object, defaultButtonDrawable);
        button.setBackground((Drawable)stateListDrawableBackground);
    }

    @JvmStatic
    @NotNull
    public static final Drawable getDrawable(@NotNull Context context, int drawableId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Drawable drawable2 = context.getResources().getDrawable(drawableId);
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"context.resources.getDrawable(drawableId)");
        return drawable2;
    }

    @JvmStatic
    @NotNull
    public static final Drawable getButtonDrawable(@NotNull Context context, @NotNull MessageButton messageButton, int newStrokeWidth, int strokeFocusedWidth, boolean isFocused) {
        GradientDrawable gradientDrawable;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)messageButton, (String)"messageButton");
        Drawable buttonDrawable = InAppMessageButtonViewUtils.getDrawable(context, R.drawable.com_braze_inappmessage_button_background);
        buttonDrawable.mutate();
        if (Build.VERSION.SDK_INT >= 21) {
            RippleDrawable rippleDrawable = (RippleDrawable)buttonDrawable;
            Drawable drawable2 = rippleDrawable.findDrawableByLayerId(R.id.com_braze_inappmessage_button_background_ripple_internal_gradient);
            if (drawable2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
            }
            gradientDrawable = (GradientDrawable)drawable2;
        } else {
            gradientDrawable = (GradientDrawable)buttonDrawable;
        }
        GradientDrawable backgroundFillGradientDrawable = gradientDrawable;
        int strokeWidth = newStrokeWidth;
        if (isFocused) {
            strokeWidth = strokeFocusedWidth;
        }
        backgroundFillGradientDrawable.setStroke(strokeWidth, messageButton.getBorderColor());
        backgroundFillGradientDrawable.setColor(messageButton.getBackgroundColor());
        return buttonDrawable;
    }
}

