/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.support;

import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a&\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"accelerateInterpolator", "Landroid/view/animation/Interpolator;", "decelerateInterpolator", "createHorizontalAnimation", "Landroid/view/animation/Animation;", "fromX", "", "toX", "duration", "", "accelerate", "", "createVerticalAnimation", "fromY", "toY", "setAnimationParams", "animation", "android-sdk-ui_release"})
@JvmName(name="AnimationUtils")
public final class AnimationUtils {
    @NotNull
    private static final Interpolator accelerateInterpolator = (Interpolator)new AccelerateInterpolator();
    @NotNull
    private static final Interpolator decelerateInterpolator = (Interpolator)new DecelerateInterpolator();

    @NotNull
    public static final Animation createVerticalAnimation(float fromY, float toY, long duration, boolean accelerate) {
        TranslateAnimation animation = new TranslateAnimation(2, 0.0f, 2, 0.0f, 1, fromY, 1, toY);
        return AnimationUtils.setAnimationParams((Animation)animation, duration, accelerate);
    }

    @NotNull
    public static final Animation createHorizontalAnimation(float fromX, float toX, long duration, boolean accelerate) {
        TranslateAnimation animation = new TranslateAnimation(1, fromX, 1, toX, 2, 0.0f, 2, 0.0f);
        return AnimationUtils.setAnimationParams((Animation)animation, duration, accelerate);
    }

    @NotNull
    public static final Animation setAnimationParams(@NotNull Animation animation, long duration, boolean accelerate) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        animation.setDuration(duration);
        if (accelerate) {
            animation.setInterpolator(accelerateInterpolator);
        } else {
            animation.setInterpolator(decelerateInterpolator);
        }
        return animation;
    }
}

