/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.widget;

import android.content.Context;
import android.widget.ImageView;
import com.braze.models.cards.BannerImageCard;
import com.braze.models.cards.Card;
import com.braze.support.BrazeLogger;
import com.braze.ui.R;
import com.braze.ui.actions.IAction;
import com.braze.ui.feed.view.BaseFeedCardView;

public class BannerImageCardView
extends BaseFeedCardView<BannerImageCard> {
    private static final String TAG = BrazeLogger.getBrazeLogTag(BannerImageCardView.class);
    private final ImageView mImage = (ImageView)this.getProperViewFromInflatedStub(R.id.com_braze_banner_image_card_imageview_stub);
    private IAction mCardAction;
    private float mAspectRatio = 6.0f;

    public BannerImageCardView(Context context) {
        this(context, null);
    }

    public BannerImageCardView(Context context, BannerImageCard card) {
        super(context);
        this.mImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.mImage.setAdjustViewBounds(true);
        if (card != null) {
            this.setCard(card);
        }
        this.setBackground(this.getResources().getDrawable(R.drawable.com_braze_card_background));
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.com_braze_banner_image_card;
    }

    @Override
    public void onSetCard(BannerImageCard card) {
        if (card.getAspectRatio() != 0.0f) {
            this.mAspectRatio = card.getAspectRatio();
        }
        this.setImageViewToUrl(this.mImage, card.getImageUrl(), this.mAspectRatio, (Card)card);
        this.mCardAction = BannerImageCardView.getUriActionForCard((Card)card);
        this.setOnClickListener(view -> this.handleCardClick(this.applicationContext, (Card)card, this.mCardAction));
    }
}

