/*
 * Decompiled with CFR 0.152.
 */
package com.braze.push;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.UiModeManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.PowerManager;
import android.os.SystemClock;
import androidx.core.app.NotificationCompat;
import com.braze.Braze;
import com.braze.BrazeInternal;
import com.braze.Constants;
import com.braze.IBrazeNotificationFactory;
import com.braze.configuration.BrazeConfigurationProvider;
import com.braze.enums.BrazePushEventType;
import com.braze.enums.BrazeViewBounds;
import com.braze.enums.Channel;
import com.braze.models.push.BrazeNotificationPayload;
import com.braze.push.BrazeAmazonDeviceMessagingReceiver;
import com.braze.push.BrazeNotificationFactory;
import com.braze.push.BrazeNotificationUtils;
import com.braze.push.BrazePushReceiver;
import com.braze.push.NotificationTrampolineActivity;
import com.braze.push.support.HtmlUtils;
import com.braze.support.BrazeLogger;
import com.braze.support.IntentUtils;
import com.braze.support.JsonUtils;
import com.braze.support.PermissionUtils;
import com.braze.ui.BrazeDeeplinkHandler;
import com.braze.ui.actions.UriAction;
import com.braze.ui.support.UriUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001TB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0007J\u0018\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$H\u0007J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010&\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$H\u0007J\u0018\u0010'\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$H\u0007J\u0018\u0010(\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$H\u0007J\u0010\u0010)\u001a\u00020*2\u0006\u0010#\u001a\u00020$H\u0007J\u0010\u0010+\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0010\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020\u0013H\u0007J\u001c\u0010.\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010/\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u00100\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u00101\u001a\u00020*2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u00102\u001a\u00020*2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u00103\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$H\u0007J\u0018\u00104\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$H\u0007J\"\u00105\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u00106\u001a\u00020$2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J.\u00105\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u00107\u001a\u0002082\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J \u00109\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010:\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010=\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010>\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\"\u0010?\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010;\u001a\u00020<2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0007J\"\u0010@\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010;\u001a\u00020<2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0007J\u0018\u0010A\u001a\u00020*2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010B\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J.\u0010C\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010D\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010E\u001a\u00020\u0013H\u0007J\u0018\u0010F\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010G\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010H\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010I\u001a\u00020\u00132\u0006\u0010J\u001a\u00020K2\u0006\u0010;\u001a\u00020<H\u0007J\u0018\u0010L\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010M\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010N\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010O\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010P\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\"\u0010Q\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010R\u001a\u00020K2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0007J\u0010\u0010Q\u001a\u00020*2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\f\u0010S\u001a\u00020**\u00020$H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0015\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006U"}, d2={"Lcom/braze/push/BrazeNotificationUtils;", "", "()V", "SOURCE_KEY", "", "TAG", "activeNotificationFactory", "Lcom/braze/IBrazeNotificationFactory;", "getActiveNotificationFactory", "()Lcom/braze/IBrazeNotificationFactory;", "notificationReceiverClass", "Ljava/lang/Class;", "getNotificationReceiverClass", "()Ljava/lang/Class;", "cancelNotification", "", "context", "Landroid/content/Context;", "notificationId", "", "getNotificationId", "payload", "Lcom/braze/models/push/BrazeNotificationPayload;", "getNotificationPriority", "getOrCreateNotificationChannelId", "getPushActionPendingIntent", "Landroid/app/PendingIntent;", "action", "notificationExtras", "Landroid/os/Bundle;", "getValidNotificationChannel", "Landroid/app/NotificationChannel;", "notificationManager", "Landroid/app/NotificationManager;", "handleCancelNotificationAction", "intent", "Landroid/content/Intent;", "handleContentCardsSerializedCardIfPresent", "handleNotificationDeleted", "handleNotificationOpened", "handlePushStoryPageClicked", "isNotificationMessage", "", "isUninstallTrackingPush", "isValidNotificationVisibility", "visibility", "logBaiduNotificationClick", "customContentString", "prefetchBitmapsIfNewlyReceivedStoryPush", "refreshFeatureFlagsIfAppropriate", "requestGeofenceRefreshIfAppropriate", "routeUserWithNotificationOpenedIntent", "sendNotificationOpenedBroadcast", "sendPushActionIntent", "pushIntent", "broadcastType", "Lcom/braze/push/BrazeNotificationUtils$BrazeNotificationBroadcastType;", "sendPushMessageReceivedBroadcast", "setAccentColorIfPresentAndSupported", "notificationBuilder", "Landroidx/core/app/NotificationCompat$Builder;", "setCategoryIfPresentAndSupported", "setContentIfPresent", "setContentIntentIfPresent", "setDeleteIntent", "setLargeIconIfPresentAndSupported", "setNotificationBadgeNumberIfPresent", "setNotificationDurationAlarm", "thisClass", "durationInMillis", "setPriorityIfPresentAndSupported", "setPublicVersionIfPresentAndSupported", "setSetShowWhen", "setSmallIcon", "appConfigurationProvider", "Lcom/braze/configuration/BrazeConfigurationProvider;", "setSoundIfPresentAndSupported", "setSummaryTextIfPresentAndSupported", "setTickerIfPresent", "setTitleIfPresent", "setVisibilityIfPresentAndSupported", "wakeScreenIfAppropriate", "configurationProvider", "isBrazePushMessage", "BrazeNotificationBroadcastType", "android-sdk-ui_release"})
@SourceDebugExtension(value={"SMAP\nBrazeNotificationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrazeNotificationUtils.kt\ncom/braze/push/BrazeNotificationUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1081:1\n1#2:1082\n1#2:1093\n1603#3,9:1083\n1855#3:1092\n1856#3:1094\n1612#3:1095\n1855#3,2:1096\n*S KotlinDebug\n*F\n+ 1 BrazeNotificationUtils.kt\ncom/braze/push/BrazeNotificationUtils\n*L\n408#1:1093\n408#1:1083,9\n408#1:1092\n408#1:1094\n408#1:1095\n409#1:1096,2\n*E\n"})
public final class BrazeNotificationUtils {
    @NotNull
    public static final BrazeNotificationUtils INSTANCE = new BrazeNotificationUtils();
    @NotNull
    private static final String TAG = BrazeLogger.getBrazeLogTag(BrazeNotificationUtils.class);
    @NotNull
    private static final String SOURCE_KEY = "source";

    private BrazeNotificationUtils() {
    }

    @JvmStatic
    @NotNull
    public static final IBrazeNotificationFactory getActiveNotificationFactory() {
        IBrazeNotificationFactory iBrazeNotificationFactory = Braze.Companion.getCustomBrazeNotificationFactory();
        if (iBrazeNotificationFactory == null) {
            iBrazeNotificationFactory = BrazeNotificationFactory.Companion.getInstance();
        }
        return iBrazeNotificationFactory;
    }

    @JvmStatic
    @NotNull
    public static final Class<?> getNotificationReceiverClass() {
        return Constants.isAmazonDevice() ? BrazeAmazonDeviceMessagingReceiver.class : BrazePushReceiver.class;
    }

    @JvmStatic
    public static final void handleNotificationOpened(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            Braze.Companion.getInstance(context).logPushNotificationOpened(intent);
            BrazeNotificationUtils.sendNotificationOpenedBroadcast(context, intent);
            BrazeConfigurationProvider appConfigurationProvider = new BrazeConfigurationProvider(context);
            if (appConfigurationProvider.getDoesHandlePushDeepLinksAutomatically()) {
                BrazeNotificationUtils.routeUserWithNotificationOpenedIntent(context, intent);
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)handleNotificationOpened.1.INSTANCE, (int)2, null);
            }
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)INSTANCE, BrazeLogger.Priority.E, (Throwable)e, (Function0)handleNotificationOpened.2.INSTANCE);
        }
    }

    @JvmStatic
    public static final void handleNotificationDeleted(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)handleNotificationDeleted.1.INSTANCE, (int)3, null);
            Bundle notificationExtras = intent.getExtras();
            if (notificationExtras != null) {
                BrazeNotificationPayload notificationPayload = new BrazeNotificationPayload(notificationExtras, null, context, null, 10, null);
                INSTANCE.sendPushActionIntent(context, BrazeNotificationBroadcastType.DELETED, notificationExtras, notificationPayload);
            } else {
                BrazeNotificationUtils.sendPushActionIntent$default(INSTANCE, context, BrazeNotificationBroadcastType.DELETED, notificationExtras, null, 8, null);
            }
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)INSTANCE, BrazeLogger.Priority.E, (Throwable)e, (Function0)handleNotificationDeleted.2.INSTANCE);
        }
    }

    @JvmStatic
    public static final void routeUserWithNotificationOpenedIntent(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Bundle extras = intent.getBundleExtra("extra");
        if (extras == null) {
            extras = new Bundle();
        }
        extras.putString("cid", intent.getStringExtra("cid"));
        extras.putString(SOURCE_KEY, "Appboy");
        String deepLink = intent.getStringExtra("uri");
        CharSequence charSequence = deepLink;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            boolean useWebView = StringsKt.equals((String)"true", (String)intent.getStringExtra("ab_use_webview"), (boolean)true);
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)((Function0)new Function0<String>(deepLink, useWebView){
                final /* synthetic */ String $deepLink;
                final /* synthetic */ boolean $useWebView;
                {
                    this.$deepLink = $deepLink;
                    this.$useWebView = $useWebView;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Found a deep link: " + this.$deepLink + ". Use webview set to: " + this.$useWebView;
                }
            }), (int)3, null);
            extras.putString("uri", deepLink);
            extras.putBoolean("ab_use_webview", useWebView);
            UriAction uriAction = BrazeDeeplinkHandler.Companion.getInstance().createUriActionFromUrlString(deepLink, extras, useWebView, Channel.PUSH);
            if (uriAction != null) {
                UriAction it = uriAction;
                boolean bl = false;
                BrazeDeeplinkHandler.Companion.getInstance().gotoUri(context, it);
            }
        } else {
            Intent mainActivityIntent = UriUtils.getMainActivityIntent(context, extras);
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)((Function0)new Function0<String>(mainActivityIntent){
                final /* synthetic */ Intent $mainActivityIntent;
                {
                    this.$mainActivityIntent = $mainActivityIntent;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Push notification had no deep link. Opening main activity: " + this.$mainActivityIntent;
                }
            }), (int)3, null);
            context.startActivity(mainActivityIntent);
        }
    }

    @JvmStatic
    public static final boolean isBrazePushMessage(@NotNull Intent $this$isBrazePushMessage) {
        Intrinsics.checkNotNullParameter((Object)$this$isBrazePushMessage, (String)"<this>");
        Bundle bundle = $this$isBrazePushMessage.getExtras();
        if (bundle == null) {
            return false;
        }
        Bundle extras = bundle;
        return StringsKt.equals((String)"true", (String)extras.getString("_ab"), (boolean)true);
    }

    @JvmStatic
    public static final boolean isNotificationMessage(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            return false;
        }
        Bundle extras = bundle;
        return extras.containsKey("t") && extras.containsKey("a");
    }

    @JvmStatic
    public static final void sendPushMessageReceivedBroadcast(@NotNull Context context, @NotNull Bundle notificationExtras, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)notificationExtras, (String)"notificationExtras");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)sendPushMessageReceivedBroadcast.1.INSTANCE, (int)3, null);
        INSTANCE.sendPushActionIntent(context, BrazeNotificationBroadcastType.RECEIVED, notificationExtras, payload);
    }

    @JvmStatic
    public static final boolean requestGeofenceRefreshIfAppropriate(@NotNull BrazeNotificationPayload payload) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Context context = payload.getContext();
        if (payload.getShouldSyncGeofences() && context != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)requestGeofenceRefreshIfAppropriate.1.INSTANCE, (int)3, null);
            BrazeInternal.requestGeofenceRefresh((Context)context, (boolean)true);
            bl = true;
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)requestGeofenceRefreshIfAppropriate.2.INSTANCE, (int)3, null);
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean refreshFeatureFlagsIfAppropriate(@NotNull BrazeNotificationPayload payload) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Context context = payload.getContext();
        if (payload.getShouldRefreshFeatureFlags() && context != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)refreshFeatureFlagsIfAppropriate.1.INSTANCE, (int)3, null);
            BrazeInternal.refreshFeatureFlags((Context)context);
            bl = true;
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)refreshFeatureFlagsIfAppropriate.2.INSTANCE, (int)2, null);
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final void setNotificationDurationAlarm(@NotNull Context context, @Nullable Class<?> thisClass, int notificationId, int durationInMillis) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent cancelIntent = new Intent(context, thisClass);
        cancelIntent.setAction("com.braze.action.CANCEL_NOTIFICATION");
        cancelIntent.putExtra("nid", notificationId);
        int flags = 0x8000000 | IntentUtils.getImmutablePendingIntentFlags();
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)cancelIntent, (int)flags);
        Object object = context.getSystemService("alarm");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.AlarmManager");
        AlarmManager alarmManager = (AlarmManager)object;
        if (durationInMillis >= 1000) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)((Function0)new Function0<String>(durationInMillis){
                final /* synthetic */ int $durationInMillis;
                {
                    this.$durationInMillis = $durationInMillis;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Setting Notification duration alarm for " + this.$durationInMillis + " ms";
                }
            }), (int)3, null);
            alarmManager.set(3, SystemClock.elapsedRealtime() + (long)durationInMillis, pendingIntent);
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final int getNotificationId(@NotNull BrazeNotificationPayload payload) {
        int n;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Integer customNotificationId = payload.getCustomNotificationId();
        if (customNotificationId != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)((Function0)new Function0<String>(customNotificationId){
                final /* synthetic */ Integer $customNotificationId;
                {
                    this.$customNotificationId = $customNotificationId;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Using notification id provided in the message's extras bundle: " + this.$customNotificationId;
                }
            }), (int)3, null);
            n = customNotificationId;
        } else {
            void var3_5;
            String it;
            String messageKey = null;
            messageKey = "";
            String string = payload.getTitleText();
            if (string != null) {
                it = string;
                boolean bl = false;
                messageKey = messageKey + it;
            }
            String string2 = payload.getContentText();
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                messageKey = messageKey + it;
            }
            String string3 = messageKey;
            int notificationId = string3 != null ? string3.hashCode() : 0;
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)((Function0)new Function0<String>(notificationId){
                final /* synthetic */ int $notificationId;
                {
                    this.$notificationId = $notificationId;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Message without notification id provided in the extras bundle received. Using a hash of the message: " + this.$notificationId;
                }
            }), (int)3, null);
            n = var3_5;
        }
        return n;
    }

    @JvmStatic
    public static final int getNotificationPriority(@NotNull BrazeNotificationPayload payload) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Integer notificationPriority = payload.getNotificationPriorityInt();
            Integer n = payload.getNotificationPriorityInt();
            if (n == null) break block1;
            int it = ((Number)n).intValue();
            boolean bl = false;
            boolean bl2 = -2 <= it ? it < 3 : false;
            if (bl2) {
                return it;
            }
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)((Function0)new Function0<String>(notificationPriority){
                final /* synthetic */ Integer $notificationPriority;
                {
                    this.$notificationPriority = $notificationPriority;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Received invalid notification priority " + this.$notificationPriority;
                }
            }), (int)2, null);
        }
        return 0;
    }

    @JvmStatic
    public static final boolean wakeScreenIfAppropriate(@NotNull Context context, @NotNull BrazeConfigurationProvider configurationProvider, @Nullable Bundle notificationExtras) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configurationProvider, (String)"configurationProvider");
        return BrazeNotificationUtils.wakeScreenIfAppropriate(new BrazeNotificationPayload(notificationExtras, null, context, configurationProvider, 2, null));
    }

    @JvmStatic
    @SuppressLint(value={"WakelockTimeout"})
    public static final boolean wakeScreenIfAppropriate(@NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Context context = payload.getContext();
        if (context == null) {
            return false;
        }
        Context context2 = context;
        BrazeConfigurationProvider brazeConfigurationProvider = payload.getConfigurationProvider();
        if (brazeConfigurationProvider == null) {
            return false;
        }
        BrazeConfigurationProvider configurationProvider = brazeConfigurationProvider;
        Bundle notificationExtras = payload.getNotificationExtras();
        if (!PermissionUtils.hasPermission((Context)context2, (String)"android.permission.WAKE_LOCK") || !configurationProvider.isPushWakeScreenForNotificationEnabled()) {
            return false;
        }
        try {
            Object object = context2.getSystemService("uimode");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.UiModeManager");
            UiModeManager uiModeManager = (UiModeManager)object;
            if (uiModeManager.getCurrentModeType() == 4) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)wakeScreenIfAppropriate.1.INSTANCE, (int)3, null);
                return false;
            }
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)INSTANCE, BrazeLogger.Priority.E, (Throwable)e, (Function0)wakeScreenIfAppropriate.2.INSTANCE);
        }
        if (Build.VERSION.SDK_INT >= 26) {
            Object object = context2.getSystemService("notification");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
            NotificationManager notificationManager = (NotificationManager)object;
            NotificationChannel notificationChannel = BrazeNotificationUtils.getValidNotificationChannel(notificationManager, notificationExtras);
            if (notificationChannel == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)wakeScreenIfAppropriate.3.INSTANCE, (int)3, null);
                return false;
            }
            if (notificationChannel.getImportance() == 1) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)((Function0)new Function0<String>(notificationChannel){
                    final /* synthetic */ NotificationChannel $notificationChannel;
                    {
                        this.$notificationChannel = $notificationChannel;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Not acquiring wake-lock for Android O+ notification with importance: " + this.$notificationChannel.getImportance();
                    }
                }), (int)3, null);
                return false;
            }
        } else if (BrazeNotificationUtils.getNotificationPriority(payload) == -2) {
            return false;
        }
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)wakeScreenIfAppropriate.5.INSTANCE, (int)3, null);
        Object object = context2.getSystemService("power");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.PowerManager");
        PowerManager powerManager = (PowerManager)object;
        PowerManager.WakeLock wakeLock = powerManager.newWakeLock(0x1000001A, TAG);
        wakeLock.acquire();
        wakeLock.release();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void prefetchBitmapsIfNewlyReceivedStoryPush(@NotNull BrazeNotificationPayload payload) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Context context = payload.getContext();
        if (context == null) {
            return;
        }
        Context context2 = context;
        if (!payload.isPushStory() || !payload.isNewlyReceivedPushStory()) {
            return;
        }
        Iterable $this$mapNotNull$iv = payload.getPushStoryPages();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            BrazeNotificationPayload.PushStoryPage it = (BrazeNotificationPayload.PushStoryPage)element$iv$iv;
            boolean bl2 = false;
            if (it.getBitmapUrl() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>(it){
                final /* synthetic */ String $it;
                {
                    this.$it = $it;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Pre-fetching bitmap at URL: " + this.$it;
                }
            }), (int)2, null);
            Braze.Companion.getInstance(context2).getImageLoader().getPushBitmapFromUrl(context2, payload.getBrazeExtras(), it, BrazeViewBounds.NOTIFICATION_ONE_IMAGE_STORY);
        }
        payload.setNewlyReceivedPushStory(false);
    }

    @JvmStatic
    public static final void setTitleIfPresent(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setTitleIfPresent.1.INSTANCE, (int)3, null);
        String string = payload.getTitleText();
        if (string == null) {
            return;
        }
        String titleText = string;
        BrazeConfigurationProvider brazeConfigurationProvider = payload.getConfigurationProvider();
        if (brazeConfigurationProvider == null) {
            return;
        }
        BrazeConfigurationProvider configurationProvider = brazeConfigurationProvider;
        notificationBuilder.setContentTitle(HtmlUtils.getHtmlSpannedTextIfEnabled(titleText, configurationProvider));
    }

    @JvmStatic
    public static final void setContentIfPresent(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setContentIfPresent.1.INSTANCE, (int)3, null);
        String string = payload.getContentText();
        if (string == null) {
            return;
        }
        String contentText = string;
        BrazeConfigurationProvider brazeConfigurationProvider = payload.getConfigurationProvider();
        if (brazeConfigurationProvider == null) {
            return;
        }
        BrazeConfigurationProvider configurationProvider = brazeConfigurationProvider;
        notificationBuilder.setContentText(HtmlUtils.getHtmlSpannedTextIfEnabled(contentText, configurationProvider));
    }

    @JvmStatic
    public static final void setTickerIfPresent(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setTickerIfPresent.1.INSTANCE, (int)3, null);
        String string = payload.getTitleText();
        if (string == null) {
            return;
        }
        String titleText = string;
        notificationBuilder.setTicker((CharSequence)titleText);
    }

    @JvmStatic
    public static final void setContentIntentIfPresent(@NotNull Context context, @NotNull NotificationCompat.Builder notificationBuilder, @Nullable Bundle notificationExtras) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        try {
            PendingIntent pushOpenedPendingIntent = INSTANCE.getPushActionPendingIntent(context, "com.braze.action.BRAZE_PUSH_CLICKED", notificationExtras);
            notificationBuilder.setContentIntent(pushOpenedPendingIntent);
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)INSTANCE, BrazeLogger.Priority.E, (Throwable)e, (Function0)setContentIntentIfPresent.1.INSTANCE);
        }
    }

    @JvmStatic
    public static final void setDeleteIntent(@NotNull Context context, @NotNull NotificationCompat.Builder notificationBuilder, @Nullable Bundle notificationExtras) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        try {
            Intent intent = new Intent("com.braze.action.BRAZE_PUSH_DELETED").setClass(context, INSTANCE.getNotificationReceiverClass());
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(Constants.BRAZE_P\u2026otificationReceiverClass)");
            Intent pushDeletedIntent = intent;
            if (notificationExtras != null) {
                pushDeletedIntent.putExtras(notificationExtras);
            }
            int flags = 0x40000000 | IntentUtils.getImmutablePendingIntentFlags();
            PendingIntent pushDeletedPendingIntent = PendingIntent.getBroadcast((Context)context, (int)IntentUtils.getRequestCode(), (Intent)pushDeletedIntent, (int)flags);
            notificationBuilder.setDeleteIntent(pushDeletedPendingIntent);
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)INSTANCE, BrazeLogger.Priority.E, (Throwable)e, (Function0)setDeleteIntent.1.INSTANCE);
        }
    }

    @JvmStatic
    public static final int setSmallIcon(@NotNull BrazeConfigurationProvider appConfigurationProvider, @NotNull NotificationCompat.Builder notificationBuilder) {
        Intrinsics.checkNotNullParameter((Object)appConfigurationProvider, (String)"appConfigurationProvider");
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        int smallNotificationIconResourceId = appConfigurationProvider.getSmallNotificationIconResourceId();
        if (smallNotificationIconResourceId == 0) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setSmallIcon.1.INSTANCE, (int)3, null);
            smallNotificationIconResourceId = appConfigurationProvider.getApplicationIconResourceId();
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setSmallIcon.2.INSTANCE, (int)3, null);
        }
        notificationBuilder.setSmallIcon(smallNotificationIconResourceId);
        return smallNotificationIconResourceId;
    }

    @JvmStatic
    public static final void setSetShowWhen(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (payload.isPushStory()) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setSetShowWhen.1.INSTANCE, (int)3, null);
            notificationBuilder.setShowWhen(false);
        }
    }

    @JvmStatic
    public static final boolean setLargeIconIfPresentAndSupported(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (payload.isPushStory()) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setLargeIconIfPresentAndSupported.1.INSTANCE, (int)3, null);
            return false;
        }
        Context context = payload.getContext();
        if (context == null) {
            return false;
        }
        Context context2 = context;
        BrazeConfigurationProvider brazeConfigurationProvider = payload.getConfigurationProvider();
        if (brazeConfigurationProvider == null) {
            return false;
        }
        BrazeConfigurationProvider appConfigurationProvider = brazeConfigurationProvider;
        try {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setLargeIconIfPresentAndSupported.2.INSTANCE, (int)3, null);
            String string = payload.getLargeIcon();
            if (string != null) {
                String it = string;
                boolean bl = false;
                Bitmap largeNotificationBitmap = Braze.Companion.getInstance(context2).getImageLoader().getPushBitmapFromUrl(context2, null, it, BrazeViewBounds.NOTIFICATION_LARGE_ICON);
                notificationBuilder.setLargeIcon(largeNotificationBitmap);
                return true;
            }
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setLargeIconIfPresentAndSupported.4.INSTANCE, (int)3, null);
            int largeNotificationIconResourceId = appConfigurationProvider.getLargeNotificationIconResourceId();
            if (largeNotificationIconResourceId != 0) {
                Bitmap largeNotificationBitmap = BitmapFactory.decodeResource((Resources)context2.getResources(), (int)largeNotificationIconResourceId);
                notificationBuilder.setLargeIcon(largeNotificationBitmap);
                return true;
            }
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setLargeIconIfPresentAndSupported.5.INSTANCE, (int)3, null);
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)INSTANCE, BrazeLogger.Priority.E, (Throwable)e, (Function0)setLargeIconIfPresentAndSupported.6.INSTANCE);
        }
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setLargeIconIfPresentAndSupported.7.INSTANCE, (int)3, null);
        return false;
    }

    @JvmStatic
    public static final void setSoundIfPresentAndSupported(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        String string = payload.getNotificationSound();
        if (string == null) {
            return;
        }
        String soundUri = string;
        if (Intrinsics.areEqual((Object)soundUri, (Object)"d")) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setSoundIfPresentAndSupported.1.INSTANCE, (int)3, null);
            notificationBuilder.setDefaults(1);
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setSoundIfPresentAndSupported.2.INSTANCE, (int)3, null);
            notificationBuilder.setSound(Uri.parse((String)soundUri));
        }
    }

    @JvmStatic
    public static final void setSummaryTextIfPresentAndSupported(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        String summaryText = payload.getSummaryText();
        if (summaryText != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setSummaryTextIfPresentAndSupported.1.INSTANCE, (int)3, null);
            notificationBuilder.setSubText((CharSequence)summaryText);
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setSummaryTextIfPresentAndSupported.2.INSTANCE, (int)3, null);
        }
    }

    @JvmStatic
    public static final void setPriorityIfPresentAndSupported(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setPriorityIfPresentAndSupported.1.INSTANCE, (int)3, null);
        notificationBuilder.setPriority(BrazeNotificationUtils.getNotificationPriority(payload));
    }

    @JvmStatic
    public static final void setAccentColorIfPresentAndSupported(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        block1: {
            block0: {
                Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
                Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
                Integer accentColor = payload.getAccentColor();
                if (accentColor == null) break block0;
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setAccentColorIfPresentAndSupported.1.INSTANCE, (int)3, null);
                notificationBuilder.setColor(accentColor.intValue());
                break block1;
            }
            BrazeConfigurationProvider brazeConfigurationProvider = payload.getConfigurationProvider();
            if (brazeConfigurationProvider == null) break block1;
            BrazeConfigurationProvider it = brazeConfigurationProvider;
            boolean bl = false;
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setAccentColorIfPresentAndSupported.2.1.INSTANCE, (int)3, null);
            notificationBuilder.setColor(it.getDefaultNotificationAccentColor());
        }
    }

    @JvmStatic
    public static final void setCategoryIfPresentAndSupported(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        String notificationCategory = payload.getNotificationCategory();
        if (notificationCategory != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setCategoryIfPresentAndSupported.1.INSTANCE, (int)3, null);
            notificationBuilder.setCategory(notificationCategory);
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setCategoryIfPresentAndSupported.2.INSTANCE, (int)3, null);
        }
    }

    @JvmStatic
    public static final void setVisibilityIfPresentAndSupported(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Integer visibility = payload.getNotificationVisibility();
        if (visibility != null) {
            if (BrazeNotificationUtils.isValidNotificationVisibility(visibility)) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setVisibilityIfPresentAndSupported.1.INSTANCE, (int)3, null);
                notificationBuilder.setVisibility(visibility.intValue());
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)((Function0)new Function0<String>(visibility){
                    final /* synthetic */ Integer $visibility;
                    {
                        this.$visibility = $visibility;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Received invalid notification visibility " + this.$visibility;
                    }
                }), (int)2, null);
            }
        }
    }

    @JvmStatic
    public static final void setPublicVersionIfPresentAndSupported(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Context context = payload.getContext();
        BrazeConfigurationProvider appConfigurationProvider = payload.getConfigurationProvider();
        if (Build.VERSION.SDK_INT < 21) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setPublicVersionIfPresentAndSupported.1.INSTANCE, (int)3, null);
            return;
        }
        if (context == null || payload.getPublicNotificationExtras() == null || appConfigurationProvider == null) {
            return;
        }
        String notificationChannelId = BrazeNotificationUtils.getOrCreateNotificationChannelId(payload);
        Bundle publicNotificationExtras = JsonUtils.parseJsonObjectIntoBundle((String)payload.getPublicNotificationExtras());
        if (publicNotificationExtras.isEmpty()) {
            return;
        }
        BrazeNotificationPayload publicPayload = new BrazeNotificationPayload(publicNotificationExtras, null, context, appConfigurationProvider, 2, null);
        NotificationCompat.Builder publicNotificationBuilder = new NotificationCompat.Builder(context, notificationChannelId);
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)((Function0)new Function0<String>(publicPayload){
            final /* synthetic */ BrazeNotificationPayload $publicPayload;
            {
                this.$publicPayload = $publicPayload;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Setting public version of notification with payload: " + this.$publicPayload;
            }
        }), (int)3, null);
        BrazeNotificationUtils.setContentIfPresent(publicNotificationBuilder, publicPayload);
        BrazeNotificationUtils.setTitleIfPresent(publicNotificationBuilder, publicPayload);
        BrazeNotificationUtils.setSummaryTextIfPresentAndSupported(publicNotificationBuilder, publicPayload);
        BrazeNotificationUtils.setSmallIcon(appConfigurationProvider, publicNotificationBuilder);
        BrazeNotificationUtils.setAccentColorIfPresentAndSupported(publicNotificationBuilder, publicPayload);
        notificationBuilder.setPublicVersion(publicNotificationBuilder.build());
    }

    @JvmStatic
    @TargetApi(value=21)
    public static final boolean isValidNotificationVisibility(int visibility) {
        return visibility == -1 || visibility == 0 || visibility == 1;
    }

    @JvmStatic
    public static final void logBaiduNotificationClick(@Nullable Context context, @Nullable String customContentString) {
        if (customContentString == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)logBaiduNotificationClick.1.INSTANCE, (int)2, null);
            return;
        }
        if (context == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)logBaiduNotificationClick.2.INSTANCE, (int)2, null);
            return;
        }
        try {
            JSONObject jsonExtras = new JSONObject(customContentString);
            String source = JsonUtils.getOptionalString((JSONObject)jsonExtras, (String)SOURCE_KEY);
            String campaignId = JsonUtils.getOptionalString((JSONObject)jsonExtras, (String)"cid");
            if (source != null && Intrinsics.areEqual((Object)source, (Object)"Appboy") && campaignId != null) {
                Braze.Companion.getInstance(context).logPushNotificationOpened(campaignId);
            }
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)INSTANCE, BrazeLogger.Priority.E, (Throwable)e, (Function0)new Function0<String>(customContentString){
                final /* synthetic */ String $customContentString;
                {
                    this.$customContentString = $customContentString;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Caught an exception processing customContentString: " + this.$customContentString;
                }
            });
        }
    }

    @JvmStatic
    public static final void handleCancelNotificationAction(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            if (intent.hasExtra("nid")) {
                int notificationId = intent.getIntExtra("nid", -1);
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)((Function0)new Function0<String>(notificationId){
                    final /* synthetic */ int $notificationId;
                    {
                        this.$notificationId = $notificationId;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Cancelling notification action with id: " + this.$notificationId;
                    }
                }), (int)3, null);
                Object object = context.getSystemService("notification");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
                NotificationManager notificationManager = (NotificationManager)object;
                notificationManager.cancel("appboy_notification", notificationId);
            }
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)INSTANCE, BrazeLogger.Priority.E, (Throwable)e, (Function0)handleCancelNotificationAction.2.INSTANCE);
        }
    }

    @JvmStatic
    public static final void cancelNotification(@NotNull Context context, int notificationId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)((Function0)new Function0<String>(notificationId){
                final /* synthetic */ int $notificationId;
                {
                    this.$notificationId = $notificationId;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Cancelling notification action with id: " + this.$notificationId;
                }
            }), (int)3, null);
            Intent intent = new Intent("com.braze.action.CANCEL_NOTIFICATION").setClass(context, INSTANCE.getNotificationReceiverClass());
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(Constants.BRAZE_C\u2026otificationReceiverClass)");
            Intent cancelNotificationIntent = intent;
            cancelNotificationIntent.setPackage(context.getPackageName());
            cancelNotificationIntent.putExtra("nid", notificationId);
            IntentUtils.addComponentAndSendBroadcast((Context)context, (Intent)cancelNotificationIntent);
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)INSTANCE, BrazeLogger.Priority.E, (Throwable)e, (Function0)cancelNotification.2.INSTANCE);
        }
    }

    @JvmStatic
    @Deprecated(message="Please use BrazeNotificationPayload().isUninstallTracking instead")
    public static final boolean isUninstallTrackingPush(@NotNull Bundle notificationExtras) {
        Intrinsics.checkNotNullParameter((Object)notificationExtras, (String)"notificationExtras");
        try {
            if (notificationExtras.containsKey("appboy_uninstall_tracking")) {
                return true;
            }
            Bundle fcmExtras = notificationExtras.getBundle("extra");
            if (fcmExtras != null) {
                return fcmExtras.containsKey("appboy_uninstall_tracking");
            }
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)INSTANCE, BrazeLogger.Priority.E, (Throwable)e, (Function0)isUninstallTrackingPush.1.INSTANCE);
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final String getOrCreateNotificationChannelId(@NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        String channelIdFromExtras = payload.getNotificationChannelId();
        String defaultChannelId = "com_appboy_default_notification_channel";
        if (Build.VERSION.SDK_INT < 26) {
            String string = channelIdFromExtras;
            if (string == null) {
                string = defaultChannelId;
            }
            return string;
        }
        Context context = payload.getContext();
        BrazeConfigurationProvider config = payload.getConfigurationProvider();
        Context context2 = context;
        Object object = context2 != null ? context2.getSystemService("notification") : null;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        NotificationManager notificationManager = (NotificationManager)object;
        if (channelIdFromExtras != null) {
            if (notificationManager.getNotificationChannel(channelIdFromExtras) != null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)((Function0)new Function0<String>(channelIdFromExtras){
                    final /* synthetic */ String $channelIdFromExtras;
                    {
                        this.$channelIdFromExtras = $channelIdFromExtras;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Found notification channel in extras with id: " + this.$channelIdFromExtras;
                    }
                }), (int)3, null);
                return channelIdFromExtras;
            }
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)((Function0)new Function0<String>(channelIdFromExtras){
                final /* synthetic */ String $channelIdFromExtras;
                {
                    this.$channelIdFromExtras = $channelIdFromExtras;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Notification channel from extras is invalid. No channel found with id: " + this.$channelIdFromExtras;
                }
            }), (int)3, null);
        }
        if (notificationManager.getNotificationChannel(defaultChannelId) == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)getOrCreateNotificationChannelId.3.INSTANCE, (int)3, null);
            BrazeConfigurationProvider brazeConfigurationProvider = config;
            NotificationChannel channel = new NotificationChannel(defaultChannelId, (CharSequence)(brazeConfigurationProvider != null ? brazeConfigurationProvider.getDefaultNotificationChannelName() : null), 3);
            BrazeConfigurationProvider brazeConfigurationProvider2 = config;
            channel.setDescription(brazeConfigurationProvider2 != null ? brazeConfigurationProvider2.getDefaultNotificationChannelDescription() : null);
            notificationManager.createNotificationChannel(channel);
        }
        return defaultChannelId;
    }

    @JvmStatic
    public static final void setNotificationBadgeNumberIfPresent(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (Build.VERSION.SDK_INT < 26) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)setNotificationBadgeNumberIfPresent.1.INSTANCE, (int)3, null);
            return;
        }
        Integer notificationBadgeNumber = payload.getNotificationBadgeNumber();
        if (notificationBadgeNumber != null) {
            notificationBuilder.setNumber(notificationBadgeNumber.intValue());
        }
    }

    @JvmStatic
    public static final void handlePushStoryPageClicked(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            String deepLink;
            CharSequence charSequence;
            Braze.Companion.getInstance(context).logPushStoryPageClicked(intent.getStringExtra("braze_campaign_id"), intent.getStringExtra("braze_story_page_id"));
            BrazeConfigurationProvider appConfigurationProvider = new BrazeConfigurationProvider(context);
            int notificationId = intent.getIntExtra("nid", 0);
            if (appConfigurationProvider.getDoesPushStoryDismissOnClick() && notificationId != 0) {
                BrazeNotificationUtils.cancelNotification(context, notificationId);
            }
            if (!((charSequence = (CharSequence)(deepLink = intent.getStringExtra("braze_action_uri"))) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                intent.putExtra("uri", intent.getStringExtra("braze_action_uri"));
                String useWebviewString = intent.getStringExtra("braze_action_use_webview");
                CharSequence charSequence2 = useWebviewString;
                if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2))) {
                    intent.putExtra("ab_use_webview", useWebviewString);
                }
            } else {
                intent.removeExtra("uri");
            }
            BrazeNotificationUtils.sendNotificationOpenedBroadcast(context, intent);
            if (appConfigurationProvider.getDoesHandlePushDeepLinksAutomatically()) {
                BrazeNotificationUtils.routeUserWithNotificationOpenedIntent(context, intent);
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)((Function0)new Function0<String>(deepLink){
                    final /* synthetic */ String $deepLink;
                    {
                        this.$deepLink = $deepLink;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Not handling deep links automatically, skipping deep link handling for '" + this.$deepLink + '\'';
                    }
                }), (int)2, null);
            }
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)INSTANCE, BrazeLogger.Priority.E, (Throwable)e, (Function0)handlePushStoryPageClicked.2.INSTANCE);
        }
    }

    @JvmStatic
    public static final void handleContentCardsSerializedCardIfPresent(@NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        String contentCardData = payload.getContentCardSyncData();
        String contentCardDataUserId = payload.getContentCardSyncUserId();
        Context context = payload.getContext();
        if (contentCardData != null && context != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)((Function0)new Function0<String>(contentCardDataUserId, contentCardData){
                final /* synthetic */ String $contentCardDataUserId;
                final /* synthetic */ String $contentCardData;
                {
                    this.$contentCardDataUserId = $contentCardDataUserId;
                    this.$contentCardData = $contentCardData;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Push contains associated Content Cards card. User id: " + this.$contentCardDataUserId + " Card data: " + this.$contentCardData;
                }
            }), (int)3, null);
            BrazeInternal.addSerializedContentCardToStorage((Context)context, (String)contentCardData, (String)contentCardDataUserId);
        }
    }

    @JvmStatic
    public static final void sendNotificationOpenedBroadcast(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)sendNotificationOpenedBroadcast.1.INSTANCE, (int)3, null);
        Bundle notificationExtras = intent.getExtras();
        if (notificationExtras != null) {
            BrazeNotificationPayload notificationPayload = new BrazeNotificationPayload(notificationExtras, null, context, null, 10, null);
            INSTANCE.sendPushActionIntent(context, BrazeNotificationBroadcastType.OPENED, notificationExtras, notificationPayload);
        } else {
            BrazeNotificationUtils.sendPushActionIntent$default(INSTANCE, context, BrazeNotificationBroadcastType.OPENED, notificationExtras, null, 8, null);
        }
    }

    @JvmStatic
    @TargetApi(value=26)
    @Nullable
    public static final NotificationChannel getValidNotificationChannel(@NotNull NotificationManager notificationManager, @Nullable Bundle notificationExtras) {
        NotificationChannel defaultNotificationChannel;
        Intrinsics.checkNotNullParameter((Object)notificationManager, (String)"notificationManager");
        if (notificationExtras == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)getValidNotificationChannel.1.INSTANCE, (int)3, null);
            return null;
        }
        String channelIdFromExtras = notificationExtras.getString("ab_nc", null);
        CharSequence charSequence = channelIdFromExtras;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            NotificationChannel notificationChannel = notificationManager.getNotificationChannel(channelIdFromExtras);
            if (notificationChannel != null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)((Function0)new Function0<String>(channelIdFromExtras){
                    final /* synthetic */ String $channelIdFromExtras;
                    {
                        this.$channelIdFromExtras = $channelIdFromExtras;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Found notification channel in extras with id: " + this.$channelIdFromExtras;
                    }
                }), (int)3, null);
                return notificationChannel;
            }
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)((Function0)new Function0<String>(channelIdFromExtras){
                final /* synthetic */ String $channelIdFromExtras;
                {
                    this.$channelIdFromExtras = $channelIdFromExtras;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Notification channel from extras is invalid, no channel found with id: " + this.$channelIdFromExtras;
                }
            }), (int)3, null);
        }
        if ((defaultNotificationChannel = notificationManager.getNotificationChannel("com_appboy_default_notification_channel")) != null) {
            return defaultNotificationChannel;
        }
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (Function0)getValidNotificationChannel.4.INSTANCE, (int)3, null);
        return null;
    }

    private final PendingIntent getPushActionPendingIntent(Context context, String action, Bundle notificationExtras) {
        Intent intent = new Intent(action).setClass(context, NotificationTrampolineActivity.class);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(action).setClass(\u2026lineActivity::class.java)");
        Intent pushActionIntent = intent;
        if (notificationExtras != null) {
            pushActionIntent.putExtras(notificationExtras);
        }
        int flags = 0x40000000 | IntentUtils.getImmutablePendingIntentFlags();
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)IntentUtils.getRequestCode(), (Intent)pushActionIntent, (int)flags);
        Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"getActivity(context, get\u2026 pushActionIntent, flags)");
        return pendingIntent;
    }

    private final void sendPushActionIntent(Context context, BrazeNotificationBroadcastType broadcastType, Bundle notificationExtras, BrazeNotificationPayload payload) {
        Intent intent;
        switch (WhenMappings.$EnumSwitchMapping$0[broadcastType.ordinal()]) {
            case 1: {
                Intent intent2 = new Intent("com.braze.push.intent.NOTIFICATION_OPENED").setPackage(context.getPackageName());
                intent = intent2;
                Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"{\n                Intent\u2026ackageName)\n            }");
                break;
            }
            case 2: {
                Intent intent3 = new Intent("com.braze.push.intent.NOTIFICATION_RECEIVED").setPackage(context.getPackageName());
                intent = intent3;
                Intrinsics.checkNotNullExpressionValue((Object)intent3, (String)"{\n                Intent\u2026ackageName)\n            }");
                break;
            }
            case 3: {
                Intent intent4 = new Intent("com.braze.push.intent.NOTIFICATION_DELETED").setPackage(context.getPackageName());
                intent = intent4;
                Intrinsics.checkNotNullExpressionValue((Object)intent4, (String)"{\n                Intent\u2026ackageName)\n            }");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Intent brazePushIntent = intent;
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>(broadcastType){
            final /* synthetic */ BrazeNotificationBroadcastType $broadcastType;
            {
                this.$broadcastType = $broadcastType;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Sending Braze broadcast receiver intent for " + (Object)((Object)this.$broadcastType);
            }
        }), (int)2, null);
        this.sendPushActionIntent(context, brazePushIntent, notificationExtras);
        if (payload != null) {
            BrazeInternal.INSTANCE.publishBrazePushAction(context, broadcastType.getBrazePushEventType(), payload);
        }
    }

    static /* synthetic */ void sendPushActionIntent$default(BrazeNotificationUtils brazeNotificationUtils, Context context, BrazeNotificationBroadcastType brazeNotificationBroadcastType, Bundle bundle, BrazeNotificationPayload brazeNotificationPayload, int n, Object object) {
        if ((n & 8) != 0) {
            brazeNotificationPayload = null;
        }
        brazeNotificationUtils.sendPushActionIntent(context, brazeNotificationBroadcastType, bundle, brazeNotificationPayload);
    }

    private final void sendPushActionIntent(Context context, Intent pushIntent, Bundle notificationExtras) {
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>(pushIntent){
            final /* synthetic */ Intent $pushIntent;
            {
                this.$pushIntent = $pushIntent;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Sending push action intent: " + this.$pushIntent;
            }
        }), (int)2, null);
        if (notificationExtras != null) {
            pushIntent.putExtras(notificationExtras);
        }
        IntentUtils.addComponentAndSendBroadcast((Context)context, (Intent)pushIntent);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/braze/push/BrazeNotificationUtils$BrazeNotificationBroadcastType;", "", "brazePushEventType", "Lcom/braze/enums/BrazePushEventType;", "(Ljava/lang/String;ILcom/braze/enums/BrazePushEventType;)V", "getBrazePushEventType", "()Lcom/braze/enums/BrazePushEventType;", "OPENED", "RECEIVED", "DELETED", "android-sdk-ui_release"})
    private static final class BrazeNotificationBroadcastType
    extends Enum<BrazeNotificationBroadcastType> {
        @NotNull
        private final BrazePushEventType brazePushEventType;
        public static final /* enum */ BrazeNotificationBroadcastType OPENED = new BrazeNotificationBroadcastType(BrazePushEventType.NOTIFICATION_OPENED);
        public static final /* enum */ BrazeNotificationBroadcastType RECEIVED = new BrazeNotificationBroadcastType(BrazePushEventType.NOTIFICATION_RECEIVED);
        public static final /* enum */ BrazeNotificationBroadcastType DELETED = new BrazeNotificationBroadcastType(BrazePushEventType.NOTIFICATION_DELETED);
        private static final /* synthetic */ BrazeNotificationBroadcastType[] $VALUES;

        private BrazeNotificationBroadcastType(BrazePushEventType brazePushEventType) {
            this.brazePushEventType = brazePushEventType;
        }

        @NotNull
        public final BrazePushEventType getBrazePushEventType() {
            return this.brazePushEventType;
        }

        public static BrazeNotificationBroadcastType[] values() {
            return (BrazeNotificationBroadcastType[])$VALUES.clone();
        }

        public static BrazeNotificationBroadcastType valueOf(String value) {
            return Enum.valueOf(BrazeNotificationBroadcastType.class, value);
        }

        static {
            $VALUES = brazeNotificationBroadcastTypeArray = new BrazeNotificationBroadcastType[]{BrazeNotificationBroadcastType.OPENED, BrazeNotificationBroadcastType.RECEIVED, BrazeNotificationBroadcastType.DELETED};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BrazeNotificationBroadcastType.values().length];
            try {
                nArray[BrazeNotificationBroadcastType.OPENED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BrazeNotificationBroadcastType.RECEIVED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BrazeNotificationBroadcastType.DELETED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

