/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.actions;

import android.annotation.SuppressLint;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import com.braze.IBrazeDeeplinkHandler;
import com.braze.configuration.BrazeConfigurationProvider;
import com.braze.enums.Channel;
import com.braze.support.BrazeFileUtils;
import com.braze.support.BrazeLogger;
import com.braze.ui.BrazeDeeplinkHandler;
import com.braze.ui.BrazeWebViewActivity;
import com.braze.ui.actions.IAction;
import com.braze.ui.actions.UriAction;
import com.braze.ui.actions.brazeactions.BrazeActionParser;
import com.braze.ui.support.UriUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0005J5\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0007\u00a2\u0006\u0002\u0010$J\"\u0010%\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0004J\"\u0010&\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0014J\"\u0010'\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0004J\"\u0010(\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0004J\"\u0010)\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0004R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006*"}, d2={"Lcom/braze/ui/actions/UriAction;", "Lcom/braze/ui/actions/IAction;", "uri", "Landroid/net/Uri;", "extras", "Landroid/os/Bundle;", "useWebView", "", "channel", "Lcom/braze/enums/Channel;", "(Landroid/net/Uri;Landroid/os/Bundle;ZLcom/braze/enums/Channel;)V", "original", "(Lcom/braze/ui/actions/UriAction;)V", "getChannel", "()Lcom/braze/enums/Channel;", "getExtras", "()Landroid/os/Bundle;", "getUri", "()Landroid/net/Uri;", "setUri", "(Landroid/net/Uri;)V", "getUseWebView", "()Z", "setUseWebView", "(Z)V", "execute", "", "context", "Landroid/content/Context;", "getActionViewIntent", "Landroid/content/Intent;", "getIntentArrayWithConfiguredBackStack", "", "targetIntent", "configurationProvider", "Lcom/braze/configuration/BrazeConfigurationProvider;", "(Landroid/content/Context;Landroid/os/Bundle;Landroid/content/Intent;Lcom/braze/configuration/BrazeConfigurationProvider;)[Landroid/content/Intent;", "getWebViewActivityIntent", "openUriWithActionView", "openUriWithActionViewFromPush", "openUriWithWebViewActivity", "openUriWithWebViewActivityFromPush", "android-sdk-ui_release"})
public class UriAction
implements IAction {
    @Nullable
    private final Bundle extras;
    @NotNull
    private final Channel channel;
    @NotNull
    private Uri uri;
    private boolean useWebView;

    @Nullable
    public final Bundle getExtras() {
        return this.extras;
    }

    @Override
    @NotNull
    public Channel getChannel() {
        return this.channel;
    }

    @NotNull
    public final Uri getUri() {
        return this.uri;
    }

    public final void setUri(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"<set-?>");
        this.uri = uri;
    }

    public final boolean getUseWebView() {
        return this.useWebView;
    }

    public final void setUseWebView(boolean bl) {
        this.useWebView = bl;
    }

    public UriAction(@NotNull Uri uri, @Nullable Bundle extras, boolean useWebView, @NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.uri = uri;
        this.extras = extras;
        this.useWebView = useWebView;
        this.channel = channel;
    }

    public UriAction(@NotNull UriAction original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        this.uri = original.uri;
        this.extras = original.extras;
        this.useWebView = original.useWebView;
        this.channel = original.getChannel();
    }

    @Override
    public void execute(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (BrazeFileUtils.isLocalUri((Uri)this.uri)) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ UriAction this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Not executing local Uri: " + this.this$0.getUri();
                }
            }), (int)3, null);
            return;
        }
        if (BrazeActionParser.INSTANCE.isBrazeActionUri(this.uri)) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ UriAction this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Executing BrazeActions uri:\n'" + this.this$0.getUri() + '\'';
                }
            }), (int)2, null);
            BrazeActionParser.INSTANCE.execute(context, this.uri, this.getChannel());
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ UriAction this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Executing Uri action from channel " + this.this$0.getChannel() + ": " + this.this$0.getUri() + ". UseWebView: " + this.this$0.getUseWebView() + ". Extras: " + this.this$0.getExtras();
                }
            }), (int)3, null);
            if (this.useWebView && CollectionsKt.contains((Iterable)BrazeFileUtils.REMOTE_SCHEMES, (Object)this.uri.getScheme())) {
                if (this.getChannel() == Channel.PUSH) {
                    this.openUriWithWebViewActivityFromPush(context, this.uri, this.extras);
                } else {
                    this.openUriWithWebViewActivity(context, this.uri, this.extras);
                }
            } else if (this.getChannel() == Channel.PUSH) {
                this.openUriWithActionViewFromPush(context, this.uri, this.extras);
            } else {
                this.openUriWithActionView(context, this.uri, this.extras);
            }
        }
    }

    protected final void openUriWithWebViewActivity(@NotNull Context context, @NotNull Uri uri, @Nullable Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intent intent = this.getWebViewActivityIntent(context, uri, extras);
        intent.setFlags(BrazeDeeplinkHandler.Companion.getInstance().getIntentFlags(IBrazeDeeplinkHandler.IntentFlagPurpose.URI_ACTION_OPEN_WITH_WEBVIEW_ACTIVITY));
        try {
            context.startActivity(intent);
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)this, BrazeLogger.Priority.E, (Throwable)e, (Function0)openUriWithWebViewActivity.1.INSTANCE);
        }
    }

    protected void openUriWithActionView(@NotNull Context context, @NotNull Uri uri, @Nullable Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intent intent = this.getActionViewIntent(context, uri, extras);
        intent.setFlags(BrazeDeeplinkHandler.Companion.getInstance().getIntentFlags(IBrazeDeeplinkHandler.IntentFlagPurpose.URI_ACTION_OPEN_WITH_ACTION_VIEW));
        try {
            context.startActivity(intent);
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)this, BrazeLogger.Priority.E, (Throwable)e, (Function0)new Function0<String>(uri, extras){
                final /* synthetic */ Uri $uri;
                final /* synthetic */ Bundle $extras;
                {
                    this.$uri = $uri;
                    this.$extras = $extras;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Failed to handle uri " + this.$uri + " with extras: " + this.$extras;
                }
            });
        }
    }

    protected final void openUriWithWebViewActivityFromPush(@NotNull Context context, @NotNull Uri uri, @Nullable Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        BrazeConfigurationProvider configurationProvider = new BrazeConfigurationProvider(context);
        try {
            Intent webViewIntent = this.getWebViewActivityIntent(context, uri, extras);
            context.startActivities(this.getIntentArrayWithConfiguredBackStack(context, extras, webViewIntent, configurationProvider));
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)this, BrazeLogger.Priority.E, (Throwable)e, (Function0)openUriWithWebViewActivityFromPush.1.INSTANCE);
        }
    }

    protected final void openUriWithActionViewFromPush(@NotNull Context context, @NotNull Uri uri, @Nullable Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        BrazeConfigurationProvider configurationProvider = new BrazeConfigurationProvider(context);
        try {
            Intent uriIntent = this.getActionViewIntent(context, uri, extras);
            context.startActivities(this.getIntentArrayWithConfiguredBackStack(context, extras, uriIntent, configurationProvider));
        }
        catch (ActivityNotFoundException e) {
            BrazeLogger.INSTANCE.brazelog((Object)this, BrazeLogger.Priority.W, (Throwable)e, (Function0)new Function0<String>(uri){
                final /* synthetic */ Uri $uri;
                {
                    this.$uri = $uri;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Could not find appropriate activity to open for deep link " + this.$uri;
                }
            });
        }
    }

    @NotNull
    protected final Intent getWebViewActivityIntent(@NotNull Context context, @NotNull Uri uri, @Nullable Bundle extras) {
        Intent webViewActivityIntent2;
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        BrazeConfigurationProvider configurationProvider = new BrazeConfigurationProvider(context);
        String customWebViewActivityClassName = configurationProvider.getCustomHtmlWebViewActivityClassName();
        CharSequence charSequence = customWebViewActivityClassName;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && UriUtils.isActivityRegisteredInManifest(context, customWebViewActivityClassName)) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)((Function0)new Function0<String>(customWebViewActivityClassName){
                final /* synthetic */ String $customWebViewActivityClassName;
                {
                    this.$customWebViewActivityClassName = $customWebViewActivityClassName;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Launching custom WebView Activity with class name: " + this.$customWebViewActivityClassName;
                }
            }), (int)3, null);
            Intent intent2 = new Intent().setClassName(context, customWebViewActivityClassName);
            intent = intent2;
            Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"customWebViewActivityCla\u2026ivityClassName)\n        }");
        } else {
            intent = webViewActivityIntent2 = new Intent(context, BrazeWebViewActivity.class);
        }
        if (extras != null) {
            webViewActivityIntent2.putExtras(extras);
        }
        webViewActivityIntent2.putExtra("url", uri.toString());
        return webViewActivityIntent2;
    }

    @SuppressLint(value={"QueryPermissionsNeeded"})
    @NotNull
    protected final Intent getActionViewIntent(@NotNull Context context, @NotNull Uri uri, @Nullable Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(uri);
        if (extras != null) {
            intent.putExtras(extras);
        }
        List list = Build.VERSION.SDK_INT >= 33 ? context.getPackageManager().queryIntentActivities(intent, PackageManager.ResolveInfoFlags.of((long)0L)) : context.getPackageManager().queryIntentActivities(intent, 0);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"if (Build.VERSION.SDK_IN\u2026ties(intent, 0)\n        }");
        List resolveInfos = list;
        if (resolveInfos.size() > 1) {
            for (ResolveInfo resolveInfo : resolveInfos) {
                if (!Intrinsics.areEqual((Object)resolveInfo.activityInfo.packageName, (Object)context.getPackageName())) continue;
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)((Function0)new Function0<String>(resolveInfo){
                    final /* synthetic */ ResolveInfo $resolveInfo;
                    {
                        this.$resolveInfo = $resolveInfo;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Setting deep link intent package to " + this.$resolveInfo.activityInfo.packageName + '.';
                    }
                }), (int)3, null);
                intent.setPackage(resolveInfo.activityInfo.packageName);
                break;
            }
        }
        return intent;
    }

    @VisibleForTesting
    @NotNull
    public final Intent[] getIntentArrayWithConfiguredBackStack(@NotNull Context context, @Nullable Bundle extras, @NotNull Intent targetIntent, @NotNull BrazeConfigurationProvider configurationProvider) {
        Intent[] intentArray;
        Intent[] intentArray2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)targetIntent, (String)"targetIntent");
        Intrinsics.checkNotNullParameter((Object)configurationProvider, (String)"configurationProvider");
        Intent rootIntent = null;
        if (configurationProvider.isPushDeepLinkBackStackActivityEnabled()) {
            String activityClass = configurationProvider.getPushDeepLinkBackStackActivityClassName();
            CharSequence charSequence = activityClass;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)getIntentArrayWithConfiguredBackStack.1.INSTANCE, (int)2, null);
                rootIntent = UriUtils.getMainActivityIntent(context, extras);
            } else if (UriUtils.isActivityRegisteredInManifest(context, activityClass)) {
                Intent intent;
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)((Function0)new Function0<String>(activityClass){
                    final /* synthetic */ String $activityClass;
                    {
                        this.$activityClass = $activityClass;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Adding custom back stack activity while opening uri from push: " + this.$activityClass;
                    }
                }), (int)2, null);
                Bundle bundle = extras;
                if (bundle != null) {
                    Bundle it = bundle;
                    boolean bl = false;
                    intent = new Intent().setClassName(context, activityClass).setFlags(BrazeDeeplinkHandler.Companion.getInstance().getIntentFlags(IBrazeDeeplinkHandler.IntentFlagPurpose.URI_ACTION_BACK_STACK_GET_ROOT_INTENT)).putExtras(it);
                } else {
                    intent = null;
                }
                rootIntent = intent;
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)((Function0)new Function0<String>(activityClass){
                    final /* synthetic */ String $activityClass;
                    {
                        this.$activityClass = $activityClass;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Not adding unregistered activity to the back stack while opening uri from push: " + this.$activityClass;
                    }
                }), (int)2, null);
            }
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)getIntentArrayWithConfiguredBackStack.5.INSTANCE, (int)2, null);
        }
        if (rootIntent == null) {
            targetIntent.setFlags(BrazeDeeplinkHandler.Companion.getInstance().getIntentFlags(IBrazeDeeplinkHandler.IntentFlagPurpose.URI_ACTION_BACK_STACK_ONLY_GET_TARGET_INTENT));
            intentArray2 = new Intent[]{targetIntent};
            intentArray = intentArray2;
        } else {
            intentArray2 = new Intent[]{rootIntent, targetIntent};
            intentArray = intentArray2;
        }
        return intentArray;
    }
}

