/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.actions.brazeactions;

import android.content.Context;
import android.net.Uri;
import android.util.Base64;
import com.braze.enums.Channel;
import com.braze.support.BrazeLogger;
import com.braze.support.JsonUtils;
import com.braze.ui.actions.brazeactions.BrazeActionParser;
import com.braze.ui.actions.brazeactions.steps.AddToCustomAttributeArrayStep;
import com.braze.ui.actions.brazeactions.steps.AddToSubscriptionGroupStep;
import com.braze.ui.actions.brazeactions.steps.ContainerStep;
import com.braze.ui.actions.brazeactions.steps.IBrazeActionStep;
import com.braze.ui.actions.brazeactions.steps.LogCustomEventStep;
import com.braze.ui.actions.brazeactions.steps.NoOpStep;
import com.braze.ui.actions.brazeactions.steps.OpenLinkExternallyStep;
import com.braze.ui.actions.brazeactions.steps.OpenLinkInWebViewStep;
import com.braze.ui.actions.brazeactions.steps.RemoveFromCustomAttributeArrayStep;
import com.braze.ui.actions.brazeactions.steps.RequestPushPermissionStep;
import com.braze.ui.actions.brazeactions.steps.SetCustomUserAttributeStep;
import com.braze.ui.actions.brazeactions.steps.SetEmailSubscriptionStep;
import com.braze.ui.actions.brazeactions.steps.SetPushNotificationSubscriptionStep;
import com.braze.ui.actions.brazeactions.steps.StepData;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u001d\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0019J\u001f\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u001b*\u00020\fH\u0000\u00a2\u0006\u0002\b\u001cJ\f\u0010\u001d\u001a\u00020\u001e*\u0004\u0018\u00010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/braze/ui/actions/brazeactions/BrazeActionParser;", "", "()V", "BRAZE_ACTIONS_SCHEME", "", "BRAZE_ACTIONS_V1", "TYPE", "execute", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "channel", "Lcom/braze/enums/Channel;", "getActionType", "Lcom/braze/ui/actions/brazeactions/BrazeActionParser$ActionType;", "data", "Lcom/braze/ui/actions/brazeactions/steps/StepData;", "getActionType$android_sdk_ui_release", "parse", "parse$android_sdk_ui_release", "parseEncodedActionToJson", "Lorg/json/JSONObject;", "action", "parseEncodedActionToJson$android_sdk_ui_release", "getBrazeActionVersionAndJson", "Lkotlin/Pair;", "getBrazeActionVersionAndJson$android_sdk_ui_release", "isBrazeActionUri", "", "ActionType", "android-sdk-ui_release"})
public final class BrazeActionParser {
    @NotNull
    public static final BrazeActionParser INSTANCE = new BrazeActionParser();
    @NotNull
    private static final String BRAZE_ACTIONS_V1 = "v1";
    @NotNull
    public static final String TYPE = "type";
    @NotNull
    public static final String BRAZE_ACTIONS_SCHEME = "brazeActions";

    private BrazeActionParser() {
    }

    public final boolean isBrazeActionUri(@Nullable Uri $this$isBrazeActionUri) {
        Uri uri = $this$isBrazeActionUri;
        return Intrinsics.areEqual((Object)(uri != null ? uri.getScheme() : null), (Object)BRAZE_ACTIONS_SCHEME);
    }

    public final void execute(@NotNull Context context, @NotNull Uri uri, @NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>(channel, uri){
            final /* synthetic */ Channel $channel;
            final /* synthetic */ Uri $uri;
            {
                this.$channel = $channel;
                this.$uri = $uri;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Attempting to parse Braze Action with channel " + this.$channel + " and uri:\n'" + this.$uri + '\'';
            }
        }), (int)2, null);
        try {
            Pair components = this.getBrazeActionVersionAndJson$android_sdk_ui_release(uri);
            if (components == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (Function0)execute.2.INSTANCE, (int)2, null);
                return;
            }
            String version = (String)components.component1();
            JSONObject json2 = (JSONObject)components.component2();
            if (!Intrinsics.areEqual((Object)version, (Object)BRAZE_ACTIONS_V1)) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)((Function0)new Function0<String>(version){
                    final /* synthetic */ String $version;
                    {
                        this.$version = $version;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Braze Actions version " + this.$version + " is unsupported. Version must be v1";
                    }
                }), (int)3, null);
                return;
            }
            this.parse$android_sdk_ui_release(context, new StepData(json2, channel));
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)this, BrazeLogger.Priority.E, (Throwable)e, (Function0)new Function0<String>(uri){
                final /* synthetic */ Uri $uri;
                {
                    this.$uri = $uri;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Failed to parse uri as a Braze Action.\n'" + this.$uri + '\'';
                }
            });
        }
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>(uri){
            final /* synthetic */ Uri $uri;
            {
                this.$uri = $uri;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Done handling Braze uri\n'" + this.$uri + '\'';
            }
        }), (int)2, null);
    }

    public static /* synthetic */ void execute$default(BrazeActionParser brazeActionParser, Context context, Uri uri, Channel channel, int n, Object object) {
        if ((n & 4) != 0) {
            channel = Channel.UNKNOWN;
        }
        brazeActionParser.execute(context, uri, channel);
    }

    public final /* synthetic */ void parse$android_sdk_ui_release(Context context, StepData data) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            ActionType actionType = this.getActionType$android_sdk_ui_release(data);
            if (actionType == ActionType.INVALID) {
                return;
            }
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>(actionType, data){
                final /* synthetic */ ActionType $actionType;
                final /* synthetic */ StepData $data;
                {
                    this.$actionType = $actionType;
                    this.$data = $data;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Performing Braze Action type " + (Object)((Object)this.$actionType) + " with data " + this.$data;
                }
            }), (int)2, null);
            actionType.getImpl().run(context, data);
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)this, BrazeLogger.Priority.E, (Throwable)e, (Function0)new Function0<String>(data){
                final /* synthetic */ StepData $data;
                {
                    this.$data = $data;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Failed to run with data " + this.$data;
                }
            });
        }
    }

    public final /* synthetic */ JSONObject parseEncodedActionToJson$android_sdk_ui_release(String action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        byte[] byArray = Base64.decode((String)action, (int)8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(action, Base64.URL_SAFE)");
        byte[] bytes8 = byArray;
        int[] bit16 = new int[bytes8.length / 2];
        int n = bytes8.length + -1;
        int i = 0;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)2);
        if (i <= n2) {
            while (true) {
                int combined;
                int lowerByte = bytes8[i] & 0xFF;
                int upperByte = (bytes8[i + 1] & 0xFF) << 8;
                bit16[i / 2] = combined = upperByte | lowerByte;
                if (i == n2) break;
                i += 2;
            }
        }
        StringBuilder result = new StringBuilder();
        for (int code : bit16) {
            if (code < 0 || code > 65535) {
                throw new IllegalArgumentException("Invalid Char code: " + code);
            }
            result.append((char)code);
        }
        return new JSONObject(result.toString());
    }

    public final /* synthetic */ Pair getBrazeActionVersionAndJson$android_sdk_ui_release(Uri $this$getBrazeActionVersionAndJson) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)$this$getBrazeActionVersionAndJson, (String)"<this>");
        String version = $this$getBrazeActionVersionAndJson.getHost();
        String encodedAction = $this$getBrazeActionVersionAndJson.getLastPathSegment();
        if (version == null || encodedAction == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)$this$getBrazeActionVersionAndJson, null, null, (Function0)((Function0)new Function0<String>($this$getBrazeActionVersionAndJson){
                final /* synthetic */ Uri $this_getBrazeActionVersionAndJson;
                {
                    this.$this_getBrazeActionVersionAndJson = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Failed to parse version and encoded action from uri: " + this.$this_getBrazeActionVersionAndJson;
                }
            }), (int)3, null);
            return null;
        }
        try {
            jSONObject = this.parseEncodedActionToJson$android_sdk_ui_release(encodedAction);
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog((Object)$this$getBrazeActionVersionAndJson, BrazeLogger.Priority.E, (Throwable)e, (Function0)new Function0<String>(encodedAction){
                final /* synthetic */ String $encodedAction;
                {
                    this.$encodedAction = $encodedAction;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Failed to decode action into json. Action:\n'" + this.$encodedAction + '\'';
                }
            });
            jSONObject = null;
        }
        JSONObject jSONObject2 = jSONObject;
        if (jSONObject2 == null) {
            return null;
        }
        JSONObject json2 = jSONObject2;
        return new Pair((Object)version, (Object)json2);
    }

    public final /* synthetic */ ActionType getActionType$android_sdk_ui_release(StepData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ActionType type = ActionType.Companion.fromValue(JsonUtils.getOptionalString((JSONObject)data.getSrcJson(), (String)TYPE));
        boolean isValid = type.getImpl().isValid(data);
        if (!isValid) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)((Function0)new Function0<String>(type, data){
                final /* synthetic */ ActionType $type;
                final /* synthetic */ StepData $data;
                {
                    this.$type = $type;
                    this.$data = $data;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Cannot parse invalid action of type " + (Object)((Object)this.$type) + " and data " + this.$data;
                }
            }), (int)3, null);
            return ActionType.INVALID;
        }
        return type;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0080\u0001\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0018B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017\u00a8\u0006\u0019"}, d2={"Lcom/braze/ui/actions/brazeactions/BrazeActionParser$ActionType;", "", "key", "", "impl", "Lcom/braze/ui/actions/brazeactions/steps/IBrazeActionStep;", "(Ljava/lang/String;ILjava/lang/String;Lcom/braze/ui/actions/brazeactions/steps/IBrazeActionStep;)V", "getImpl", "()Lcom/braze/ui/actions/brazeactions/steps/IBrazeActionStep;", "getKey", "()Ljava/lang/String;", "CONTAINER", "LOG_CUSTOM_EVENT", "SET_CUSTOM_ATTRIBUTE", "REQUEST_PUSH_PERMISSION", "ADD_TO_SUBSCRIPTION_GROUP", "REMOVE_FROM_SUBSCRIPTION_GROUP", "ADD_TO_CUSTOM_ATTRIBUTE_ARRAY", "REMOVE_FROM_CUSTOM_ATTRIBUTE_ARRAY", "SET_EMAIL_SUBSCRIPTION", "SET_PUSH_NOTIFICATION_SUBSCRIPTION", "OPEN_LINK_IN_WEBVIEW", "OPEN_LINK_EXTERNALLY", "INVALID", "Companion", "android-sdk-ui_release"})
    @SourceDebugExtension(value={"SMAP\nBrazeActionParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrazeActionParser.kt\ncom/braze/ui/actions/brazeactions/BrazeActionParser$ActionType\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,190:1\n8811#2,2:191\n9071#2,4:193\n*S KotlinDebug\n*F\n+ 1 BrazeActionParser.kt\ncom/braze/ui/actions/brazeactions/BrazeActionParser$ActionType\n*L\n49#1:191,2\n49#1:193,4\n*E\n"})
    public static final class ActionType
    extends Enum<ActionType> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String key;
        @NotNull
        private final IBrazeActionStep impl;
        @NotNull
        private static final Map<String, ActionType> map;
        public static final /* enum */ ActionType CONTAINER;
        public static final /* enum */ ActionType LOG_CUSTOM_EVENT;
        public static final /* enum */ ActionType SET_CUSTOM_ATTRIBUTE;
        public static final /* enum */ ActionType REQUEST_PUSH_PERMISSION;
        public static final /* enum */ ActionType ADD_TO_SUBSCRIPTION_GROUP;
        public static final /* enum */ ActionType REMOVE_FROM_SUBSCRIPTION_GROUP;
        public static final /* enum */ ActionType ADD_TO_CUSTOM_ATTRIBUTE_ARRAY;
        public static final /* enum */ ActionType REMOVE_FROM_CUSTOM_ATTRIBUTE_ARRAY;
        public static final /* enum */ ActionType SET_EMAIL_SUBSCRIPTION;
        public static final /* enum */ ActionType SET_PUSH_NOTIFICATION_SUBSCRIPTION;
        public static final /* enum */ ActionType OPEN_LINK_IN_WEBVIEW;
        public static final /* enum */ ActionType OPEN_LINK_EXTERNALLY;
        public static final /* enum */ ActionType INVALID;
        private static final /* synthetic */ ActionType[] $VALUES;

        private ActionType(String key, IBrazeActionStep impl) {
            this.key = key;
            this.impl = impl;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final IBrazeActionStep getImpl() {
            return this.impl;
        }

        public static ActionType[] values() {
            return (ActionType[])$VALUES.clone();
        }

        public static ActionType valueOf(String value) {
            return Enum.valueOf(ActionType.class, value);
        }

        @JvmStatic
        @NotNull
        public static final ActionType fromValue(@Nullable String value) {
            return Companion.fromValue(value);
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$associateByTo$iv$iv;
            CONTAINER = new ActionType("container", ContainerStep.INSTANCE);
            LOG_CUSTOM_EVENT = new ActionType("logCustomEvent", LogCustomEventStep.INSTANCE);
            SET_CUSTOM_ATTRIBUTE = new ActionType("setCustomUserAttribute", SetCustomUserAttributeStep.INSTANCE);
            REQUEST_PUSH_PERMISSION = new ActionType("requestPushPermission", RequestPushPermissionStep.INSTANCE);
            ADD_TO_SUBSCRIPTION_GROUP = new ActionType("addToSubscriptionGroup", AddToSubscriptionGroupStep.INSTANCE);
            REMOVE_FROM_SUBSCRIPTION_GROUP = new ActionType("removeFromSubscriptionGroup", AddToSubscriptionGroupStep.INSTANCE);
            ADD_TO_CUSTOM_ATTRIBUTE_ARRAY = new ActionType("addToCustomAttributeArray", AddToCustomAttributeArrayStep.INSTANCE);
            REMOVE_FROM_CUSTOM_ATTRIBUTE_ARRAY = new ActionType("removeFromCustomAttributeArray", RemoveFromCustomAttributeArrayStep.INSTANCE);
            SET_EMAIL_SUBSCRIPTION = new ActionType("setEmailNotificationSubscriptionType", SetEmailSubscriptionStep.INSTANCE);
            SET_PUSH_NOTIFICATION_SUBSCRIPTION = new ActionType("setPushNotificationSubscriptionType", SetPushNotificationSubscriptionStep.INSTANCE);
            OPEN_LINK_IN_WEBVIEW = new ActionType("openLinkInWebview", OpenLinkInWebViewStep.INSTANCE);
            OPEN_LINK_EXTERNALLY = new ActionType("openLink", OpenLinkExternallyStep.INSTANCE);
            INVALID = new ActionType("", NoOpStep.INSTANCE);
            $VALUES = actionTypeArray = new ActionType[]{ActionType.CONTAINER, ActionType.LOG_CUSTOM_EVENT, ActionType.SET_CUSTOM_ATTRIBUTE, ActionType.REQUEST_PUSH_PERMISSION, ActionType.ADD_TO_SUBSCRIPTION_GROUP, ActionType.REMOVE_FROM_SUBSCRIPTION_GROUP, ActionType.ADD_TO_CUSTOM_ATTRIBUTE_ARRAY, ActionType.REMOVE_FROM_CUSTOM_ATTRIBUTE_ARRAY, ActionType.SET_EMAIL_SUBSCRIPTION, ActionType.SET_PUSH_NOTIFICATION_SUBSCRIPTION, ActionType.OPEN_LINK_IN_WEBVIEW, ActionType.OPEN_LINK_EXTERNALLY, ActionType.INVALID};
            Companion = new Companion(null);
            ActionType[] $this$associateBy$iv = ActionType.values();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
            ActionType[] actionTypeArray = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            int n = ((void)$this$associateByTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void element$iv$iv;
                void var9_9 = element$iv$iv = $this$associateByTo$iv$iv[i];
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(it.key, element$iv$iv);
            }
            map = destination$iv$iv;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/braze/ui/actions/brazeactions/BrazeActionParser$ActionType$Companion;", "", "()V", "map", "", "", "Lcom/braze/ui/actions/brazeactions/BrazeActionParser$ActionType;", "fromValue", "value", "android-sdk-ui_release"})
        @SourceDebugExtension(value={"SMAP\nBrazeActionParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrazeActionParser.kt\ncom/braze/ui/actions/brazeactions/BrazeActionParser$ActionType$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final ActionType fromValue(@Nullable String value) {
                String string;
                Object object;
                Map map = map;
                String string2 = value;
                if (string2 == null) {
                    string2 = "";
                }
                if ((object = map.get(string = string2)) == null) {
                    boolean bl = false;
                    object = INVALID;
                }
                return (ActionType)((Object)object);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

