/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.contentcards.recycler;

import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.braze.ui.R;
import com.braze.ui.contentcards.adapters.ContentCardAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007H\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/braze/ui/contentcards/recycler/ContentCardsDividerItemDecoration;", "Landroidx/recyclerview/widget/RecyclerView$ItemDecoration;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "appContext", "contentCardsItemMaxWidth", "", "itemDividerHeight", "getItemOffsets", "", "itemViewOutputRect", "Landroid/graphics/Rect;", "view", "Landroid/view/View;", "parent", "Landroidx/recyclerview/widget/RecyclerView;", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "getSidePaddingValue", "parentWidth", "android-sdk-ui_release"})
public class ContentCardsDividerItemDecoration
extends RecyclerView.ItemDecoration {
    @NotNull
    private final Context appContext;
    private final int itemDividerHeight;
    private final int contentCardsItemMaxWidth;

    public ContentCardsDividerItemDecoration(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this.appContext = context2;
        this.itemDividerHeight = this.appContext.getResources().getDimensionPixelSize(R.dimen.com_braze_content_cards_divider_height);
        this.contentCardsItemMaxWidth = this.appContext.getResources().getDimensionPixelSize(R.dimen.com_braze_content_cards_max_width);
    }

    public void getItemOffsets(@NotNull Rect itemViewOutputRect, @NotNull View view, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        int sidePadding;
        Intrinsics.checkNotNullParameter((Object)itemViewOutputRect, (String)"itemViewOutputRect");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.getItemOffsets(itemViewOutputRect, view, parent, state);
        int childAdapterPosition = parent.getChildAdapterPosition(view);
        boolean isControlCard = false;
        if (parent.getAdapter() instanceof ContentCardAdapter) {
            RecyclerView.Adapter adapter = parent.getAdapter();
            Intrinsics.checkNotNull((Object)adapter, (String)"null cannot be cast to non-null type com.braze.ui.contentcards.adapters.ContentCardAdapter");
            ContentCardAdapter cardAdapter = (ContentCardAdapter)adapter;
            isControlCard = cardAdapter.isControlCardAtPosition(childAdapterPosition);
        }
        itemViewOutputRect.top = childAdapterPosition == 0 ? this.itemDividerHeight : 0;
        itemViewOutputRect.bottom = isControlCard ? 0 : this.itemDividerHeight;
        itemViewOutputRect.left = sidePadding = this.getSidePaddingValue(parent.getWidth());
        itemViewOutputRect.right = sidePadding;
    }

    private final int getSidePaddingValue(int parentWidth) {
        int padding = (parentWidth - this.contentCardsItemMaxWidth) / 2;
        return RangesKt.coerceAtLeast((int)padding, (int)0);
    }
}

