/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.inappmessage.listeners;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import com.braze.Braze;
import com.braze.enums.Channel;
import com.braze.enums.inappmessage.MessageType;
import com.braze.models.inappmessage.IInAppMessage;
import com.braze.models.inappmessage.IInAppMessageHtml;
import com.braze.models.outgoing.BrazeProperties;
import com.braze.support.BrazeFileUtils;
import com.braze.support.BrazeLogger;
import com.braze.support.BundleUtils;
import com.braze.ui.BrazeDeeplinkHandler;
import com.braze.ui.actions.NewsfeedAction;
import com.braze.ui.actions.UriAction;
import com.braze.ui.inappmessage.BrazeInAppMessageManager;
import com.braze.ui.inappmessage.listeners.DefaultInAppMessageWebViewClientListener;
import com.braze.ui.inappmessage.listeners.IInAppMessageWebViewClientListener;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/braze/ui/inappmessage/listeners/DefaultInAppMessageWebViewClientListener;", "Lcom/braze/ui/inappmessage/listeners/IInAppMessageWebViewClientListener;", "()V", "inAppMessageManager", "Lcom/braze/ui/inappmessage/BrazeInAppMessageManager;", "getInAppMessageManager", "()Lcom/braze/ui/inappmessage/BrazeInAppMessageManager;", "onCloseAction", "", "inAppMessage", "Lcom/braze/models/inappmessage/IInAppMessage;", "url", "", "queryBundle", "Landroid/os/Bundle;", "onCustomEventAction", "onNewsfeedAction", "onOtherUrlAction", "Companion", "android-sdk-ui_release"})
public class DefaultInAppMessageWebViewClientListener
implements IInAppMessageWebViewClientListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String HTML_IN_APP_MESSAGE_CUSTOM_EVENT_NAME_KEY = "name";

    private final BrazeInAppMessageManager getInAppMessageManager() {
        return BrazeInAppMessageManager.Companion.getInstance();
    }

    @Override
    public void onCloseAction(@NotNull IInAppMessage inAppMessage, @NotNull String url, @NotNull Bundle queryBundle) {
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)queryBundle, (String)"queryBundle");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)onCloseAction.1.INSTANCE, (int)3, null);
        Companion.logHtmlInAppMessageClick(inAppMessage, queryBundle);
        this.getInAppMessageManager().hideCurrentlyDisplayingInAppMessage(true);
        this.getInAppMessageManager().getHtmlInAppMessageActionListener().onCloseClicked(inAppMessage, url, queryBundle);
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)onCloseAction.2.INSTANCE, (int)3, null);
    }

    @Override
    public void onNewsfeedAction(@NotNull IInAppMessage inAppMessage, @NotNull String url, @NotNull Bundle queryBundle) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)queryBundle, (String)"queryBundle");
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)onNewsfeedAction.1.INSTANCE, (int)3, null);
            if (this.getInAppMessageManager().getActivity() == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)onNewsfeedAction.2.INSTANCE, (int)2, null);
                return;
            }
            Companion.logHtmlInAppMessageClick(inAppMessage, queryBundle);
            boolean wasHandled2 = this.getInAppMessageManager().getHtmlInAppMessageActionListener().onNewsfeedClicked(inAppMessage, url, queryBundle);
            if (wasHandled2) break block2;
            inAppMessage.setAnimateOut(false);
            this.getInAppMessageManager().hideCurrentlyDisplayingInAppMessage(false);
            NewsfeedAction newsfeedAction = new NewsfeedAction(BundleUtils.toBundle((Map)inAppMessage.getExtras()), Channel.INAPP_MESSAGE);
            Activity activity = this.getInAppMessageManager().getActivity();
            if (activity != null) {
                Activity activity2 = activity;
                boolean bl = false;
                BrazeDeeplinkHandler.Companion.getInstance().gotoNewsFeed((Context)activity2, newsfeedAction);
            }
        }
    }

    @Override
    public void onCustomEventAction(@NotNull IInAppMessage inAppMessage, @NotNull String url, @NotNull Bundle queryBundle) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)queryBundle, (String)"queryBundle");
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)onCustomEventAction.1.INSTANCE, (int)3, null);
            if (this.getInAppMessageManager().getActivity() == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)onCustomEventAction.2.INSTANCE, (int)2, null);
                return;
            }
            boolean wasHandled2 = this.getInAppMessageManager().getHtmlInAppMessageActionListener().onCustomEventFired(inAppMessage, url, queryBundle);
            if (wasHandled2) break block3;
            String customEventName = Companion.parseCustomEventNameFromQueryBundle(queryBundle);
            CharSequence charSequence = customEventName;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return;
            }
            BrazeProperties customEventProperties = Companion.parsePropertiesFromQueryBundle(queryBundle);
            Activity activity = this.getInAppMessageManager().getActivity();
            if (activity != null) {
                Activity activity2 = activity;
                boolean bl = false;
                Braze.Companion.getInstance((Context)activity2).logCustomEvent(customEventName, customEventProperties);
            }
        }
    }

    @Override
    public void onOtherUrlAction(@NotNull IInAppMessage inAppMessage, @NotNull String url, @NotNull Bundle queryBundle) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)queryBundle, (String)"queryBundle");
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (Function0)onOtherUrlAction.1.INSTANCE, (int)3, null);
            if (this.getInAppMessageManager().getActivity() == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)((Function0)new Function0<String>(url){
                    final /* synthetic */ String $url;
                    {
                        this.$url = $url;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Can't perform other url action because the cached activity is null. Url: " + this.$url;
                    }
                }), (int)2, null);
                return;
            }
            Companion.logHtmlInAppMessageClick(inAppMessage, queryBundle);
            boolean wasHandled2 = this.getInAppMessageManager().getHtmlInAppMessageActionListener().onOtherUrlAction(inAppMessage, url, queryBundle);
            if (wasHandled2) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (Function0)((Function0)new Function0<String>(url){
                    final /* synthetic */ String $url;
                    {
                        this.$url = $url;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "HTML message action listener handled url in onOtherUrlAction. Doing nothing further. Url: " + this.$url;
                    }
                }), (int)2, null);
                return;
            }
            boolean useWebViewForWebLinks = Companion.parseUseWebViewFromQueryBundle(inAppMessage, queryBundle);
            Bundle inAppMessageBundle = BundleUtils.toBundle((Map)inAppMessage.getExtras());
            inAppMessageBundle.putAll(queryBundle);
            UriAction uriAction = BrazeDeeplinkHandler.Companion.getInstance().createUriActionFromUrlString(url, inAppMessageBundle, useWebViewForWebLinks, Channel.INAPP_MESSAGE);
            if (uriAction == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)((Function0)new Function0<String>(url){
                    final /* synthetic */ String $url;
                    {
                        this.$url = $url;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "UriAction is null. Not passing any URI to BrazeDeeplinkHandler. Url: " + this.$url;
                    }
                }), (int)2, null);
                return;
            }
            Uri uri = uriAction.getUri();
            if (BrazeFileUtils.isLocalUri((Uri)uri)) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (Function0)((Function0)new Function0<String>(uri, url){
                    final /* synthetic */ Uri $uri;
                    final /* synthetic */ String $url;
                    {
                        this.$uri = $uri;
                        this.$url = $url;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Not passing local uri to BrazeDeeplinkHandler. Got local uri: " + this.$uri + " for url: " + this.$url;
                    }
                }), (int)2, null);
                return;
            }
            inAppMessage.setAnimateOut(false);
            this.getInAppMessageManager().hideCurrentlyDisplayingInAppMessage(false);
            Activity activity = this.getInAppMessageManager().getActivity();
            if (activity == null) break block4;
            Activity activity2 = activity;
            boolean bl = false;
            BrazeDeeplinkHandler.Companion.getInstance().gotoUri((Context)activity2, uriAction);
        }
    }

    @JvmStatic
    @VisibleForTesting
    public static final boolean parseUseWebViewFromQueryBundle(@NotNull IInAppMessage inAppMessage, @NotNull Bundle queryBundle) {
        return Companion.parseUseWebViewFromQueryBundle(inAppMessage, queryBundle);
    }

    @JvmStatic
    @VisibleForTesting
    public static final void logHtmlInAppMessageClick(@NotNull IInAppMessage inAppMessage, @NotNull Bundle queryBundle) {
        Companion.logHtmlInAppMessageClick(inAppMessage, queryBundle);
    }

    @JvmStatic
    @VisibleForTesting
    @Nullable
    public static final String parseCustomEventNameFromQueryBundle(@NotNull Bundle queryBundle) {
        return Companion.parseCustomEventNameFromQueryBundle(queryBundle);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final BrazeProperties parsePropertiesFromQueryBundle(@NotNull Bundle queryBundle) {
        return Companion.parsePropertiesFromQueryBundle(queryBundle);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/braze/ui/inappmessage/listeners/DefaultInAppMessageWebViewClientListener$Companion;", "", "()V", "HTML_IN_APP_MESSAGE_CUSTOM_EVENT_NAME_KEY", "", "logHtmlInAppMessageClick", "", "inAppMessage", "Lcom/braze/models/inappmessage/IInAppMessage;", "queryBundle", "Landroid/os/Bundle;", "parseCustomEventNameFromQueryBundle", "parsePropertiesFromQueryBundle", "Lcom/braze/models/outgoing/BrazeProperties;", "parseUseWebViewFromQueryBundle", "", "android-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @VisibleForTesting
        public final boolean parseUseWebViewFromQueryBundle(@NotNull IInAppMessage inAppMessage, @NotNull Bundle queryBundle) {
            Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
            Intrinsics.checkNotNullParameter((Object)queryBundle, (String)"queryBundle");
            boolean isAnyQueryFlagSet = false;
            boolean isDeepLinkFlagSet = false;
            if (queryBundle.containsKey("abDeepLink")) {
                isDeepLinkFlagSet = Boolean.parseBoolean(queryBundle.getString("abDeepLink"));
                isAnyQueryFlagSet = true;
            }
            boolean isExternalOpenFlagSet = false;
            if (queryBundle.containsKey("abExternalOpen")) {
                isExternalOpenFlagSet = Boolean.parseBoolean(queryBundle.getString("abExternalOpen"));
                isAnyQueryFlagSet = true;
            }
            boolean useWebViewForWebLinks = inAppMessage.getOpenUriInWebView();
            if (isAnyQueryFlagSet) {
                useWebViewForWebLinks = !isDeepLinkFlagSet && !isExternalOpenFlagSet;
            }
            return useWebViewForWebLinks;
        }

        @JvmStatic
        @VisibleForTesting
        public final void logHtmlInAppMessageClick(@NotNull IInAppMessage inAppMessage, @NotNull Bundle queryBundle) {
            Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
            Intrinsics.checkNotNullParameter((Object)queryBundle, (String)"queryBundle");
            if (queryBundle.containsKey("abButtonId")) {
                IInAppMessageHtml inAppMessageHtml = (IInAppMessageHtml)inAppMessage;
                String string2 = queryBundle.getString("abButtonId");
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    inAppMessageHtml.logButtonClick(it);
                }
            } else if (inAppMessage.getMessageType() == MessageType.HTML_FULL) {
                inAppMessage.logClick();
            }
        }

        @JvmStatic
        @VisibleForTesting
        @Nullable
        public final String parseCustomEventNameFromQueryBundle(@NotNull Bundle queryBundle) {
            Intrinsics.checkNotNullParameter((Object)queryBundle, (String)"queryBundle");
            return queryBundle.getString(DefaultInAppMessageWebViewClientListener.HTML_IN_APP_MESSAGE_CUSTOM_EVENT_NAME_KEY);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final BrazeProperties parsePropertiesFromQueryBundle(@NotNull Bundle queryBundle) {
            Intrinsics.checkNotNullParameter((Object)queryBundle, (String)"queryBundle");
            BrazeProperties customEventProperties = new BrazeProperties();
            for (String key : queryBundle.keySet()) {
                String propertyValue;
                CharSequence charSequence;
                if (Intrinsics.areEqual((Object)key, (Object)DefaultInAppMessageWebViewClientListener.HTML_IN_APP_MESSAGE_CUSTOM_EVENT_NAME_KEY) || (charSequence = (CharSequence)(propertyValue = queryBundle.getString(key, null))) == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                customEventProperties.addProperty(key, (Object)propertyValue);
            }
            return customEventProperties;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

