/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.support;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.core.view.DisplayCutoutCompat;
import androidx.core.view.WindowInsetsCompat;
import com.braze.enums.inappmessage.Orientation;
import com.braze.support.BrazeLogger;
import com.braze.ui.support.ViewUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\u000e\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0001\u001a\n\u0010\u001b\u001a\u00020\u0010*\u00020\u001c\u001a\f\u0010\u001d\u001a\u00020\u0019*\u0004\u0018\u00010\u0017\u001a\u0012\u0010\u001e\u001a\u00020\u0019*\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0001\u001a\n\u0010 \u001a\u00020\u0019*\u00020\u0017\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"TABLET_SMALLEST_WIDTH_DP", "", "TAG", "", "convertDpToPixels", "", "context", "Landroid/content/Context;", "valueInDp", "getMaxSafeBottomInset", "windowInsets", "Landroidx/core/view/WindowInsetsCompat;", "getMaxSafeLeftInset", "getMaxSafeRightInset", "getMaxSafeTopInset", "isCurrentOrientationValid", "", "currentScreenOrientation", "preferredOrientation", "Lcom/braze/enums/inappmessage/Orientation;", "isDeviceInNightMode", "isDeviceNotInTouchMode", "view", "Landroid/view/View;", "setHeightOnViewLayoutParams", "", "height", "isRunningOnTablet", "Landroid/app/Activity;", "removeViewFromParent", "setActivityRequestedOrientation", "requestedOrientation", "setFocusableInTouchModeAndRequestFocus", "android-sdk-ui_release"})
@JvmName(name="ViewUtils")
public final class ViewUtils {
    @NotNull
    private static final String TAG = BrazeLogger.INSTANCE.getBrazeLogTag("ViewUtils");
    private static final int TABLET_SMALLEST_WIDTH_DP = 600;

    public static final void removeViewFromParent(@Nullable View $this$removeViewFromParent) {
        if ($this$removeViewFromParent == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (String)TAG, (BrazeLogger.Priority)BrazeLogger.Priority.D, null, (Function0)removeViewFromParent.1.INSTANCE, (int)4, null);
        }
        View view = $this$removeViewFromParent;
        if ((view != null ? view.getParent() : null) instanceof ViewGroup) {
            ViewParent viewParent = $this$removeViewFromParent.getParent();
            Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.ViewGroup");
            ViewGroup parent = (ViewGroup)viewParent;
            parent.removeView($this$removeViewFromParent);
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (String)TAG, (BrazeLogger.Priority)BrazeLogger.Priority.D, null, (Function0)((Function0)new Function0<String>($this$removeViewFromParent, parent){
                final /* synthetic */ View $this_removeViewFromParent;
                final /* synthetic */ ViewGroup $parent;
                {
                    this.$this_removeViewFromParent = $receiver;
                    this.$parent = $parent;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Removed view: " + this.$this_removeViewFromParent + "\nfrom parent: " + this.$parent;
                }
            }), (int)4, null);
        }
    }

    public static final void setFocusableInTouchModeAndRequestFocus(@NotNull View $this$setFocusableInTouchModeAndRequestFocus) {
        Intrinsics.checkNotNullParameter((Object)$this$setFocusableInTouchModeAndRequestFocus, (String)"<this>");
        try {
            $this$setFocusableInTouchModeAndRequestFocus.setFocusableInTouchMode(true);
            $this$setFocusableInTouchModeAndRequestFocus.requestFocus();
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog(TAG, BrazeLogger.Priority.E, (Throwable)e, (Function0)setFocusableInTouchModeAndRequestFocus.1.INSTANCE);
        }
    }

    public static final double convertDpToPixels(@NotNull Context context, double valueInDp) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        double density = context.getResources().getDisplayMetrics().density;
        return valueInDp * density;
    }

    public static final boolean isRunningOnTablet(@NotNull Activity $this$isRunningOnTablet) {
        Intrinsics.checkNotNullParameter((Object)$this$isRunningOnTablet, (String)"<this>");
        return $this$isRunningOnTablet.getResources().getConfiguration().smallestScreenWidthDp >= 600;
    }

    public static final void setActivityRequestedOrientation(@NotNull Activity $this$setActivityRequestedOrientation, int requestedOrientation) {
        Intrinsics.checkNotNullParameter((Object)$this$setActivityRequestedOrientation, (String)"<this>");
        try {
            $this$setActivityRequestedOrientation.setRequestedOrientation(requestedOrientation);
        }
        catch (Exception e) {
            BrazeLogger.INSTANCE.brazelog(TAG, BrazeLogger.Priority.E, (Throwable)e, (Function0)new Function0<String>(requestedOrientation, $this$setActivityRequestedOrientation){
                final /* synthetic */ int $requestedOrientation;
                final /* synthetic */ Activity $this_setActivityRequestedOrientation;
                {
                    this.$requestedOrientation = $requestedOrientation;
                    this.$this_setActivityRequestedOrientation = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Failed to set requested orientation " + this.$requestedOrientation + " for activity class: " + this.$this_setActivityRequestedOrientation.getLocalClassName();
                }
            });
        }
    }

    public static final void setHeightOnViewLayoutParams(@NotNull View view, int height) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        layoutParams.height = height;
        view.setLayoutParams(layoutParams);
    }

    public static final boolean isDeviceInNightMode(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int nightModeFlags = context.getResources().getConfiguration().uiMode & 0x30;
        return nightModeFlags == 32;
    }

    public static final boolean isCurrentOrientationValid(int currentScreenOrientation, @NotNull Orientation preferredOrientation) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)preferredOrientation, (String)"preferredOrientation");
        if (currentScreenOrientation == 2 && preferredOrientation == Orientation.LANDSCAPE) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (String)TAG, (BrazeLogger.Priority)BrazeLogger.Priority.D, null, (Function0)isCurrentOrientationValid.1.INSTANCE, (int)4, null);
            bl = true;
        } else if (currentScreenOrientation == 1 && preferredOrientation == Orientation.PORTRAIT) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (String)TAG, (BrazeLogger.Priority)BrazeLogger.Priority.D, null, (Function0)isCurrentOrientationValid.2.INSTANCE, (int)4, null);
            bl = true;
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (String)TAG, (BrazeLogger.Priority)BrazeLogger.Priority.D, null, (Function0)((Function0)new Function0<String>(currentScreenOrientation, preferredOrientation){
                final /* synthetic */ int $currentScreenOrientation;
                final /* synthetic */ Orientation $preferredOrientation;
                {
                    this.$currentScreenOrientation = $currentScreenOrientation;
                    this.$preferredOrientation = $preferredOrientation;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Current orientation " + this.$currentScreenOrientation + " and preferred orientation " + this.$preferredOrientation + " don't match";
                }
            }), (int)4, null);
            bl = false;
        }
        return bl;
    }

    public static final int getMaxSafeLeftInset(@NotNull WindowInsetsCompat windowInsets) {
        Intrinsics.checkNotNullParameter((Object)windowInsets, (String)"windowInsets");
        DisplayCutoutCompat displayCutoutCompat = windowInsets.getDisplayCutout();
        int n = displayCutoutCompat != null ? displayCutoutCompat.getSafeInsetLeft() : 0;
        int n2 = windowInsets.getInsets((int)WindowInsetsCompat.Type.systemBars()).left;
        return Math.max(n, n2);
    }

    public static final int getMaxSafeRightInset(@NotNull WindowInsetsCompat windowInsets) {
        Intrinsics.checkNotNullParameter((Object)windowInsets, (String)"windowInsets");
        DisplayCutoutCompat displayCutoutCompat = windowInsets.getDisplayCutout();
        int n = displayCutoutCompat != null ? displayCutoutCompat.getSafeInsetRight() : 0;
        int n2 = windowInsets.getInsets((int)WindowInsetsCompat.Type.systemBars()).right;
        return Math.max(n, n2);
    }

    public static final int getMaxSafeTopInset(@NotNull WindowInsetsCompat windowInsets) {
        Intrinsics.checkNotNullParameter((Object)windowInsets, (String)"windowInsets");
        DisplayCutoutCompat displayCutoutCompat = windowInsets.getDisplayCutout();
        int n = displayCutoutCompat != null ? displayCutoutCompat.getSafeInsetTop() : 0;
        int n2 = windowInsets.getInsets((int)WindowInsetsCompat.Type.systemBars()).top;
        return Math.max(n, n2);
    }

    public static final int getMaxSafeBottomInset(@NotNull WindowInsetsCompat windowInsets) {
        Intrinsics.checkNotNullParameter((Object)windowInsets, (String)"windowInsets");
        DisplayCutoutCompat displayCutoutCompat = windowInsets.getDisplayCutout();
        int n = displayCutoutCompat != null ? displayCutoutCompat.getSafeInsetBottom() : 0;
        int n2 = windowInsets.getInsets((int)WindowInsetsCompat.Type.systemBars()).bottom;
        return Math.max(n, n2);
    }

    public static final boolean isDeviceNotInTouchMode(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return !view.isInTouchMode();
    }
}

