/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.webkit.ConsoleMessage;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.fragment.app.FragmentActivity;
import com.braze.BrazeInternal;
import com.braze.enums.Channel;
import com.braze.support.BrazeFileUtils;
import com.braze.support.BrazeLogger;
import com.braze.ui.BrazeDeeplinkHandler;
import com.braze.ui.BrazeWebViewActivity;
import com.braze.ui.R;
import com.braze.ui.actions.IAction;
import com.braze.ui.support.ViewUtils;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/braze/ui/BrazeWebViewActivity;", "Landroidx/fragment/app/FragmentActivity;", "<init>", "()V", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "createWebChromeClient", "Landroid/webkit/WebChromeClient;", "createWebViewClient", "Landroid/webkit/WebViewClient;", "android-sdk-ui_release"})
@SuppressLint(value={"SetJavaScriptEnabled"})
public class BrazeWebViewActivity
extends FragmentActivity {
    public void onCreate(@Nullable Bundle savedInstanceState) {
        block5: {
            super.onCreate(savedInstanceState);
            this.getWindow().setFlags(0x1000000, 0x1000000);
            if (BrazeInternal.INSTANCE.getConfigurationProvider((Context)this).getShouldUseWindowFlagSecureInActivities()) {
                this.getWindow().setFlags(8192, 8192);
            }
            this.setContentView(R.layout.com_braze_webview_activity);
            WebView webView = (WebView)this.findViewById(R.id.com_braze_webview_activity_webview);
            webView.setLayerType(2, null);
            WebSettings webSettings = webView.getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)webSettings, (String)"getSettings(...)");
            WebSettings webSettings2 = webSettings;
            webSettings2.setAllowFileAccess(false);
            webSettings2.setBuiltInZoomControls(true);
            webSettings2.setJavaScriptEnabled(true);
            webSettings2.setUseWideViewPort(true);
            webSettings2.setLoadWithOverviewMode(true);
            webSettings2.setDisplayZoomControls(false);
            webSettings2.setDomStorageEnabled(true);
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
            if (ViewUtils.isDeviceInNightMode(context)) {
                if (Build.VERSION.SDK_INT >= 33) {
                    webSettings2.setAlgorithmicDarkeningAllowed(true);
                } else if (Build.VERSION.SDK_INT >= 29) {
                    webSettings2.setForceDark(2);
                }
            }
            webView.setWebChromeClient(this.createWebChromeClient());
            webView.setWebViewClient(this.createWebViewClient());
            Object object = this.getIntent().getExtras();
            if (object == null || (object = object.getString("url")) == null) break block5;
            Object url = object;
            boolean bl = false;
            webView.loadUrl((String)url);
        }
    }

    @NotNull
    public WebChromeClient createWebChromeClient() {
        return new WebChromeClient(){

            public boolean onConsoleMessage(ConsoleMessage cm) {
                Intrinsics.checkNotNullParameter((Object)cm, (String)"cm");
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), null, null, (boolean)false, () -> createWebChromeClient.1.onConsoleMessage$lambda$0(cm), (int)7, null);
                return true;
            }

            public Bitmap getDefaultVideoPoster() {
                Bitmap bitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
                return bitmap;
            }

            private static final String onConsoleMessage$lambda$0(ConsoleMessage $cm) {
                return "Braze WebView Activity log. Line: " + $cm.lineNumber() + ". SourceId: " + $cm.sourceId() + ". Log Level: " + $cm.messageLevel() + ". Message: " + $cm.message();
            }
        };
    }

    @NotNull
    public WebViewClient createWebViewClient() {
        return new WebViewClient(this){
            final /* synthetic */ BrazeWebViewActivity this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                Boolean didHandleUrl;
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Context context = view.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                String string = request.getUrl().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                Boolean bl = didHandleUrl = this.handleUrlOverride(context, string);
                return bl != null ? bl.booleanValue() : super.shouldOverrideUrlLoading(view, request);
            }

            @Deprecated(message="Deprecated in Java")
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                Boolean didHandleUrl;
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Context context = view.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                Boolean bl = didHandleUrl = this.handleUrlOverride(context, url);
                return bl != null ? bl.booleanValue() : super.shouldOverrideUrlLoading(view, url);
            }

            private final Boolean handleUrlOverride(Context context, String url) {
                try {
                    Boolean bl;
                    if (CollectionsKt.contains((Iterable)BrazeFileUtils.REMOTE_SCHEMES, (Object)Uri.parse((String)url).getScheme())) {
                        return null;
                    }
                    IAction action = BrazeDeeplinkHandler.Companion.getInstance().createUriActionFromUrlString(url, this.this$0.getIntent().getExtras(), false, Channel.UNKNOWN);
                    if (action != null) {
                        action.execute(context);
                        this.this$0.finish();
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }
                catch (Exception e) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, () -> createWebViewClient.1.handleUrlOverride$lambda$0(url), (int)4, null);
                    return null;
                }
            }

            public boolean onRenderProcessGone(WebView view, RenderProcessGoneDetail detail) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)detail, (String)"detail");
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, createWebViewClient.1::onRenderProcessGone$lambda$1, (int)6, null);
                return true;
            }

            private static final String handleUrlOverride$lambda$0(String $url) {
                return "Unexpected exception while processing url " + $url + ". Passing url back to WebView.";
            }

            private static final String onRenderProcessGone$lambda$1() {
                return "The webview rendering process crashed, returning true";
            }
        };
    }
}

