/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.inappmessage;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.animation.Animation;
import androidx.annotation.VisibleForTesting;
import com.braze.Braze;
import com.braze.BrazeInternal;
import com.braze.configuration.BrazeConfigurationProvider;
import com.braze.enums.inappmessage.Orientation;
import com.braze.events.BrazeUserChangeEvent;
import com.braze.events.IEventSubscriber;
import com.braze.events.InAppMessageEvent;
import com.braze.events.SdkDataWipeEvent;
import com.braze.models.inappmessage.IInAppMessage;
import com.braze.models.inappmessage.InAppMessageHtml;
import com.braze.models.inappmessage.InAppMessageImmersiveBase;
import com.braze.support.BrazeLogger;
import com.braze.support.DateTimeUtils;
import com.braze.support.JsonUtils;
import com.braze.support.PermissionUtils;
import com.braze.ui.actions.brazeactions.BrazeActionUtils;
import com.braze.ui.inappmessage.IInAppMessageViewFactory;
import com.braze.ui.inappmessage.IInAppMessageViewWrapper;
import com.braze.ui.inappmessage.IInAppMessageViewWrapperFactory;
import com.braze.ui.inappmessage.InAppMessageManagerBase;
import com.braze.ui.inappmessage.InAppMessageOperation;
import com.braze.ui.inappmessage.listeners.DefaultInAppMessageViewLifecycleListener;
import com.braze.ui.inappmessage.listeners.IInAppMessageManagerListener;
import com.braze.ui.inappmessage.listeners.IInAppMessageViewLifecycleListener;
import com.braze.ui.inappmessage.utils.BackgroundInAppMessagePreparer;
import com.braze.ui.inappmessage.views.IInAppMessageImmersiveView;
import com.braze.ui.inappmessage.views.IInAppMessageView;
import com.braze.ui.inappmessage.views.InAppMessageHtmlBaseView;
import com.braze.ui.support.ViewUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0017\u0018\u0000 E2\u00020\u0001:\u0001EB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\u0012\u00104\u001a\u0002012\b\u00105\u001a\u0004\u0018\u000106H\u0016J\u0012\u00107\u001a\u0002012\b\u00105\u001a\u0004\u0018\u000106H\u0016J\u0012\u00108\u001a\u0002012\b\u00109\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010:\u001a\u00020.H\u0016J\u0010\u0010;\u001a\u0002012\u0006\u0010<\u001a\u00020.H\u0016J\b\u0010=\u001a\u000201H\u0016J\b\u0010>\u001a\u00020.H\u0016J\u0018\u0010?\u001a\u0002012\u0006\u00109\u001a\u00020\u000b2\u0006\u0010@\u001a\u00020.H\u0016J\u000e\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0002J\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00190\u00152\u0006\u00102\u001a\u000203H\u0002J\u0010\u0010C\u001a\u00020.2\u0006\u00109\u001a\u00020\u000bH\u0017J\u001a\u0010D\u001a\u00020.2\b\u00109\u001a\u0004\u0018\u00010\u000b2\u0006\u0010!\u001a\u00020\"H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003R\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0003\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010#\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b$\u0010\u0003\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R&\u0010)\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b*\u0010\u0003\u001a\u0004\b+\u0010&\"\u0004\b,\u0010(R\u0011\u0010-\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010/\u00a8\u0006F"}, d2={"Lcom/braze/ui/inappmessage/BrazeInAppMessageManager;", "Lcom/braze/ui/inappmessage/InAppMessageManagerBase;", "<init>", "()V", "inAppMessageViewLifecycleListener", "Lcom/braze/ui/inappmessage/listeners/IInAppMessageViewLifecycleListener;", "displayingInAppMessage", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getDisplayingInAppMessage$annotations", "inAppMessageStack", "Ljava/util/Stack;", "Lcom/braze/models/inappmessage/IInAppMessage;", "getInAppMessageStack$annotations", "getInAppMessageStack", "()Ljava/util/Stack;", "inAppMessageEventMap", "", "Lcom/braze/events/InAppMessageEvent;", "getInAppMessageEventMap", "()Ljava/util/Map;", "inAppMessageEventSubscriber", "Lcom/braze/events/IEventSubscriber;", "sdkDataWipeEventSubscriber", "Lcom/braze/events/SdkDataWipeEvent;", "brazeUserChangeEventSubscriber", "Lcom/braze/events/BrazeUserChangeEvent;", "originalOrientation", "", "Ljava/lang/Integer;", "configurationProvider", "Lcom/braze/configuration/BrazeConfigurationProvider;", "inAppMessageViewWrapper", "Lcom/braze/ui/inappmessage/IInAppMessageViewWrapper;", "currentUserId", "", "carryoverInAppMessage", "getCarryoverInAppMessage$annotations", "getCarryoverInAppMessage", "()Lcom/braze/models/inappmessage/IInAppMessage;", "setCarryoverInAppMessage", "(Lcom/braze/models/inappmessage/IInAppMessage;)V", "unregisteredInAppMessage", "getUnregisteredInAppMessage$annotations", "getUnregisteredInAppMessage", "setUnregisteredInAppMessage", "isCurrentlyDisplayingInAppMessage", "", "()Z", "ensureSubscribedToInAppMessageEvents", "", "context", "Landroid/content/Context;", "registerInAppMessageManager", "activity", "Landroid/app/Activity;", "unregisterInAppMessageManager", "addInAppMessage", "inAppMessage", "requestDisplayInAppMessage", "hideCurrentlyDisplayingInAppMessage", "dismissed", "resetAfterInAppMessageClose", "getIsCurrentlyDisplayingInAppMessage", "displayInAppMessage", "isCarryOver", "createInAppMessageEventSubscriber", "createBrazeUserChangeEventSubscriber", "verifyOrientationStatus", "isInAppMessageForTheSameUser", "Companion", "android-sdk-ui_release"})
@SuppressLint(value={"StaticFieldLeak"})
@SourceDebugExtension(value={"SMAP\nBrazeInAppMessageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrazeInAppMessageManager.kt\ncom/braze/ui/inappmessage/BrazeInAppMessageManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,762:1\n1#2:763\n*E\n"})
public class BrazeInAppMessageManager
extends InAppMessageManagerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IInAppMessageViewLifecycleListener inAppMessageViewLifecycleListener = new DefaultInAppMessageViewLifecycleListener();
    @JvmField
    @NotNull
    public final AtomicBoolean displayingInAppMessage = new AtomicBoolean(false);
    @NotNull
    private final Stack<IInAppMessage> inAppMessageStack = new Stack();
    @NotNull
    private final Map<IInAppMessage, InAppMessageEvent> inAppMessageEventMap = new LinkedHashMap();
    @Nullable
    private IEventSubscriber<InAppMessageEvent> inAppMessageEventSubscriber;
    @Nullable
    private IEventSubscriber<SdkDataWipeEvent> sdkDataWipeEventSubscriber;
    @Nullable
    private IEventSubscriber<BrazeUserChangeEvent> brazeUserChangeEventSubscriber;
    @Nullable
    private Integer originalOrientation;
    @Nullable
    private BrazeConfigurationProvider configurationProvider;
    @Nullable
    private IInAppMessageViewWrapper inAppMessageViewWrapper;
    @NotNull
    private String currentUserId = "";
    @Nullable
    private IInAppMessage carryoverInAppMessage;
    @Nullable
    private IInAppMessage unregisteredInAppMessage;
    @NotNull
    private static final ReentrantLock instanceLock = new ReentrantLock();
    @Nullable
    private static volatile BrazeInAppMessageManager instance;

    @VisibleForTesting
    public static /* synthetic */ void getDisplayingInAppMessage$annotations() {
    }

    @NotNull
    public final Stack<IInAppMessage> getInAppMessageStack() {
        return this.inAppMessageStack;
    }

    @VisibleForTesting
    public static /* synthetic */ void getInAppMessageStack$annotations() {
    }

    @NotNull
    public final Map<IInAppMessage, InAppMessageEvent> getInAppMessageEventMap() {
        return this.inAppMessageEventMap;
    }

    @Nullable
    public final IInAppMessage getCarryoverInAppMessage() {
        return this.carryoverInAppMessage;
    }

    public final void setCarryoverInAppMessage(@Nullable IInAppMessage iInAppMessage) {
        this.carryoverInAppMessage = iInAppMessage;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCarryoverInAppMessage$annotations() {
    }

    @Nullable
    public final IInAppMessage getUnregisteredInAppMessage() {
        return this.unregisteredInAppMessage;
    }

    public final void setUnregisteredInAppMessage(@Nullable IInAppMessage iInAppMessage) {
        this.unregisteredInAppMessage = iInAppMessage;
    }

    @VisibleForTesting
    public static /* synthetic */ void getUnregisteredInAppMessage$annotations() {
    }

    public final boolean isCurrentlyDisplayingInAppMessage() {
        return this.displayingInAppMessage.get();
    }

    public void ensureSubscribedToInAppMessageEvents(@NotNull Context context) {
        IEventSubscriber<BrazeUserChangeEvent> it;
        IEventSubscriber<BrazeUserChangeEvent> iEventSubscriber;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.inAppMessageEventSubscriber != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::ensureSubscribedToInAppMessageEvents$lambda$0, (int)7, null);
            Braze.Companion.getInstance(context).removeSingleSubscription(this.inAppMessageEventSubscriber, InAppMessageEvent.class);
        }
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::ensureSubscribedToInAppMessageEvents$lambda$1, (int)7, null);
        IEventSubscriber<BrazeUserChangeEvent> iEventSubscriber2 = iEventSubscriber = this.createInAppMessageEventSubscriber();
        BrazeInAppMessageManager brazeInAppMessageManager = this;
        boolean bl = false;
        Braze.Companion.getInstance(context).subscribeToNewInAppMessages((IEventSubscriber)it);
        brazeInAppMessageManager.inAppMessageEventSubscriber = iEventSubscriber;
        if (this.sdkDataWipeEventSubscriber != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, BrazeInAppMessageManager::ensureSubscribedToInAppMessageEvents$lambda$3, (int)6, null);
            Braze.Companion.getInstance(context).removeSingleSubscription(this.sdkDataWipeEventSubscriber, SdkDataWipeEvent.class);
        }
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, BrazeInAppMessageManager::ensureSubscribedToInAppMessageEvents$lambda$4, (int)6, null);
        it = iEventSubscriber = arg_0 -> BrazeInAppMessageManager.ensureSubscribedToInAppMessageEvents$lambda$5(this, arg_0);
        brazeInAppMessageManager = this;
        boolean bl2 = false;
        Braze.Companion.getInstance(context).addSingleSynchronousSubscription((IEventSubscriber)it, SdkDataWipeEvent.class);
        brazeInAppMessageManager.sdkDataWipeEventSubscriber = iEventSubscriber;
        if (this.brazeUserChangeEventSubscriber != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, BrazeInAppMessageManager::ensureSubscribedToInAppMessageEvents$lambda$7, (int)6, null);
            Braze.Companion.getInstance(context).removeSingleSubscription(this.brazeUserChangeEventSubscriber, BrazeUserChangeEvent.class);
        }
        it = iEventSubscriber = this.createBrazeUserChangeEventSubscriber(context);
        brazeInAppMessageManager = this;
        boolean bl3 = false;
        Braze.Companion.getInstance(context).addSingleSynchronousSubscription(it, BrazeUserChangeEvent.class);
        brazeInAppMessageManager.brazeUserChangeEventSubscriber = iEventSubscriber;
    }

    public void registerInAppMessageManager(@Nullable Activity activity) {
        try {
            IInAppMessage it;
            if (activity == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, BrazeInAppMessageManager::registerInAppMessageManager$lambda$9, (int)6, null);
                return;
            }
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> BrazeInAppMessageManager.registerInAppMessageManager$lambda$10(activity), (int)6, null);
            this.mActivity = activity;
            if (this.mApplicationContext == null) {
                this.mApplicationContext = activity.getApplicationContext();
                if (this.mApplicationContext == null) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, BrazeInAppMessageManager::registerInAppMessageManager$lambda$11, (int)6, null);
                    return;
                }
            }
            if (this.configurationProvider == null) {
                BrazeConfigurationProvider brazeConfigurationProvider;
                BrazeInAppMessageManager brazeInAppMessageManager = this;
                Context context = this.mApplicationContext;
                if (context != null) {
                    Context context2 = context;
                    BrazeInAppMessageManager brazeInAppMessageManager2 = brazeInAppMessageManager;
                    boolean bl = false;
                    brazeConfigurationProvider = new BrazeConfigurationProvider((Context)it);
                    brazeInAppMessageManager = brazeInAppMessageManager2;
                } else {
                    brazeConfigurationProvider = brazeInAppMessageManager.configurationProvider = null;
                }
            }
            if (this.carryoverInAppMessage != null) {
                IInAppMessage iInAppMessage = this.carryoverInAppMessage;
                if (iInAppMessage != null) {
                    it = iInAppMessage;
                    boolean bl = false;
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::registerInAppMessageManager$lambda$14$lambda$13, (int)7, null);
                    it.setAnimateIn(false);
                    this.displayInAppMessage(it, true);
                }
                this.carryoverInAppMessage = null;
            } else {
                IInAppMessage iInAppMessage = this.unregisteredInAppMessage;
                if (iInAppMessage != null) {
                    it = iInAppMessage;
                    boolean bl = false;
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::registerInAppMessageManager$lambda$16$lambda$15, (int)7, null);
                    this.addInAppMessage(it);
                    this.unregisteredInAppMessage = null;
                }
            }
            Context context = this.mApplicationContext;
            if (context != null) {
                it = context;
                boolean bl = false;
                this.ensureSubscribedToInAppMessageEvents((Context)it);
            }
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, BrazeInAppMessageManager::registerInAppMessageManager$lambda$18, (int)4, null);
        }
    }

    public void unregisterInAppMessageManager(@Nullable Activity activity) {
        try {
            if (this.getShouldNextUnregisterBeSkipped()) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, () -> BrazeInAppMessageManager.unregisterInAppMessageManager$lambda$19(activity), (int)7, null);
                this.setShouldNextUnregisterBeSkipped(false);
                return;
            }
            if (activity == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, BrazeInAppMessageManager::unregisterInAppMessageManager$lambda$20, (int)6, null);
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> BrazeInAppMessageManager.unregisterInAppMessageManager$lambda$21(activity), (int)6, null);
            }
            IInAppMessageViewWrapper viewWrapper = this.inAppMessageViewWrapper;
            if (viewWrapper != null) {
                IInAppMessage iInAppMessage;
                View inAppMessageView = viewWrapper.getInAppMessageView();
                if (inAppMessageView instanceof InAppMessageHtmlBaseView) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::unregisterInAppMessageManager$lambda$22, (int)7, null);
                    ((InAppMessageHtmlBaseView)inAppMessageView).setHtmlPageFinishedListener(null);
                }
                ViewUtils.removeViewFromParent(inAppMessageView);
                if (viewWrapper.isAnimatingClose()) {
                    this.inAppMessageViewLifecycleListener.afterClosed(viewWrapper.getInAppMessage());
                    iInAppMessage = null;
                } else {
                    iInAppMessage = viewWrapper.getInAppMessage();
                }
                this.carryoverInAppMessage = iInAppMessage;
                this.inAppMessageViewWrapper = null;
            } else {
                this.carryoverInAppMessage = null;
            }
            this.mActivity = null;
            this.displayingInAppMessage.set(false);
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, BrazeInAppMessageManager::unregisterInAppMessageManager$lambda$23, (int)4, null);
        }
    }

    public void addInAppMessage(@Nullable IInAppMessage inAppMessage) {
        if (inAppMessage != null) {
            this.inAppMessageStack.push(inAppMessage);
            this.requestDisplayInAppMessage();
        }
    }

    public boolean requestDisplayInAppMessage() {
        boolean bl;
        try {
            InAppMessageOperation inAppMessageOperation;
            Activity activity = this.mActivity;
            if (activity == null) {
                if (!this.inAppMessageStack.empty()) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, BrazeInAppMessageManager::requestDisplayInAppMessage$lambda$24, (int)6, null);
                    this.unregisteredInAppMessage = this.inAppMessageStack.pop();
                } else {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::requestDisplayInAppMessage$lambda$25, (int)7, null);
                }
                return false;
            }
            if (this.displayingInAppMessage.get()) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::requestDisplayInAppMessage$lambda$26, (int)7, null);
                return false;
            }
            if (this.inAppMessageStack.isEmpty()) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::requestDisplayInAppMessage$lambda$27, (int)7, null);
                return false;
            }
            IInAppMessage inAppMessage = this.inAppMessageStack.pop();
            if (!inAppMessage.isControl()) {
                IInAppMessageManagerListener iInAppMessageManagerListener = this.getInAppMessageManagerListener();
                Intrinsics.checkNotNull((Object)inAppMessage);
                inAppMessageOperation = iInAppMessageManagerListener.beforeInAppMessageDisplayed(inAppMessage);
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::requestDisplayInAppMessage$lambda$28, (int)7, null);
                IInAppMessageManagerListener iInAppMessageManagerListener = this.getControlInAppMessageManagerListener();
                Intrinsics.checkNotNull((Object)inAppMessage);
                inAppMessageOperation = iInAppMessageManagerListener.beforeInAppMessageDisplayed(inAppMessage);
            }
            InAppMessageOperation inAppMessageOperation2 = inAppMessageOperation;
            switch (WhenMappings.$EnumSwitchMapping$0[inAppMessageOperation2.ordinal()]) {
                case 1: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::requestDisplayInAppMessage$lambda$29, (int)7, null);
                    break;
                }
                case 2: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::requestDisplayInAppMessage$lambda$30, (int)7, null);
                    this.inAppMessageStack.push(inAppMessage);
                    return false;
                }
                case 3: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::requestDisplayInAppMessage$lambda$31, (int)7, null);
                    return false;
                }
                case 4: {
                    InAppMessageEvent event = this.inAppMessageEventMap.get(inAppMessage);
                    if (event != null) {
                        Context context = activity.getApplicationContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
                        BrazeInternal.INSTANCE.reenqueueInAppMessage(context, event);
                        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::requestDisplayInAppMessage$lambda$32, (int)7, null);
                    } else {
                        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, () -> BrazeInAppMessageManager.requestDisplayInAppMessage$lambda$33(inAppMessage), (int)7, null);
                    }
                    return false;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            BackgroundInAppMessagePreparer.prepareInAppMessageForDisplay(inAppMessage);
            bl = true;
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, BrazeInAppMessageManager::requestDisplayInAppMessage$lambda$34, (int)4, null);
            bl = false;
        }
        return bl;
    }

    public void hideCurrentlyDisplayingInAppMessage(boolean dismissed) {
        this.setShouldNextUnregisterBeSkipped(false);
        IInAppMessageViewWrapper inAppMessageWrapperView = this.inAppMessageViewWrapper;
        if (inAppMessageWrapperView != null) {
            if (dismissed) {
                this.inAppMessageViewLifecycleListener.onDismissed(inAppMessageWrapperView.getInAppMessageView(), inAppMessageWrapperView.getInAppMessage());
            }
            inAppMessageWrapperView.close();
        }
    }

    public void resetAfterInAppMessageClose() {
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, BrazeInAppMessageManager::resetAfterInAppMessageClose$lambda$35, (int)6, null);
        this.inAppMessageViewWrapper = null;
        Activity activity = this.mActivity;
        Integer origOrientation = this.originalOrientation;
        this.displayingInAppMessage.set(false);
        if (activity != null && origOrientation != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, () -> BrazeInAppMessageManager.resetAfterInAppMessageClose$lambda$36(origOrientation), (int)7, null);
            ViewUtils.setActivityRequestedOrientation(activity, origOrientation);
            this.originalOrientation = null;
        }
    }

    public boolean getIsCurrentlyDisplayingInAppMessage() {
        return this.displayingInAppMessage.get();
    }

    public void displayInAppMessage(@NotNull IInAppMessage inAppMessage, boolean isCarryOver) {
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> BrazeInAppMessageManager.displayInAppMessage$lambda$37(inAppMessage), (int)6, null);
        if (!this.displayingInAppMessage.compareAndSet(false, true)) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::displayInAppMessage$lambda$38, (int)7, null);
            this.inAppMessageStack.push(inAppMessage);
            return;
        }
        try {
            IInAppMessageViewWrapper iInAppMessageViewWrapper;
            Activity activity = this.mActivity;
            if (activity == null) {
                this.carryoverInAppMessage = inAppMessage;
                throw new Exception("No Activity is currently registered to receive in-app messages. Registering in-app message as carry-over in-app message. It will automatically be displayed when the next Activity registers to receive in-app messages.");
            }
            long inAppMessageExpirationTimestamp = inAppMessage.getExpirationTimestamp();
            if (inAppMessageExpirationTimestamp > 0L) {
                long currentTimeMillis = DateTimeUtils.nowInMilliseconds();
                if (currentTimeMillis > inAppMessageExpirationTimestamp) {
                    throw new Exception("In-app message is expired. Doing nothing. Expiration: " + inAppMessageExpirationTimestamp + ". Current time: " + currentTimeMillis);
                }
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::displayInAppMessage$lambda$39, (int)7, null);
            }
            if (!this.verifyOrientationStatus(inAppMessage)) {
                throw new Exception("Current orientation did not match specified orientation for in-app message. Doing nothing.");
            }
            BrazeConfigurationProvider brazeConfigurationProvider = this.configurationProvider;
            if (brazeConfigurationProvider == null) {
                throw new Exception("configurationProvider is null. The in-app message will not be displayed and will not beput back on the stack.");
            }
            BrazeConfigurationProvider configProvider = brazeConfigurationProvider;
            if (configProvider.isPreventInAppMessageDisplayForDifferentUsersEnabled() && !this.isInAppMessageForTheSameUser(inAppMessage, this.currentUserId)) {
                throw new Exception("The last identifier user " + this.currentUserId + " does not match the in-app message's user. The in-app message will not be displayed and will not be put back on the stack.");
            }
            if (inAppMessage.isControl()) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::displayInAppMessage$lambda$40, (int)7, null);
                inAppMessage.logImpression();
                this.resetAfterInAppMessageClose();
                return;
            }
            if (BrazeActionUtils.containsInvalidBrazeAction(inAppMessage)) {
                InAppMessageEvent inAppMessageEvent = this.inAppMessageEventMap.get(inAppMessage);
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, BrazeInAppMessageManager::displayInAppMessage$lambda$41, (int)6, null);
                if (inAppMessageEvent != null) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, BrazeInAppMessageManager::displayInAppMessage$lambda$42, (int)6, null);
                    Context context = activity.getApplicationContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
                    BrazeInternal.retryInAppMessage((Context)context, (InAppMessageEvent)inAppMessageEvent);
                }
                this.resetAfterInAppMessageClose();
                return;
            }
            if (BrazeInAppMessageManager.Companion.containsPushPermissionPrompt(inAppMessage) && !PermissionUtils.wouldPushPermissionPromptDisplay((Activity)activity)) {
                InAppMessageEvent inAppMessageEvent = this.inAppMessageEventMap.get(inAppMessage);
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, BrazeInAppMessageManager::displayInAppMessage$lambda$43, (int)6, null);
                if (inAppMessageEvent != null) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, BrazeInAppMessageManager::displayInAppMessage$lambda$44, (int)6, null);
                    Context context = activity.getApplicationContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
                    BrazeInternal.retryInAppMessage((Context)context, (InAppMessageEvent)inAppMessageEvent);
                }
                this.resetAfterInAppMessageClose();
                return;
            }
            IInAppMessageViewFactory iInAppMessageViewFactory = this.getInAppMessageViewFactory(inAppMessage);
            if (iInAppMessageViewFactory == null) {
                throw new Exception("ViewFactory from getInAppMessageViewFactory was null.");
            }
            IInAppMessageViewFactory inAppMessageViewFactory = iInAppMessageViewFactory;
            View inAppMessageView = inAppMessageViewFactory.createInAppMessageView(activity, inAppMessage);
            if (inAppMessageView == null) {
                throw new Exception("The in-app message view returned from the IInAppMessageViewFactory was null. The in-app message will not be displayed and will not be put back on the stack.");
            }
            if (inAppMessageView.getParent() != null) {
                throw new Exception("The in-app message view returned from the IInAppMessageViewFactory already has a parent. This is a sign that the view is being reused. The IInAppMessageViewFactory method createInAppMessageViewmust return a new view without a parent. The in-app message will not be displayed and will not be put back on the stack.");
            }
            Animation openingAnimation = this.getInAppMessageAnimationFactory().getOpeningAnimation(inAppMessage);
            Animation closingAnimation = this.getInAppMessageAnimationFactory().getClosingAnimation(inAppMessage);
            IInAppMessageViewWrapperFactory viewWrapperFactory = this.getInAppMessageViewWrapperFactory();
            View view = inAppMessageView;
            if (view instanceof IInAppMessageImmersiveView) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::displayInAppMessage$lambda$45, (int)7, null);
                IInAppMessageImmersiveView inAppMessageViewImmersive = (IInAppMessageImmersiveView)inAppMessageView;
                InAppMessageImmersiveBase inAppMessageImmersiveBase = (InAppMessageImmersiveBase)inAppMessage;
                int numButtons = inAppMessageImmersiveBase.getMessageButtons().size();
                iInAppMessageViewWrapper = viewWrapperFactory.createInAppMessageViewWrapper(inAppMessageView, inAppMessage, this.inAppMessageViewLifecycleListener, configProvider, openingAnimation, closingAnimation, inAppMessageViewImmersive.getMessageClickableView(), inAppMessageViewImmersive.getMessageButtonViews(numButtons), inAppMessageViewImmersive.getMessageCloseButtonView());
            } else if (view instanceof IInAppMessageView) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::displayInAppMessage$lambda$46, (int)7, null);
                IInAppMessageView inAppMessageViewBase = (IInAppMessageView)inAppMessageView;
                iInAppMessageViewWrapper = viewWrapperFactory.createInAppMessageViewWrapper(inAppMessageView, inAppMessage, this.inAppMessageViewLifecycleListener, configProvider, openingAnimation, closingAnimation, inAppMessageViewBase.getMessageClickableView());
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::displayInAppMessage$lambda$47, (int)7, null);
                iInAppMessageViewWrapper = viewWrapperFactory.createInAppMessageViewWrapper(inAppMessageView, inAppMessage, this.inAppMessageViewLifecycleListener, configProvider, openingAnimation, closingAnimation, inAppMessageView);
            }
            IInAppMessageViewWrapper viewWrapper = this.inAppMessageViewWrapper = iInAppMessageViewWrapper;
            if (inAppMessageView instanceof InAppMessageHtmlBaseView) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::displayInAppMessage$lambda$48, (int)7, null);
                ((InAppMessageHtmlBaseView)inAppMessageView).setHtmlPageFinishedListener(() -> BrazeInAppMessageManager.displayInAppMessage$lambda$51(viewWrapper, this, activity));
            } else {
                IInAppMessageViewWrapper iInAppMessageViewWrapper2 = viewWrapper;
                if (iInAppMessageViewWrapper2 != null) {
                    iInAppMessageViewWrapper2.open(activity);
                }
            }
        }
        catch (Throwable e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, () -> BrazeInAppMessageManager.displayInAppMessage$lambda$52(inAppMessage), (int)4, null);
            this.resetAfterInAppMessageClose();
        }
    }

    private final IEventSubscriber<InAppMessageEvent> createInAppMessageEventSubscriber() {
        return arg_0 -> BrazeInAppMessageManager.createInAppMessageEventSubscriber$lambda$53(this, arg_0);
    }

    private final IEventSubscriber<BrazeUserChangeEvent> createBrazeUserChangeEventSubscriber(Context context) {
        return arg_0 -> BrazeInAppMessageManager.createBrazeUserChangeEventSubscriber$lambda$58(this, context, arg_0);
    }

    @SuppressLint(value={"InlinedApi"})
    @VisibleForTesting
    public boolean verifyOrientationStatus(@NotNull IInAppMessage inAppMessage) {
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        Activity activity = this.mActivity;
        Orientation preferredOrientation = inAppMessage.getOrientation();
        if (activity == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, BrazeInAppMessageManager::verifyOrientationStatus$lambda$59, (int)6, null);
        } else if (ViewUtils.isRunningOnTablet(activity)) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::verifyOrientationStatus$lambda$60, (int)7, null);
        } else if (preferredOrientation == Orientation.ANY) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::verifyOrientationStatus$lambda$61, (int)7, null);
        } else {
            boolean bl;
            int currentScreenOrientation = activity.getResources().getConfiguration().orientation;
            if (ViewUtils.isCurrentOrientationValid(currentScreenOrientation, preferredOrientation)) {
                if (this.originalOrientation == null) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, BrazeInAppMessageManager::verifyOrientationStatus$lambda$62, (int)7, null);
                    this.originalOrientation = activity.getRequestedOrientation();
                    ViewUtils.setActivityRequestedOrientation(activity, 14);
                }
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }
        return true;
    }

    @VisibleForTesting
    public boolean isInAppMessageForTheSameUser(@Nullable IInAppMessage inAppMessage, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        if (inAppMessage == null) {
            return true;
        }
        InAppMessageEvent inAppMessageEvent = this.inAppMessageEventMap.get(inAppMessage);
        String inAppMessageUserId = inAppMessageEvent != null ? inAppMessageEvent.getUserId() : null;
        return inAppMessageUserId == null || Intrinsics.areEqual((Object)inAppMessageUserId, (Object)currentUserId);
    }

    private static final String ensureSubscribedToInAppMessageEvents$lambda$0() {
        return "Removing existing in-app message event subscriber before subscribing a new one.";
    }

    private static final String ensureSubscribedToInAppMessageEvents$lambda$1() {
        return "Subscribing in-app message event subscriber";
    }

    private static final String ensureSubscribedToInAppMessageEvents$lambda$3() {
        return "Removing existing sdk data wipe event subscriber before subscribing a new one.";
    }

    private static final String ensureSubscribedToInAppMessageEvents$lambda$4() {
        return "Subscribing sdk data wipe subscriber";
    }

    private static final void ensureSubscribedToInAppMessageEvents$lambda$5(BrazeInAppMessageManager this$0, SdkDataWipeEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.inAppMessageStack.clear();
        this$0.carryoverInAppMessage = null;
        this$0.unregisteredInAppMessage = null;
    }

    private static final String ensureSubscribedToInAppMessageEvents$lambda$7() {
        return "Removing existing user change event subscriber before subscribing a new one.";
    }

    private static final String registerInAppMessageManager$lambda$9() {
        return "Null Activity passed to registerInAppMessageManager. Doing nothing";
    }

    private static final String registerInAppMessageManager$lambda$10(Activity $activity) {
        return "Registering InAppMessageManager with activity: " + $activity.getLocalClassName();
    }

    private static final String registerInAppMessageManager$lambda$11() {
        return "Activity had null applicationContext in registerInAppMessageManager. Doing Nothing.";
    }

    private static final String registerInAppMessageManager$lambda$14$lambda$13() {
        return "Requesting display of carryover in-app message.";
    }

    private static final String registerInAppMessageManager$lambda$16$lambda$15() {
        return "Adding previously unregistered in-app message.";
    }

    private static final String registerInAppMessageManager$lambda$18() {
        return "Error while calling attempting to register the InAppMessageManager";
    }

    private static final String unregisterInAppMessageManager$lambda$19(Activity $activity) {
        Activity activity = $activity;
        return "Skipping unregistration due to setShouldNextUnregisterBeSkipped being true. Activity: " + (activity != null ? activity.getLocalClassName() : null);
    }

    private static final String unregisterInAppMessageManager$lambda$20() {
        return "Null Activity passed to unregisterInAppMessageManager.";
    }

    private static final String unregisterInAppMessageManager$lambda$21(Activity $activity) {
        return "Unregistering InAppMessageManager from activity: " + $activity.getLocalClassName();
    }

    private static final String unregisterInAppMessageManager$lambda$22() {
        return "In-app message view includes HTML. Removing the page finished listener.";
    }

    private static final String unregisterInAppMessageManager$lambda$23() {
        return "Error while calling attempting to unregister the InAppMessageManager";
    }

    private static final String requestDisplayInAppMessage$lambda$24() {
        return "No activity is currently registered to receive in-app messages. Saving in-app message as unregistered in-app message. It will automatically be displayed when the next activity registers to receive in-app messages.";
    }

    private static final String requestDisplayInAppMessage$lambda$25() {
        return "No activity is currently registered to receive in-app messages and the in-app message stack is empty. Doing nothing.";
    }

    private static final String requestDisplayInAppMessage$lambda$26() {
        return "A in-app message is currently being displayed. Ignoring request to display in-app message.";
    }

    private static final String requestDisplayInAppMessage$lambda$27() {
        return "The in-app message stack is empty. No in-app message will be displayed.";
    }

    private static final String requestDisplayInAppMessage$lambda$28() {
        return "Using the control in-app message manager listener.";
    }

    private static final String requestDisplayInAppMessage$lambda$29() {
        return "The IInAppMessageManagerListener method beforeInAppMessageDisplayed returned DISPLAY_NOW. The in-app message will be displayed.";
    }

    private static final String requestDisplayInAppMessage$lambda$30() {
        return "The IInAppMessageManagerListener method beforeInAppMessageDisplayed returned DISPLAY_LATER. The in-app message will be pushed back onto the stack.";
    }

    private static final String requestDisplayInAppMessage$lambda$31() {
        return "The IInAppMessageManagerListener method beforeInAppMessageDisplayed returned DISCARD. The in-app message will not be displayed and will not be put back on the stack.";
    }

    private static final String requestDisplayInAppMessage$lambda$32() {
        return "The IInAppMessageManagerListener method beforeInAppMessageDisplayed returned REENQUEUE. The in-app message will not be displayed and will be marked as eligible for next time.";
    }

    private static final String requestDisplayInAppMessage$lambda$33(IInAppMessage $inAppMessage) {
        return "An in-app message was requested to be re-enqueued, but it was not found. Discarding instead. In-app message = " + $inAppMessage;
    }

    private static final String requestDisplayInAppMessage$lambda$34() {
        return "Error running requestDisplayInAppMessage";
    }

    private static final String resetAfterInAppMessageClose$lambda$35() {
        return "Resetting after in-app message close.";
    }

    private static final String resetAfterInAppMessageClose$lambda$36(Integer $origOrientation) {
        return "Setting requested orientation to original orientation " + $origOrientation;
    }

    private static final String displayInAppMessage$lambda$37(IInAppMessage $inAppMessage) {
        return "Attempting to display in-app message with payload: " + JsonUtils.getPrettyPrintedString((JSONObject)((JSONObject)$inAppMessage.forJsonPut()));
    }

    private static final String displayInAppMessage$lambda$38() {
        return "A in-app message is currently being displayed. Adding in-app message back on the stack.";
    }

    private static final String displayInAppMessage$lambda$39() {
        return "Expiration timestamp not defined. Continuing.";
    }

    private static final String displayInAppMessage$lambda$40() {
        return "Not displaying control in-app message. Logging impression and ending display execution.";
    }

    private static final String displayInAppMessage$lambda$41() {
        return "Cannot show message containing an invalid Braze Action.";
    }

    private static final String displayInAppMessage$lambda$42() {
        return "Attempting to perform any fallback actions.";
    }

    private static final String displayInAppMessage$lambda$43() {
        return "Cannot show message containing a Push Prompt due to existing push prompt status, Android API version, or Target SDK level.";
    }

    private static final String displayInAppMessage$lambda$44() {
        return "Attempting to perform any fallback actions.";
    }

    private static final String displayInAppMessage$lambda$45() {
        return "Creating view wrapper for immersive in-app message.";
    }

    private static final String displayInAppMessage$lambda$46() {
        return "Creating view wrapper for base in-app message.";
    }

    private static final String displayInAppMessage$lambda$47() {
        return "Creating view wrapper for in-app message.";
    }

    private static final String displayInAppMessage$lambda$48() {
        return "In-app message view includes HTML. Delaying display until the content has finished loading.";
    }

    private static final String displayInAppMessage$lambda$51$lambda$49() {
        return "Page has finished loading. Opening in-app message view wrapper.";
    }

    private static final String displayInAppMessage$lambda$51$lambda$50() {
        return "Failed to open view wrapper in page finished listener";
    }

    private static final void displayInAppMessage$lambda$51(IInAppMessageViewWrapper $viewWrapper, BrazeInAppMessageManager this$0, Activity $activity) {
        try {
            if ($viewWrapper != null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this$0, null, null, (boolean)false, BrazeInAppMessageManager::displayInAppMessage$lambda$51$lambda$49, (int)7, null);
                $viewWrapper.open($activity);
            }
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this$0, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, BrazeInAppMessageManager::displayInAppMessage$lambda$51$lambda$50, (int)4, null);
        }
    }

    private static final String displayInAppMessage$lambda$52(IInAppMessage $inAppMessage) {
        return "Could not display in-app message with payload: " + JsonUtils.getPrettyPrintedString((JSONObject)((JSONObject)$inAppMessage.forJsonPut()));
    }

    private static final void createInAppMessageEventSubscriber$lambda$53(BrazeInAppMessageManager this$0, InAppMessageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        IInAppMessage inAppMessage = event.getInAppMessage();
        this$0.inAppMessageEventMap.put(inAppMessage, event);
        this$0.addInAppMessage(inAppMessage);
    }

    private static final String createBrazeUserChangeEventSubscriber$lambda$58$lambda$54(BrazeUserChangeEvent $event) {
        return "InAppMessage manager handling new current user id: '" + $event + '\'';
    }

    private static final String createBrazeUserChangeEventSubscriber$lambda$58$lambda$55() {
        return "Not cleansing in-app messages on user id change";
    }

    private static final String createBrazeUserChangeEventSubscriber$lambda$58$lambda$56(String $currentUserId) {
        return "Removing in-app messages not from user " + $currentUserId;
    }

    private static final boolean createBrazeUserChangeEventSubscriber$lambda$58$lambda$57(BrazeInAppMessageManager this$0, String $currentUserId, IInAppMessage it) {
        return !this$0.isInAppMessageForTheSameUser(it, $currentUserId);
    }

    private static final void createBrazeUserChangeEventSubscriber$lambda$58(BrazeInAppMessageManager this$0, Context $context, BrazeUserChangeEvent event) {
        String currentUserId;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this$0, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> BrazeInAppMessageManager.createBrazeUserChangeEventSubscriber$lambda$58$lambda$54(event), (int)6, null);
        BrazeConfigurationProvider configurationProvider = BrazeInternal.INSTANCE.getConfigurationProvider($context);
        if (!configurationProvider.isPreventInAppMessageDisplayForDifferentUsersEnabled()) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this$0, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, BrazeInAppMessageManager::createBrazeUserChangeEventSubscriber$lambda$58$lambda$55, (int)6, null);
            return;
        }
        this$0.currentUserId = currentUserId = event.getCurrentUserId();
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this$0, null, null, (boolean)false, () -> BrazeInAppMessageManager.createBrazeUserChangeEventSubscriber$lambda$58$lambda$56(currentUserId), (int)7, null);
        CollectionsKt.removeAll((List)this$0.inAppMessageStack, arg_0 -> BrazeInAppMessageManager.createBrazeUserChangeEventSubscriber$lambda$58$lambda$57(this$0, currentUserId, arg_0));
        if (!this$0.isInAppMessageForTheSameUser(this$0.carryoverInAppMessage, currentUserId)) {
            this$0.carryoverInAppMessage = null;
        }
        if (!this$0.isInAppMessageForTheSameUser(this$0.unregisteredInAppMessage, currentUserId)) {
            this$0.unregisteredInAppMessage = null;
        }
    }

    private static final String verifyOrientationStatus$lambda$59() {
        return "Cannot verify orientation status with null Activity.";
    }

    private static final String verifyOrientationStatus$lambda$60() {
        return "Running on tablet. In-app message can be displayed in any orientation.";
    }

    private static final String verifyOrientationStatus$lambda$61() {
        return "Any orientation specified. In-app message can be displayed in any orientation.";
    }

    private static final String verifyOrientationStatus$lambda$62() {
        return "Requesting orientation lock.";
    }

    @JvmStatic
    @NotNull
    public static final BrazeInAppMessageManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0007H\u0007J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/braze/ui/inappmessage/BrazeInAppMessageManager$Companion;", "", "<init>", "()V", "instanceLock", "Ljava/util/concurrent/locks/ReentrantLock;", "instance", "Lcom/braze/ui/inappmessage/BrazeInAppMessageManager;", "getInstance", "containsPushPermissionPrompt", "", "Lcom/braze/models/inappmessage/IInAppMessage;", "android-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final BrazeInAppMessageManager getInstance() {
            if (instance != null) {
                BrazeInAppMessageManager brazeInAppMessageManager = instance;
                Intrinsics.checkNotNull((Object)brazeInAppMessageManager, (String)"null cannot be cast to non-null type com.braze.ui.inappmessage.BrazeInAppMessageManager");
                return brazeInAppMessageManager;
            }
            Lock lock = instanceLock;
            lock.lock();
            try {
                boolean bl = false;
                if (instance == null) {
                    instance = new BrazeInAppMessageManager();
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
            BrazeInAppMessageManager brazeInAppMessageManager = instance;
            Intrinsics.checkNotNull((Object)brazeInAppMessageManager, (String)"null cannot be cast to non-null type com.braze.ui.inappmessage.BrazeInAppMessageManager");
            return brazeInAppMessageManager;
        }

        private final boolean containsPushPermissionPrompt(IInAppMessage $this$containsPushPermissionPrompt) {
            if ($this$containsPushPermissionPrompt instanceof InAppMessageHtml) {
                return ((InAppMessageHtml)$this$containsPushPermissionPrompt).isPushPrimer();
            }
            return BrazeActionUtils.containsAnyPushPermissionBrazeActions($this$containsPushPermissionPrompt);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InAppMessageOperation.values().length];
            try {
                nArray[InAppMessageOperation.DISPLAY_NOW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InAppMessageOperation.DISPLAY_LATER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InAppMessageOperation.DISCARD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InAppMessageOperation.REENQUEUE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

