/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.inappmessage.listeners;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.view.View;
import com.braze.coroutine.BrazeCoroutineScope;
import com.braze.enums.Channel;
import com.braze.enums.inappmessage.ClickAction;
import com.braze.models.inappmessage.IInAppMessage;
import com.braze.models.inappmessage.IInAppMessageHtml;
import com.braze.models.inappmessage.IInAppMessageImmersive;
import com.braze.models.inappmessage.MessageButton;
import com.braze.support.BrazeFileUtils;
import com.braze.support.BrazeFunctionNotImplemented;
import com.braze.support.BrazeLogger;
import com.braze.support.BundleUtils;
import com.braze.support.WebContentUtils;
import com.braze.ui.BrazeDeeplinkHandler;
import com.braze.ui.actions.NewsfeedAction;
import com.braze.ui.actions.UriAction;
import com.braze.ui.inappmessage.BrazeInAppMessageManager;
import com.braze.ui.inappmessage.InAppMessageCloser;
import com.braze.ui.inappmessage.listeners.IInAppMessageViewLifecycleListener;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0014\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u001a\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J2\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\tH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006$"}, d2={"Lcom/braze/ui/inappmessage/listeners/DefaultInAppMessageViewLifecycleListener;", "Lcom/braze/ui/inappmessage/listeners/IInAppMessageViewLifecycleListener;", "<init>", "()V", "inAppMessageManager", "Lcom/braze/ui/inappmessage/BrazeInAppMessageManager;", "getInAppMessageManager", "()Lcom/braze/ui/inappmessage/BrazeInAppMessageManager;", "beforeOpened", "", "inAppMessageView", "Landroid/view/View;", "inAppMessage", "Lcom/braze/models/inappmessage/IInAppMessage;", "afterOpened", "beforeClosed", "afterClosed", "onClicked", "inAppMessageCloser", "Lcom/braze/ui/inappmessage/InAppMessageCloser;", "onButtonClicked", "messageButton", "Lcom/braze/models/inappmessage/MessageButton;", "inAppMessageImmersive", "Lcom/braze/models/inappmessage/IInAppMessageImmersive;", "onDismissed", "performInAppMessageButtonClicked", "performInAppMessageClicked", "performClickAction", "clickAction", "Lcom/braze/enums/inappmessage/ClickAction;", "clickUri", "Landroid/net/Uri;", "openUriInWebview", "", "startClearHtmlInAppMessageAssetsThread", "android-sdk-ui_release"})
public class DefaultInAppMessageViewLifecycleListener
implements IInAppMessageViewLifecycleListener {
    private final BrazeInAppMessageManager getInAppMessageManager() {
        return BrazeInAppMessageManager.Companion.getInstance();
    }

    @Override
    public void beforeOpened(@NotNull View inAppMessageView, @NotNull IInAppMessage inAppMessage) {
        Intrinsics.checkNotNullParameter((Object)inAppMessageView, (String)"inAppMessageView");
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        this.getInAppMessageManager().getInAppMessageManagerListener().beforeInAppMessageViewOpened(inAppMessageView, inAppMessage);
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, DefaultInAppMessageViewLifecycleListener::beforeOpened$lambda$0, (int)7, null);
        inAppMessage.logImpression();
    }

    @Override
    public void afterOpened(@NotNull View inAppMessageView, @NotNull IInAppMessage inAppMessage) {
        Intrinsics.checkNotNullParameter((Object)inAppMessageView, (String)"inAppMessageView");
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, DefaultInAppMessageViewLifecycleListener::afterOpened$lambda$1, (int)7, null);
        this.getInAppMessageManager().getInAppMessageManagerListener().afterInAppMessageViewOpened(inAppMessageView, inAppMessage);
    }

    @Override
    public void beforeClosed(@NotNull View inAppMessageView, @NotNull IInAppMessage inAppMessage) {
        Intrinsics.checkNotNullParameter((Object)inAppMessageView, (String)"inAppMessageView");
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        this.getInAppMessageManager().getInAppMessageManagerListener().beforeInAppMessageViewClosed(inAppMessageView, inAppMessage);
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, DefaultInAppMessageViewLifecycleListener::beforeClosed$lambda$2, (int)7, null);
    }

    @Override
    public void afterClosed(@NotNull IInAppMessage inAppMessage) {
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, DefaultInAppMessageViewLifecycleListener::afterClosed$lambda$3, (int)7, null);
        this.getInAppMessageManager().resetAfterInAppMessageClose();
        if (inAppMessage instanceof IInAppMessageHtml) {
            this.startClearHtmlInAppMessageAssetsThread();
        }
        inAppMessage.onAfterClosed();
        this.getInAppMessageManager().getInAppMessageManagerListener().afterInAppMessageViewClosed(inAppMessage);
    }

    @Override
    public void onClicked(@NotNull InAppMessageCloser inAppMessageCloser, @NotNull View inAppMessageView, @NotNull IInAppMessage inAppMessage) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)inAppMessageCloser, (String)"inAppMessageCloser");
        Intrinsics.checkNotNullParameter((Object)inAppMessageView, (String)"inAppMessageView");
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, DefaultInAppMessageViewLifecycleListener::onClicked$lambda$4, (int)7, null);
        inAppMessage.logClick();
        try {
            boolean wasHandledLegacy = this.getInAppMessageManager().getInAppMessageManagerListener().onInAppMessageClicked(inAppMessage, inAppMessageCloser);
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, DefaultInAppMessageViewLifecycleListener::onClicked$lambda$5, (int)7, null);
            bl = wasHandledLegacy;
        }
        catch (BrazeFunctionNotImplemented e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, DefaultInAppMessageViewLifecycleListener::onClicked$lambda$6, (int)7, null);
            bl = this.getInAppMessageManager().getInAppMessageManagerListener().onInAppMessageClicked(inAppMessage);
        }
        boolean wasHandled = bl;
        if (!wasHandled) {
            this.performInAppMessageClicked(inAppMessage, inAppMessageCloser);
        }
    }

    @Override
    public void onButtonClicked(@NotNull InAppMessageCloser inAppMessageCloser, @NotNull MessageButton messageButton, @NotNull IInAppMessageImmersive inAppMessageImmersive) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)inAppMessageCloser, (String)"inAppMessageCloser");
        Intrinsics.checkNotNullParameter((Object)messageButton, (String)"messageButton");
        Intrinsics.checkNotNullParameter((Object)inAppMessageImmersive, (String)"inAppMessageImmersive");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, DefaultInAppMessageViewLifecycleListener::onButtonClicked$lambda$7, (int)7, null);
        inAppMessageImmersive.logButtonClick(messageButton);
        try {
            bl = this.getInAppMessageManager().getInAppMessageManagerListener().onInAppMessageButtonClicked((IInAppMessage)inAppMessageImmersive, messageButton, inAppMessageCloser);
        }
        catch (BrazeFunctionNotImplemented e) {
            bl = this.getInAppMessageManager().getInAppMessageManagerListener().onInAppMessageButtonClicked((IInAppMessage)inAppMessageImmersive, messageButton);
        }
        boolean wasHandled = bl;
        if (!wasHandled) {
            this.performInAppMessageButtonClicked(messageButton, (IInAppMessage)inAppMessageImmersive, inAppMessageCloser);
        }
    }

    @Override
    public void onDismissed(@NotNull View inAppMessageView, @NotNull IInAppMessage inAppMessage) {
        Intrinsics.checkNotNullParameter((Object)inAppMessageView, (String)"inAppMessageView");
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, DefaultInAppMessageViewLifecycleListener::onDismissed$lambda$8, (int)7, null);
        this.getInAppMessageManager().getInAppMessageManagerListener().onInAppMessageDismissed(inAppMessage);
    }

    private final void performInAppMessageButtonClicked(MessageButton messageButton, IInAppMessage inAppMessage, InAppMessageCloser inAppMessageCloser) {
        this.performClickAction(messageButton.getClickAction(), inAppMessage, inAppMessageCloser, messageButton.getUri(), messageButton.getOpenUriInWebview());
    }

    private final void performInAppMessageClicked(IInAppMessage inAppMessage, InAppMessageCloser inAppMessageCloser) {
        this.performClickAction(inAppMessage.getClickAction(), inAppMessage, inAppMessageCloser, inAppMessage.getUri(), inAppMessage.getOpenUriInWebView());
    }

    private final void performClickAction(ClickAction clickAction, IInAppMessage inAppMessage, InAppMessageCloser inAppMessageCloser, Uri clickUri, boolean openUriInWebview) {
        Activity activity = this.getInAppMessageManager().getActivity();
        if (activity == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, DefaultInAppMessageViewLifecycleListener::performClickAction$lambda$9, (int)6, null);
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[clickAction.ordinal()]) {
            case 1: {
                inAppMessageCloser.close(false);
                NewsfeedAction newsfeedAction = new NewsfeedAction(BundleUtils.toBundle((Map)inAppMessage.getExtras()), Channel.INAPP_MESSAGE);
                BrazeDeeplinkHandler.Companion.getInstance().gotoNewsFeed((Context)activity, newsfeedAction);
                break;
            }
            case 2: {
                inAppMessageCloser.close(false);
                if (clickUri == null) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, DefaultInAppMessageViewLifecycleListener::performClickAction$lambda$10, (int)7, null);
                    return;
                }
                UriAction uriAction = BrazeDeeplinkHandler.Companion.getInstance().createUriActionFromUri(clickUri, BundleUtils.toBundle((Map)inAppMessage.getExtras()), openUriInWebview, Channel.INAPP_MESSAGE);
                Context appContext = this.getInAppMessageManager().getApplicationContext();
                if (appContext == null) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, DefaultInAppMessageViewLifecycleListener::performClickAction$lambda$11, (int)7, null);
                    return;
                }
                BrazeDeeplinkHandler.Companion.getInstance().gotoUri(appContext, uriAction);
                break;
            }
            case 3: {
                inAppMessageCloser.close(inAppMessage.getAnimateOut());
                break;
            }
            default: {
                inAppMessageCloser.close(false);
            }
        }
    }

    private final void startClearHtmlInAppMessageAssetsThread() {
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)BrazeCoroutineScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Activity inAppMessageActivity = BrazeInAppMessageManager.Companion.getInstance().getActivity();
                        if (inAppMessageActivity != null) {
                            File internalStorageCacheDirectory = WebContentUtils.getHtmlInAppMessageAssetCacheDirectory((Context)((Context)inAppMessageActivity));
                            BrazeFileUtils.deleteFileOrDirectory((File)internalStorageCacheDirectory);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final String beforeOpened$lambda$0() {
        return "IInAppMessageViewLifecycleListener.beforeOpened called.";
    }

    private static final String afterOpened$lambda$1() {
        return "IInAppMessageViewLifecycleListener.afterOpened called.";
    }

    private static final String beforeClosed$lambda$2() {
        return "IInAppMessageViewLifecycleListener.beforeClosed called.";
    }

    private static final String afterClosed$lambda$3() {
        return "IInAppMessageViewLifecycleListener.afterClosed called.";
    }

    private static final String onClicked$lambda$4() {
        return "IInAppMessageViewLifecycleListener.onClicked called.";
    }

    private static final String onClicked$lambda$5() {
        return "Deprecated onInAppMessageClicked(inAppMessage, inAppMessageCloser) called.";
    }

    private static final String onClicked$lambda$6() {
        return "Using non-deprecated onInAppMessageClicked(inAppMessage)";
    }

    private static final String onButtonClicked$lambda$7() {
        return "IInAppMessageViewLifecycleListener.onButtonClicked called.";
    }

    private static final String onDismissed$lambda$8() {
        return "IInAppMessageViewLifecycleListener.onDismissed called.";
    }

    private static final String performClickAction$lambda$9() {
        return "Can't perform click action because the cached activity is null.";
    }

    private static final String performClickAction$lambda$10() {
        return "clickUri is null, not performing click action";
    }

    private static final String performClickAction$lambda$11() {
        return "appContext is null, not performing click action";
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClickAction.values().length];
            try {
                nArray[ClickAction.NEWS_FEED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickAction.URI.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickAction.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

