/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.inappmessage.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BlendMode;
import android.graphics.BlendModeColorFilter;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import com.braze.enums.inappmessage.TextAlign;
import com.braze.support.BrazeLogger;
import com.braze.ui.inappmessage.BrazeInAppMessageManager;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J2\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u001f\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0007\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0010H\u0007J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010H\u0007J\u001a\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u0010H\u0007J\u001a\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u0017\u001a\u00020\u0010H\u0007J\u001c\u0010\u001f\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010\u00132\b\u0010!\u001a\u0004\u0018\u00010\u0013H\u0007J\b\u0010\"\u001a\u00020\u0005H\u0007J\u0018\u0010#\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%H\u0007J\u001a\u0010&\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u0017\u001a\u00020\u0010H\u0002\u00a8\u0006'"}, d2={"Lcom/braze/ui/inappmessage/utils/InAppMessageViewUtils;", "", "<init>", "()V", "setImage", "", "bitmap", "Landroid/graphics/Bitmap;", "imageView", "Landroid/widget/ImageView;", "setIcon", "context", "Landroid/content/Context;", "icon", "", "iconColor", "", "iconBackgroundColor", "textView", "Landroid/widget/TextView;", "setFrameColor", "view", "Landroid/view/View;", "color", "(Landroid/view/View;Ljava/lang/Integer;)V", "setTextViewColor", "setViewBackgroundColor", "setViewBackgroundColorFilter", "setDrawableColor", "drawable", "Landroid/graphics/drawable/Drawable;", "resetMessageMarginsIfNecessary", "messageView", "headerView", "closeInAppMessageOnKeycodeBack", "setTextAlignment", "textAlign", "Lcom/braze/enums/inappmessage/TextAlign;", "setDrawableColorFilter", "android-sdk-ui_release"})
@SourceDebugExtension(value={"SMAP\nInAppMessageViewUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InAppMessageViewUtils.kt\ncom/braze/ui/inappmessage/utils/InAppMessageViewUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
public final class InAppMessageViewUtils {
    @NotNull
    public static final InAppMessageViewUtils INSTANCE = new InAppMessageViewUtils();

    private InAppMessageViewUtils() {
    }

    @JvmStatic
    public static final void setImage(@Nullable Bitmap bitmap, @NotNull ImageView imageView) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        if (bitmap != null) {
            imageView.setImageBitmap(bitmap);
        }
    }

    @JvmStatic
    public static final void setIcon(@NotNull Context context, @Nullable String icon, int iconColor, int iconBackgroundColor, @NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        if (icon != null) {
            try {
                textView.setTypeface(Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fontawesome-webfont.ttf"));
            }
            catch (Exception e) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, InAppMessageViewUtils::setIcon$lambda$0, (int)4, null);
                return;
            }
            textView.setText((CharSequence)icon);
            InAppMessageViewUtils.setTextViewColor(textView, iconColor);
            if (textView.getBackground() != null) {
                Drawable drawable2 = textView.getBackground();
                Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getBackground(...)");
                InAppMessageViewUtils.setDrawableColor(drawable2, iconBackgroundColor);
            } else {
                InAppMessageViewUtils.setViewBackgroundColor((View)textView, iconBackgroundColor);
            }
        }
    }

    @JvmStatic
    public static final void setFrameColor(@NotNull View view, @Nullable Integer color2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Integer n = color2;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            view.setBackgroundColor(it);
        }
    }

    @JvmStatic
    public static final void setTextViewColor(@NotNull TextView textView, int color2) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        textView.setTextColor(color2);
    }

    @JvmStatic
    public static final void setViewBackgroundColor(@NotNull View view, int color2) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setBackgroundColor(color2);
    }

    @JvmStatic
    public static final void setViewBackgroundColorFilter(@NotNull View view, @ColorInt int color2) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Drawable drawable2 = view.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getBackground(...)");
        INSTANCE.setDrawableColorFilter(drawable2, color2);
        view.getBackground().setAlpha(Color.alpha((int)color2));
    }

    @JvmStatic
    public static final void setDrawableColor(@NotNull Drawable drawable2, @ColorInt int color2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        if (drawable2 instanceof LayerDrawable) {
            if (((LayerDrawable)drawable2).getNumberOfLayers() > 0 && ((LayerDrawable)drawable2).getDrawable(0) instanceof GradientDrawable) {
                Drawable drawable3 = ((LayerDrawable)drawable2).getDrawable(0);
                Intrinsics.checkNotNullExpressionValue((Object)drawable3, (String)"getDrawable(...)");
                InAppMessageViewUtils.setDrawableColor(drawable3, color2);
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, InAppMessageViewUtils::setDrawableColor$lambda$2, (int)7, null);
            }
        }
        if (drawable2 instanceof GradientDrawable) {
            ((GradientDrawable)drawable2).setColor(color2);
        } else {
            INSTANCE.setDrawableColorFilter(drawable2, color2);
        }
    }

    @JvmStatic
    public static final void resetMessageMarginsIfNecessary(@Nullable TextView messageView, @Nullable TextView headerView) {
        if (headerView == null && messageView != null) {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(messageView.getLayoutParams().width, messageView.getLayoutParams().height);
            layoutParams.setMargins(0, 0, 0, 0);
            messageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    @JvmStatic
    public static final void closeInAppMessageOnKeycodeBack() {
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, InAppMessageViewUtils::closeInAppMessageOnKeycodeBack$lambda$3, (int)7, null);
        BrazeInAppMessageManager.Companion.getInstance().hideCurrentlyDisplayingInAppMessage(true);
    }

    @JvmStatic
    public static final void setTextAlignment(@NotNull TextView textView, @NotNull TextAlign textAlign) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        Intrinsics.checkNotNullParameter((Object)textAlign, (String)"textAlign");
        if (textAlign == TextAlign.START) {
            textView.setGravity(0x800003);
        } else if (textAlign == TextAlign.END) {
            textView.setGravity(0x800005);
        } else if (textAlign == TextAlign.CENTER) {
            textView.setGravity(17);
        }
    }

    private final void setDrawableColorFilter(Drawable drawable2, @ColorInt int color2) {
        if (Build.VERSION.SDK_INT >= 29) {
            drawable2.setColorFilter((ColorFilter)new BlendModeColorFilter(color2, BlendMode.SRC_ATOP));
        } else {
            drawable2.setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
        }
    }

    private static final String setIcon$lambda$0() {
        return "Caught exception setting icon typeface. Not rendering icon.";
    }

    private static final String setDrawableColor$lambda$2() {
        return "LayerDrawable for button background did not have the expected number of layers or the 0th layer was not a GradientDrawable.";
    }

    private static final String closeInAppMessageOnKeycodeBack$lambda$3() {
        return "Back button intercepted by in-app message view, closing in-app message.";
    }
}

